/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIProduct;
import org.wso2.carbon.apimgt.api.model.APIProductIdentifier;
import org.wso2.carbon.apimgt.api.model.Environment;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.APIGatewayManager$AjcClosure1;
import org.wso2.carbon.apimgt.impl.APIGatewayManager$AjcClosure11;
import org.wso2.carbon.apimgt.impl.APIGatewayManager$AjcClosure13;
import org.wso2.carbon.apimgt.impl.APIGatewayManager$AjcClosure15;
import org.wso2.carbon.apimgt.impl.APIGatewayManager$AjcClosure17;
import org.wso2.carbon.apimgt.impl.APIGatewayManager$AjcClosure19;
import org.wso2.carbon.apimgt.impl.APIGatewayManager$AjcClosure3;
import org.wso2.carbon.apimgt.impl.APIGatewayManager$AjcClosure5;
import org.wso2.carbon.apimgt.impl.APIGatewayManager$AjcClosure7;
import org.wso2.carbon.apimgt.impl.APIGatewayManager$AjcClosure9;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.MethodStats;
import org.wso2.carbon.apimgt.impl.MethodTimeLogger;
import org.wso2.carbon.apimgt.impl.dao.GatewayArtifactsMgtDAO;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.ArtifactSaver;
import org.wso2.carbon.apimgt.impl.gatewayartifactsynchronizer.exception.ArtifactSynchronizerException;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.notifier.events.APIEvent;
import org.wso2.carbon.apimgt.impl.notifier.events.DeployAPIInGatewayEvent;
import org.wso2.carbon.apimgt.impl.recommendationmgt.RecommendationEnvironment;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class APIGatewayManager {
    private static final Log log;
    private boolean debugEnabled = log.isDebugEnabled();
    private static APIGatewayManager instance;
    private Map<String, Environment> environments;
    private RecommendationEnvironment recommendationEnvironment;
    private ArtifactSaver artifactSaver;
    private static final String PRODUCT_PREFIX = "prod";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        APIGatewayManager.ajc$preClinit();
        log = LogFactory.getLog(APIGatewayManager.class);
    }

    private APIGatewayManager() {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        try {
            this.environments = APIUtil.getEnvironments();
        }
        catch (APIManagementException e) {
            log.error((Object)"Error occurred when reading configured gateway environments", (Throwable)e);
        }
        this.recommendationEnvironment = config.getApiRecommendationEnvironment();
        this.artifactSaver = ServiceReferenceHolder.getInstance().getArtifactSaver();
    }

    public static synchronized APIGatewayManager getInstance() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{joinPoint};
            return (APIGatewayManager)MethodTimeLogger.aspectOf().log(new APIGatewayManager$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
        }
        return APIGatewayManager.getInstance_aroundBody0(joinPoint);
    }

    private void sendDeploymentEvent(API api, String tenantDomain, Set<String> publishedGateways) {
        API aPI = api;
        String string = tenantDomain;
        Set<String> set = publishedGateways;
        Object[] objectArray = new Object[]{aPI, string, set};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, aPI, string, set, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIGatewayManager$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        APIGatewayManager.sendDeploymentEvent_aroundBody2(this, aPI, string, set, joinPoint);
    }

    private void sendDeploymentEvent(APIProduct api, String tenantDomain, Set<String> publishedGateways) {
        APIProduct aPIProduct = api;
        String string = tenantDomain;
        Set<String> set = publishedGateways;
        Object[] objectArray = new Object[]{aPIProduct, string, set};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, aPIProduct, string, set, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIGatewayManager$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        APIGatewayManager.sendDeploymentEvent_aroundBody4(this, aPIProduct, string, set, joinPoint);
    }

    private void sendUnDeploymentEvent(API api, String tenantDomain, Set<String> removedGateways) {
        API aPI = api;
        String string = tenantDomain;
        Set<String> set = removedGateways;
        Object[] objectArray = new Object[]{aPI, string, set};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, aPI, string, set, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIGatewayManager$AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        APIGatewayManager.sendUnDeploymentEvent_aroundBody6(this, aPI, string, set, joinPoint);
    }

    private void sendUnDeploymentEvent(APIProduct apiProduct, String tenantDomain, Set<String> removedGateways, Set<API> associatedAPIs) {
        APIProduct aPIProduct = apiProduct;
        String string = tenantDomain;
        Set<String> set = removedGateways;
        Set<API> set2 = associatedAPIs;
        Object[] objectArray = new Object[]{aPIProduct, string, set, set2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, aPIProduct, string, set, set2, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIGatewayManager$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        APIGatewayManager.sendUnDeploymentEvent_aroundBody8(this, aPIProduct, string, set, set2, joinPoint);
    }

    public void deployToGateway(API api, String tenantDomain, Set<String> gatewaysToPublish) {
        API aPI = api;
        String string = tenantDomain;
        Set<String> set = gatewaysToPublish;
        Object[] objectArray = new Object[]{aPI, string, set};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, aPI, string, set, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIGatewayManager$AjcClosure11(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        APIGatewayManager.deployToGateway_aroundBody10(this, aPI, string, set, joinPoint);
    }

    public void deployToGateway(APIProduct api, String tenantDomain, Set<String> gatewaysToPublish) {
        APIProduct aPIProduct = api;
        String string = tenantDomain;
        Set<String> set = gatewaysToPublish;
        Object[] objectArray = new Object[]{aPIProduct, string, set};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, aPIProduct, string, set, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIGatewayManager$AjcClosure13(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        APIGatewayManager.deployToGateway_aroundBody12(this, aPIProduct, string, set, joinPoint);
    }

    public void unDeployFromGateway(API api, String tenantDomain, Set<String> gatewaysToRemove) {
        API aPI = api;
        String string = tenantDomain;
        Set<String> set = gatewaysToRemove;
        Object[] objectArray = new Object[]{aPI, string, set};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, aPI, string, set, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIGatewayManager$AjcClosure15(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        APIGatewayManager.unDeployFromGateway_aroundBody14(this, aPI, string, set, joinPoint);
    }

    public void unDeployFromGateway(APIProduct apiProduct, String tenantDomain, Set<API> associatedAPIs, Set<String> gatewaysToRemove) throws APIManagementException {
        APIProduct aPIProduct = apiProduct;
        String string = tenantDomain;
        Set<API> set = associatedAPIs;
        Set<String> set2 = gatewaysToRemove;
        Object[] objectArray = new Object[]{aPIProduct, string, set, set2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray2 = new Object[]{this, aPIProduct, string, set, set2, joinPoint};
            MethodTimeLogger.aspectOf().log(new APIGatewayManager$AjcClosure17(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        APIGatewayManager.unDeployFromGateway_aroundBody16(this, aPIProduct, string, set, set2, joinPoint);
    }

    private Set<APIEvent> transformAPIToAPIEvent(Set<API> apiSet) {
        Set<API> set = apiSet;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, set);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll() || this != null && this.getClass().isAnnotationPresent(MethodStats.class) && MethodTimeLogger.isConfigEnabled()) {
            Object[] objectArray = new Object[]{this, set, joinPoint};
            return (Set)MethodTimeLogger.aspectOf().log(new APIGatewayManager$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
        }
        return APIGatewayManager.transformAPIToAPIEvent_aroundBody18(this, set, joinPoint);
    }

    static final /* synthetic */ APIGatewayManager getInstance_aroundBody0(JoinPoint joinPoint) {
        if (instance == null) {
            instance = new APIGatewayManager();
        }
        return instance;
    }

    static final /* synthetic */ void sendDeploymentEvent_aroundBody2(APIGatewayManager ajc$this, API api, String tenantDomain, Set publishedGateways, JoinPoint joinPoint) {
        APIIdentifier apiIdentifier = api.getId();
        DeployAPIInGatewayEvent deployAPIInGatewayEvent = new DeployAPIInGatewayEvent(UUID.randomUUID().toString(), System.currentTimeMillis(), APIConstants.EventType.DEPLOY_API_IN_GATEWAY.name(), tenantDomain, api.getId().getId(), api.getUuid(), publishedGateways, apiIdentifier.getName(), apiIdentifier.getVersion(), apiIdentifier.getProviderName(), api.getType(), api.getContext());
        APIUtil.sendNotification(deployAPIInGatewayEvent, APIConstants.NotifierType.GATEWAY_PUBLISHED_API.name());
        if (ajc$this.debugEnabled) {
            log.debug((Object)("Event sent to Gateway with eventID " + deployAPIInGatewayEvent.getEventId() + " for api " + "with apiID " + api + " at " + deployAPIInGatewayEvent.getTimeStamp()));
        }
    }

    static final /* synthetic */ void sendDeploymentEvent_aroundBody4(APIGatewayManager ajc$this, APIProduct api, String tenantDomain, Set publishedGateways, JoinPoint joinPoint) {
        APIProductIdentifier apiIdentifier = api.getId();
        DeployAPIInGatewayEvent deployAPIInGatewayEvent = new DeployAPIInGatewayEvent(UUID.randomUUID().toString(), System.currentTimeMillis(), APIConstants.EventType.DEPLOY_API_IN_GATEWAY.name(), tenantDomain, api.getProductId(), api.getUuid(), publishedGateways, apiIdentifier.getName(), apiIdentifier.getVersion(), PRODUCT_PREFIX, api.getType(), api.getContext());
        APIUtil.sendNotification(deployAPIInGatewayEvent, APIConstants.NotifierType.GATEWAY_PUBLISHED_API.name());
        if (ajc$this.debugEnabled) {
            log.debug((Object)("Event sent to Gateway with eventID " + deployAPIInGatewayEvent.getEventId() + " for api " + "with apiID " + api + " at " + deployAPIInGatewayEvent.getTimeStamp()));
        }
    }

    static final /* synthetic */ void sendUnDeploymentEvent_aroundBody6(APIGatewayManager ajc$this, API api, String tenantDomain, Set removedGateways, JoinPoint joinPoint) {
        APIIdentifier apiIdentifier = api.getId();
        DeployAPIInGatewayEvent deployAPIInGatewayEvent = new DeployAPIInGatewayEvent(UUID.randomUUID().toString(), System.currentTimeMillis(), APIConstants.EventType.REMOVE_API_FROM_GATEWAY.name(), tenantDomain, api.getId().getId(), api.getUuid(), removedGateways, apiIdentifier.getName(), apiIdentifier.getVersion(), apiIdentifier.getProviderName(), api.getType(), api.getContext());
        APIUtil.sendNotification(deployAPIInGatewayEvent, APIConstants.NotifierType.GATEWAY_PUBLISHED_API.name());
    }

    static final /* synthetic */ void sendUnDeploymentEvent_aroundBody8(APIGatewayManager ajc$this, APIProduct apiProduct, String tenantDomain, Set removedGateways, Set associatedAPIs, JoinPoint joinPoint) {
        APIProductIdentifier apiProductIdentifier = apiProduct.getId();
        Set<APIEvent> apiEvents = ajc$this.transformAPIToAPIEvent(associatedAPIs);
        DeployAPIInGatewayEvent deployAPIInGatewayEvent = new DeployAPIInGatewayEvent(UUID.randomUUID().toString(), System.currentTimeMillis(), APIConstants.EventType.REMOVE_API_FROM_GATEWAY.name(), tenantDomain, apiProduct.getProductId(), apiProduct.getUuid(), removedGateways, apiProductIdentifier.getName(), apiProductIdentifier.getVersion(), PRODUCT_PREFIX, "APIProduct", apiProduct.getContext(), apiEvents);
        APIUtil.sendNotification(deployAPIInGatewayEvent, APIConstants.NotifierType.GATEWAY_PUBLISHED_API.name());
    }

    static final /* synthetic */ void deployToGateway_aroundBody10(APIGatewayManager ajc$this, API api, String tenantDomain, Set gatewaysToPublish, JoinPoint joinPoint) {
        if (ajc$this.debugEnabled) {
            log.debug((Object)("Status of " + api.getId() + " has been updated to DB"));
        }
        ajc$this.sendDeploymentEvent(api, tenantDomain, (Set<String>)gatewaysToPublish);
    }

    static final /* synthetic */ void deployToGateway_aroundBody12(APIGatewayManager ajc$this, APIProduct api, String tenantDomain, Set gatewaysToPublish, JoinPoint joinPoint) {
        if (ajc$this.debugEnabled) {
            log.debug((Object)("Status of " + api.getId() + " has been updated to DB"));
        }
        ajc$this.sendDeploymentEvent(api, tenantDomain, (Set<String>)gatewaysToPublish);
    }

    static final /* synthetic */ void unDeployFromGateway_aroundBody14(APIGatewayManager ajc$this, API api, String tenantDomain, Set gatewaysToRemove, JoinPoint joinPoint) {
        if (ajc$this.debugEnabled) {
            log.debug((Object)("Status of " + api.getId() + " has been updated to DB"));
        }
        ajc$this.sendUnDeploymentEvent(api, tenantDomain, gatewaysToRemove);
    }

    static final /* synthetic */ void unDeployFromGateway_aroundBody16(APIGatewayManager ajc$this, APIProduct apiProduct, String tenantDomain, Set associatedAPIs, Set gatewaysToRemove, JoinPoint joinPoint) {
        String apiProductUuid = apiProduct.getUuid();
        APIProductIdentifier apiProductIdentifier = apiProduct.getId();
        try {
            if (ajc$this.artifactSaver != null) {
                ajc$this.artifactSaver.removeArtifact(apiProductUuid, apiProductIdentifier.getName(), apiProductIdentifier.getVersion(), "Current", tenantDomain);
            }
            GatewayArtifactsMgtDAO.getInstance().deleteGatewayArtifact(apiProductUuid, "Current");
            GatewayArtifactsMgtDAO.getInstance().removePublishedGatewayLabels(apiProductUuid, "Current");
        }
        catch (ArtifactSynchronizerException e) {
            throw new APIManagementException("API " + apiProductIdentifier + "couldn't get unDeployed", (Throwable)e);
        }
        if (ajc$this.debugEnabled) {
            log.debug((Object)("Status of " + apiProductIdentifier + " has been updated to DB"));
        }
        ajc$this.sendUnDeploymentEvent(apiProduct, tenantDomain, gatewaysToRemove, associatedAPIs);
    }

    static final /* synthetic */ Set transformAPIToAPIEvent_aroundBody18(APIGatewayManager ajc$this, Set apiSet, JoinPoint joinPoint) {
        HashSet<APIEvent> apiEvents = new HashSet<APIEvent>();
        for (API api : apiSet) {
            APIIdentifier id = api.getId();
            APIEvent apiEvent = new APIEvent(id.getUUID(), id.getApiName(), id.getVersion(), id.getProviderName(), api.getType(), api.getStatus());
            apiEvents.add(apiEvent);
        }
        return apiEvents;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("APIGatewayManager.java", APIGatewayManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("29", "getInstance", "org.wso2.carbon.apimgt.impl.APIGatewayManager", "", "", "", "org.wso2.carbon.apimgt.impl.APIGatewayManager"), 66);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "sendDeploymentEvent", "org.wso2.carbon.apimgt.impl.APIGatewayManager", "org.wso2.carbon.apimgt.api.model.API:java.lang.String:java.util.Set", "api:tenantDomain:publishedGateways", "", "void"), 73);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "sendDeploymentEvent", "org.wso2.carbon.apimgt.impl.APIGatewayManager", "org.wso2.carbon.apimgt.api.model.APIProduct:java.lang.String:java.util.Set", "api:tenantDomain:publishedGateways", "", "void"), 88);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "sendUnDeploymentEvent", "org.wso2.carbon.apimgt.impl.APIGatewayManager", "org.wso2.carbon.apimgt.api.model.API:java.lang.String:java.util.Set", "api:tenantDomain:removedGateways", "", "void"), 103);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "sendUnDeploymentEvent", "org.wso2.carbon.apimgt.impl.APIGatewayManager", "org.wso2.carbon.apimgt.api.model.APIProduct:java.lang.String:java.util.Set:java.util.Set", "apiProduct:tenantDomain:removedGateways:associatedAPIs", "", "void"), 116);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deployToGateway", "org.wso2.carbon.apimgt.impl.APIGatewayManager", "org.wso2.carbon.apimgt.api.model.API:java.lang.String:java.util.Set", "api:tenantDomain:gatewaysToPublish", "", "void"), 130);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deployToGateway", "org.wso2.carbon.apimgt.impl.APIGatewayManager", "org.wso2.carbon.apimgt.api.model.APIProduct:java.lang.String:java.util.Set", "api:tenantDomain:gatewaysToPublish", "", "void"), 138);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unDeployFromGateway", "org.wso2.carbon.apimgt.impl.APIGatewayManager", "org.wso2.carbon.apimgt.api.model.API:java.lang.String:java.util.Set", "api:tenantDomain:gatewaysToRemove", "", "void"), 145);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unDeployFromGateway", "org.wso2.carbon.apimgt.impl.APIGatewayManager", "org.wso2.carbon.apimgt.api.model.APIProduct:java.lang.String:java.util.Set:java.util.Set", "apiProduct:tenantDomain:associatedAPIs:gatewaysToRemove", "org.wso2.carbon.apimgt.api.APIManagementException", "void"), 153);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "transformAPIToAPIEvent", "org.wso2.carbon.apimgt.impl.APIGatewayManager", "java.util.Set", "apiSet", "", "java.util.Set"), 176);
    }
}

