/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.core.exception.DataBridgeConfigurationException;

public final class DataBridgeCoreBuilder {
    private static final Log log = LogFactory.getLog(DataBridgeCoreBuilder.class);

    private DataBridgeCoreBuilder() {
    }

    public static List<String[]> loadStreamDefinitionXML() throws DataBridgeConfigurationException {
        OMElement config;
        ArrayList<String[]> streamDefinitionList = new ArrayList<String[]>();
        String carbonHome = System.getProperty("carbon.config.dir.path");
        String path = carbonHome + File.separator + "data-bridge" + File.separator + "stream-definitions.xml";
        File file = new File(path);
        if (file.exists() && !file.isDirectory() && (config = DataBridgeCoreBuilder.loadXML(path, "stream-definitions.xml")) != null) {
            if (!new QName("http://wso2.org/carbon/databridge", "streamDefinitions").equals(config.getQName())) {
                throw new DataBridgeConfigurationException("Wrong configuration added in stream-definitions.xml");
            }
            Iterator streamDefinitionIterator = config.getChildElements();
            while (streamDefinitionIterator.hasNext()) {
                OMElement streamDefinition = (OMElement)streamDefinitionIterator.next();
                String domainName = streamDefinition.getAttributeValue(new QName("domainName"));
                if (domainName == null || domainName.equals("")) {
                    domainName = "carbon.super";
                }
                streamDefinitionList.add(new String[]{domainName, streamDefinition.getText()});
            }
        }
        return streamDefinitionList;
    }

    public static String getDatabridgeConfigPath() {
        String carbonHome = System.getProperty("carbon.config.dir.path");
        return carbonHome + File.separator + "data-bridge" + File.separator + "data-bridge-config.xml";
    }

    public static OMElement loadXML(String path, String fileName) throws DataBridgeConfigurationException {
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(new File(path)));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement omElement = builder.getDocumentElement();
            omElement.build();
            OMElement oMElement = omElement;
            return oMElement;
        }
        catch (FileNotFoundException e) {
            String errorMessage = fileName + " cannot be found in the path : " + path;
            log.error((Object)errorMessage, (Throwable)e);
            throw new DataBridgeConfigurationException(errorMessage, e);
        }
        catch (XMLStreamException e) {
            String errorMessage = "Invalid XML for " + fileName + " located in the path : " + path;
            log.error((Object)errorMessage, (Throwable)e);
            throw new DataBridgeConfigurationException(errorMessage, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                String errorMessage = "Can not close the input stream";
                log.error((Object)errorMessage, (Throwable)e);
            }
        }
    }
}

