/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal.queue;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.core.AgentCallback;
import org.wso2.carbon.databridge.core.RawDataAgentCallback;
import org.wso2.carbon.databridge.core.Utils.EventComposite;
import org.wso2.carbon.databridge.core.exception.EventConversionException;

public class QueueWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(QueueWorker.class);
    private BlockingQueue<EventComposite> eventQueue;
    private List<AgentCallback> subscribers;
    private List<RawDataAgentCallback> rawDataSubscribers;

    public QueueWorker(BlockingQueue<EventComposite> queue, List<AgentCallback> subscribers, List<RawDataAgentCallback> rawDataSubscribers) {
        this.eventQueue = queue;
        this.subscribers = subscribers;
        this.rawDataSubscribers = rawDataSubscribers;
    }

    @Override
    public void run() {
        block14: {
            List<Event> eventList = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.eventQueue.size() + " messages in queue before " + Thread.currentThread().getName() + " worker has polled queue"));
                }
                EventComposite eventComposite = (EventComposite)this.eventQueue.poll();
                if (this.rawDataSubscribers.size() > 0) {
                    for (RawDataAgentCallback rawDataAgentCallback : this.rawDataSubscribers) {
                        try {
                            rawDataAgentCallback.receive(eventComposite);
                        }
                        catch (Throwable e) {
                            log.error((Object)("Error in passing event composite " + eventComposite + " to subscriber " + rawDataAgentCallback), e);
                        }
                    }
                }
                if (this.subscribers.size() <= 0) break block14;
                try {
                    eventList = eventComposite.getEventConverter().toEventList(eventComposite.getEventBundle(), eventComposite.getStreamTypeHolder());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dispatching event to " + this.subscribers.size() + " subscriber(s)"));
                    }
                    for (AgentCallback agentCallback : this.subscribers) {
                        try {
                            agentCallback.receive(eventList, eventComposite.getAgentSession().getCredentials());
                        }
                        catch (Throwable e) {
                            log.error((Object)("Error in passing event eventList " + eventList + " to subscriber " + agentCallback), e);
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.eventQueue.size() + " messages in queue after " + Thread.currentThread().getName() + " worker has finished work"));
                    }
                }
                catch (EventConversionException re) {
                    log.error((Object)("Dropping wrongly formatted event sent for " + eventComposite.getStreamTypeHolder().getTenantId()), (Throwable)re);
                }
            }
            catch (Throwable e) {
                log.error((Object)("Error in passing events " + eventList + " to subscribers " + this.subscribers + " " + this.rawDataSubscribers), e);
            }
        }
    }
}

