/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal.queue;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.utils.DataBridgeThreadFactory;
import org.wso2.carbon.databridge.core.AgentCallback;
import org.wso2.carbon.databridge.core.RawDataAgentCallback;
import org.wso2.carbon.databridge.core.Utils.EventComposite;
import org.wso2.carbon.databridge.core.conf.DataBridgeConfiguration;
import org.wso2.carbon.databridge.core.internal.queue.EventBlockingQueue;
import org.wso2.carbon.databridge.core.internal.queue.QueueWorker;

public class EventQueue {
    private static final Log log = LogFactory.getLog(EventQueue.class);
    private BlockingQueue<EventComposite> eventQueue;
    private ExecutorService executorService;
    private List<AgentCallback> subscribers;
    private List<RawDataAgentCallback> rawDataSubscribers;

    public EventQueue(List<AgentCallback> subscribers, List<RawDataAgentCallback> rawDataSubscribers, DataBridgeConfiguration dataBridgeConfiguration) {
        this.subscribers = subscribers;
        this.rawDataSubscribers = rawDataSubscribers;
        this.executorService = Executors.newFixedThreadPool(dataBridgeConfiguration.getWorkerThreads(), (ThreadFactory)new DataBridgeThreadFactory("Core"));
        this.eventQueue = new EventBlockingQueue(dataBridgeConfiguration.getEventBufferSize(), dataBridgeConfiguration.getMaxEventBufferCapacity());
    }

    public void publish(EventComposite eventComposite) {
        try {
            this.eventQueue.put(eventComposite);
        }
        catch (InterruptedException e) {
            String logMessage = "Failure to insert event into queue";
            log.warn((Object)logMessage);
        }
        this.executorService.submit(new QueueWorker(this.eventQueue, this.subscribers, this.rawDataSubscribers));
    }

    protected void finalize() throws Throwable {
        this.executorService.shutdown();
        super.finalize();
    }
}

