/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal.queue;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.core.Utils.DataBridgeUtils;
import org.wso2.carbon.databridge.core.Utils.EventComposite;

public class EventBlockingQueue
extends ArrayBlockingQueue<EventComposite> {
    private static final Log log = LogFactory.getLog(EventBlockingQueue.class);
    private final Object lock = new Object();
    private AtomicInteger currentSize = new AtomicInteger(0);
    private int currentEventCompositeSize;
    private int maxSize;
    private Semaphore semaphore;

    public EventBlockingQueue(int maxQueueSize, int maxSizeCapacity) {
        super(maxQueueSize);
        this.maxSize = maxSizeCapacity;
        this.semaphore = new Semaphore(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void put(EventComposite eventComposite) {
        block13: {
            eventComposite.setSize(DataBridgeUtils.getSize(eventComposite));
            this.currentEventCompositeSize = eventComposite.getSize();
            if (this.currentSize.get() >= this.maxSize) {
                try {
                    this.semaphore.acquire();
                    if (this.semaphore.availablePermits() != 0) break block13;
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.semaphore.availablePermits() == 0) {
                            this.semaphore.release();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            super.put(eventComposite);
            if (this.currentSize.addAndGet(eventComposite.getSize()) >= this.maxSize) {
                try {
                    this.semaphore.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("current queue size in bytes : " + this.currentSize + " , elements : " + this.size()));
            }
        }
        catch (InterruptedException e) {
            String logMessage = "Failure to insert event into queue";
            log.warn((Object)logMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventComposite poll() {
        EventComposite eventComposite = (EventComposite)super.poll();
        this.currentSize.addAndGet(-eventComposite.getSize());
        if (this.semaphore.availablePermits() == 0 && this.currentEventCompositeSize + this.currentSize.get() < this.maxSize || this.isEmpty()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.semaphore.availablePermits() == 0 && this.currentEventCompositeSize + this.currentSize.get() < this.maxSize || this.isEmpty()) {
                    this.semaphore.release();
                }
            }
        }
        return eventComposite;
    }
}

