/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal.authentication.session;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.wso2.carbon.databridge.core.Utils.AgentSession;
import org.wso2.carbon.databridge.core.internal.authentication.session.SessionBean;

public class SessionCache {
    private LoadingCache<SessionBean, AgentSession> cache;

    public SessionCache(int expirationTimeInMinutes) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite((long)expirationTimeInMinutes, TimeUnit.MINUTES).build(CacheLoader.from((Function)new SessionFunction()));
    }

    public AgentSession getSession(SessionBean sessionBean) {
        try {
            return (AgentSession)this.cache.get((Object)sessionBean);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeSession(String sessionId) {
        this.cache.invalidate((Object)new SessionBean(sessionId));
    }

    static class SessionFunction
    implements Function<SessionBean, AgentSession> {
        SessionFunction() {
        }

        public AgentSession apply(SessionBean sessionBean) {
            return new AgentSession(sessionBean.getSessionId(), sessionBean.getCredentials());
        }
    }
}

