/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal.authentication;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.databridge.core.DataBridgeServiceValueHolder;
import org.wso2.carbon.databridge.core.Utils.AgentSession;
import org.wso2.carbon.databridge.core.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.identity.authentication.AuthenticationService;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CarbonAuthenticationHandler
implements AuthenticationHandler {
    private AuthenticationService authenticationService;
    private static final Log log = LogFactory.getLog(CarbonAuthenticationHandler.class);

    public CarbonAuthenticationHandler(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @Override
    public boolean authenticate(String userName, String password) {
        boolean authenticated;
        PrivilegedCarbonContext.destroyCurrentContext();
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        if (privilegedCarbonContext.getTenantDomain() == null) {
            privilegedCarbonContext.setTenantDomain("carbon.super");
            privilegedCarbonContext.setTenantId(-1234);
        }
        if (authenticated = this.authenticationService.authenticate(userName, password)) {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
            String tenantLessUserName = MultitenantUtils.getTenantAwareUsername((String)userName);
            try {
                int tenantId = DataBridgeServiceValueHolder.getRealmService().getTenantManager().getTenantId(tenantDomain);
                authenticated = DataBridgeServiceValueHolder.getRealmService().getTenantUserRealm(tenantId).getAuthorizationManager().isUserAuthorized(tenantLessUserName, "/permission/admin/publish/wso2event", "ui.execute");
            }
            catch (UserStoreException e) {
                log.error((Object)("Error while checking the authorization of the user" + userName + ". " + e.getMessage()), (Throwable)e);
            }
            try {
                if (!"carbon.super".equals(tenantDomain)) {
                    TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)DataBridgeServiceValueHolder.getConfigurationContextService().getServerConfigContext());
                }
            }
            catch (Exception e) {
                log.error((Object)"Error trying load tenant after successful login", (Throwable)e);
            }
        }
        return authenticated;
    }

    @Override
    public String getTenantDomain(String userName) {
        return MultitenantUtils.getTenantDomain((String)userName);
    }

    @Override
    public int getTenantId(String tenantDomain) throws UserStoreException {
        return DataBridgeServiceValueHolder.getRealmService().getTenantManager().getTenantId(tenantDomain);
    }

    @Override
    public void initContext(AgentSession agentSession) {
        int tenantId = agentSession.getCredentials().getTenantId();
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        privilegedCarbonContext.setTenantId(tenantId);
        privilegedCarbonContext.setTenantDomain(agentSession.getDomainName());
    }

    @Override
    public void destroyContext(AgentSession agentSession) {
        PrivilegedCarbonContext.endTenantFlow();
    }
}

