/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal.authentication;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Credentials;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.core.Utils.AgentSession;
import org.wso2.carbon.databridge.core.conf.DataBridgeConfiguration;
import org.wso2.carbon.databridge.core.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.databridge.core.internal.authentication.session.SessionBean;
import org.wso2.carbon.databridge.core.internal.authentication.session.SessionCache;
import org.wso2.carbon.user.api.UserStoreException;

public final class Authenticator {
    private static final Log log = LogFactory.getLog(Authenticator.class);
    private SessionCache sessionCache;
    private AuthenticationHandler authenticationHandler;

    public Authenticator(AuthenticationHandler authenticationHandler, DataBridgeConfiguration dataBridgeConfiguration) {
        this.authenticationHandler = authenticationHandler;
        this.sessionCache = new SessionCache(dataBridgeConfiguration.getClientTimeoutMin());
    }

    public String authenticate(String userName, String password) throws AuthenticationException {
        if (userName == null) {
            this.logAndAuthenticationException("Authentication request was missing the user name ");
        }
        if (password == null) {
            this.logAndAuthenticationException("Authentication request was missing the required password");
        }
        boolean isSuccessful = false;
        try {
            isSuccessful = this.authenticationHandler.authenticate(userName, password);
        }
        catch (Exception e) {
            throw new AuthenticationException((Throwable)e);
        }
        if (isSuccessful) {
            String sessionId = UUID.randomUUID().toString();
            int tenantId = 0;
            try {
                String tenantDomain = this.authenticationHandler.getTenantDomain(userName);
                tenantId = this.authenticationHandler.getTenantId(tenantDomain);
            }
            catch (UserStoreException e) {
                this.logAndAuthenticationException("Could not resolve the user to a valid tenant.");
            }
            Credentials credentials = new Credentials(userName, password, this.authenticationHandler.getTenantDomain(userName), tenantId);
            this.sessionCache.getSession(new SessionBean(sessionId, credentials));
            return sessionId;
        }
        this.logAndAuthenticationException("wrong userName or password");
        return null;
    }

    private void logAndAuthenticationException(String msg) throws AuthenticationException {
        log.error((Object)msg);
        throw new AuthenticationException(msg);
    }

    public void logout(String sessionId) {
        this.sessionCache.removeSession(sessionId);
    }

    public AgentSession getSession(String sessionId) {
        return this.sessionCache.getSession(new SessionBean(sessionId));
    }
}

