/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;
import org.wso2.carbon.databridge.core.AgentCallback;
import org.wso2.carbon.databridge.core.EventConverter;
import org.wso2.carbon.databridge.core.RawDataAgentCallback;
import org.wso2.carbon.databridge.core.StreamAttributeComposite;
import org.wso2.carbon.databridge.core.StreamTypeHolder;
import org.wso2.carbon.databridge.core.Utils.AgentSession;
import org.wso2.carbon.databridge.core.Utils.EventComposite;
import org.wso2.carbon.databridge.core.conf.DataBridgeConfiguration;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.definitionstore.StreamAddRemoveListener;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.databridge.core.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.databridge.core.internal.queue.EventQueue;

public class EventDispatcher {
    private List<AgentCallback> subscribers = new ArrayList<AgentCallback>();
    private List<RawDataAgentCallback> rawDataSubscribers = new ArrayList<RawDataAgentCallback>();
    private AbstractStreamDefinitionStore streamDefinitionStore;
    private Map<Integer, StreamTypeHolder> domainNameStreamTypeHolderCache = new ConcurrentHashMap<Integer, StreamTypeHolder>();
    private EventQueue eventQueue;
    private AuthenticationHandler authenticationHandler;
    private static final Log log = LogFactory.getLog(EventDispatcher.class);

    public EventDispatcher(AbstractStreamDefinitionStore streamDefinitionStore, DataBridgeConfiguration dataBridgeConfiguration, AuthenticationHandler authenticationHandler) {
        this.eventQueue = new EventQueue(this.subscribers, this.rawDataSubscribers, dataBridgeConfiguration);
        this.streamDefinitionStore = streamDefinitionStore;
        this.authenticationHandler = authenticationHandler;
        streamDefinitionStore.subscribe(new StreamAddRemoveListener(){

            @Override
            public void streamAdded(int tenantId, String streamId) {
            }

            @Override
            public void streamRemoved(int tenantId, String streamId) {
                EventDispatcher.this.removeStreamDefinitionFromStreamTypeHolder(tenantId, streamId);
            }
        });
    }

    public void addCallback(AgentCallback agentCallback) {
        this.subscribers.add(agentCallback);
    }

    public void addCallback(RawDataAgentCallback agentCallback) {
        this.rawDataSubscribers.add(agentCallback);
    }

    public synchronized String defineStream(String streamDefinition, AgentSession agentSession) throws MalformedStreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException, StreamDefinitionStoreException {
        int tenantId = agentSession.getCredentials().getTenantId();
        StreamDefinition newStreamDefinition = EventDefinitionConverterUtils.convertFromJson((String)streamDefinition);
        StreamTypeHolder streamTypeHolder = this.getStreamDefinitionHolder(tenantId);
        StreamAttributeComposite attributeComposite = streamTypeHolder.getAttributeComposite(newStreamDefinition.getStreamId());
        if (attributeComposite != null) {
            StreamDefinition existingStreamDefinition = attributeComposite.getStreamDefinition();
            if (!existingStreamDefinition.equals((Object)newStreamDefinition)) {
                throw new DifferentStreamDefinitionAlreadyDefinedException("Similar event stream for " + newStreamDefinition + " with the same name and version already exist: " + this.streamDefinitionStore.getStreamDefinition(newStreamDefinition.getName(), newStreamDefinition.getVersion(), tenantId));
            }
            newStreamDefinition = existingStreamDefinition;
        } else {
            for (StreamAttributeComposite streamAttributeComposite : streamTypeHolder.getAttributeCompositeMap().values()) {
                this.validateStreamDefinition(newStreamDefinition, streamAttributeComposite.getStreamDefinition());
            }
            this.updateDomainNameStreamTypeHolderCache(newStreamDefinition, tenantId);
            this.streamDefinitionStore.saveStreamDefinition(newStreamDefinition, tenantId);
        }
        for (AgentCallback agentCallback : this.subscribers) {
            agentCallback.definedStream(newStreamDefinition, tenantId);
        }
        for (RawDataAgentCallback rawDataAgentCallback : this.rawDataSubscribers) {
            rawDataAgentCallback.definedStream(newStreamDefinition, tenantId);
        }
        return newStreamDefinition.getStreamId();
    }

    public synchronized String defineStream(String streamDefinition, AgentSession agentSession, String indexDefinition) throws MalformedStreamDefinitionException, DifferentStreamDefinitionAlreadyDefinedException, StreamDefinitionStoreException {
        int tenantId = agentSession.getCredentials().getTenantId();
        StreamDefinition newStreamDefinition = EventDefinitionConverterUtils.convertFromJson((String)streamDefinition);
        StreamTypeHolder streamTypeHolder = this.getStreamDefinitionHolder(tenantId);
        StreamAttributeComposite attributeComposite = streamTypeHolder.getAttributeComposite(newStreamDefinition.getStreamId());
        if (attributeComposite != null) {
            StreamDefinition existingStreamDefinition = attributeComposite.getStreamDefinition();
            if (!existingStreamDefinition.equals((Object)newStreamDefinition)) {
                throw new DifferentStreamDefinitionAlreadyDefinedException("Similar event stream for " + newStreamDefinition + " with the same name and version already exist: " + this.streamDefinitionStore.getStreamDefinition(newStreamDefinition.getName(), newStreamDefinition.getVersion(), tenantId));
            }
            newStreamDefinition = existingStreamDefinition;
        } else {
            for (StreamAttributeComposite streamAttributeComposite : streamTypeHolder.getAttributeCompositeMap().values()) {
                this.validateStreamDefinition(newStreamDefinition, streamAttributeComposite.getStreamDefinition());
            }
            this.updateDomainNameStreamTypeHolderCache(newStreamDefinition, tenantId);
            this.streamDefinitionStore.saveStreamDefinition(newStreamDefinition, tenantId);
        }
        newStreamDefinition.createIndexDefinition(indexDefinition);
        for (AgentCallback agentCallback : this.subscribers) {
            agentCallback.definedStream(newStreamDefinition, tenantId);
        }
        for (RawDataAgentCallback rawDataAgentCallback : this.rawDataSubscribers) {
            rawDataAgentCallback.definedStream(newStreamDefinition, tenantId);
        }
        return newStreamDefinition.getStreamId();
    }

    private void validateStreamDefinition(StreamDefinition newStreamDefinition, StreamDefinition existingStreamDefinition) throws DifferentStreamDefinitionAlreadyDefinedException {
        if (newStreamDefinition.getName().equals(existingStreamDefinition.getName())) {
            this.validateAttributes(newStreamDefinition.getMetaData(), existingStreamDefinition.getMetaData(), "meta", newStreamDefinition, existingStreamDefinition);
            this.validateAttributes(newStreamDefinition.getCorrelationData(), existingStreamDefinition.getCorrelationData(), "correlation", newStreamDefinition, existingStreamDefinition);
            this.validateAttributes(newStreamDefinition.getPayloadData(), existingStreamDefinition.getPayloadData(), "payload", newStreamDefinition, existingStreamDefinition);
        }
    }

    private void validateAttributes(List<Attribute> newAttributes, List<Attribute> existingAttributes, String type, StreamDefinition newStreamDefinition, StreamDefinition existingStreamDefinition) throws DifferentStreamDefinitionAlreadyDefinedException {
        if (newAttributes != null && existingAttributes != null) {
            for (Attribute attribute : newAttributes) {
                for (Attribute existingAttribute : existingAttributes) {
                    if (!attribute.getName().equals(existingAttribute.getName()) || attribute.getType() == existingAttribute.getType()) continue;
                    throw new DifferentStreamDefinitionAlreadyDefinedException("Attribute type mismatch " + type + " " + attribute.getName() + " type:" + attribute.getType() + " was already defined with type:" + existingAttribute.getType() + " in " + existingStreamDefinition + ", hence " + newStreamDefinition + " cannot be defined");
                }
            }
        }
    }

    public void publish(Object eventBundle, AgentSession agentSession, EventConverter eventConverter) {
        this.eventQueue.publish(new EventComposite(eventBundle, this.getStreamDefinitionHolder(agentSession.getCredentials().getTenantId()), agentSession, eventConverter));
    }

    private StreamTypeHolder getStreamDefinitionHolder(int tenantId) {
        StreamTypeHolder streamTypeHolder = this.domainNameStreamTypeHolderCache.get(tenantId);
        if (streamTypeHolder != null) {
            if (log.isDebugEnabled()) {
                String logMsg = "Event stream holder for tenant : " + tenantId + " : \n ";
                logMsg = logMsg + "Meta, Correlation & Payload Data Type Map : ";
                for (Map.Entry<String, StreamAttributeComposite> entry : streamTypeHolder.getAttributeCompositeMap().entrySet()) {
                    logMsg = logMsg + "StreamID=" + entry.getKey() + " :  ";
                    logMsg = logMsg + "Meta= " + Arrays.deepToString(entry.getValue().getAttributeTypes()[0]) + " :  ";
                    logMsg = logMsg + "Correlation= " + Arrays.deepToString(entry.getValue().getAttributeTypes()[1]) + " :  ";
                    logMsg = logMsg + "Payload= " + Arrays.deepToString(entry.getValue().getAttributeTypes()[2]) + "\n";
                }
                log.debug((Object)logMsg);
            }
            return streamTypeHolder;
        }
        return this.initDomainNameStreamTypeHolderCache(tenantId);
    }

    public synchronized void updateStreamDefinitionHolder(AgentSession agentSession) {
        int tenantId = agentSession.getCredentials().getTenantId();
        StreamTypeHolder streamTypeHolder = this.domainNameStreamTypeHolderCache.get(tenantId);
        if (streamTypeHolder != null) {
            if (log.isDebugEnabled()) {
                String logMsg = "Event stream holder for tenant : " + tenantId + " : \n ";
                logMsg = logMsg + "Meta, Correlation & Payload Data Type Map : ";
                for (Map.Entry<String, StreamAttributeComposite> entry : streamTypeHolder.getAttributeCompositeMap().entrySet()) {
                    logMsg = logMsg + "StreamID=" + entry.getKey() + " :  ";
                    logMsg = logMsg + "Meta= " + Arrays.deepToString(entry.getValue().getAttributeTypes()[0]) + " :  ";
                    logMsg = logMsg + "Correlation= " + Arrays.deepToString(entry.getValue().getAttributeTypes()[1]) + " :  ";
                    logMsg = logMsg + "Payload= " + Arrays.deepToString(entry.getValue().getAttributeTypes()[2]) + "\n";
                }
                log.debug((Object)logMsg);
            }
            this.updateDomainNameStreamTypeHolderCache(tenantId);
        }
    }

    private synchronized void updateDomainNameStreamTypeHolderCache(StreamDefinition streamDefinition, int tenantId) {
        StreamTypeHolder streamTypeHolder = this.getStreamDefinitionHolder(tenantId);
        streamTypeHolder.putStreamDefinition(streamDefinition);
    }

    public synchronized void reloadDomainNameStreamTypeHolderCache(int tenantId) {
        StreamTypeHolder streamTypeHolder = this.getStreamDefinitionHolder(tenantId);
        Collection<StreamDefinition> allStreamDefinitions = this.streamDefinitionStore.getAllStreamDefinitions(tenantId);
        for (StreamDefinition streamDefinition : allStreamDefinitions) {
            if (streamTypeHolder.getAttributeCompositeMap().containsKey(streamDefinition.getStreamId())) continue;
            streamTypeHolder.putStreamDefinition(streamDefinition);
            for (AgentCallback agentCallback : this.subscribers) {
                agentCallback.definedStream(streamDefinition, tenantId);
            }
            for (RawDataAgentCallback rawDataAgentCallback : this.rawDataSubscribers) {
                rawDataAgentCallback.definedStream(streamDefinition, tenantId);
            }
        }
    }

    private synchronized StreamTypeHolder initDomainNameStreamTypeHolderCache(int tenantId) {
        StreamTypeHolder streamTypeHolder = this.domainNameStreamTypeHolderCache.get(tenantId);
        if (null == streamTypeHolder) {
            streamTypeHolder = new StreamTypeHolder(tenantId);
            streamTypeHolder.setEventDispatcherCallback(this);
            Collection<StreamDefinition> allStreamDefinitions = this.streamDefinitionStore.getAllStreamDefinitions(tenantId);
            if (null != allStreamDefinitions) {
                for (StreamDefinition aStreamDefinition : allStreamDefinitions) {
                    streamTypeHolder.putStreamDefinition(aStreamDefinition);
                    for (AgentCallback agentCallback : this.subscribers) {
                        agentCallback.definedStream(aStreamDefinition, tenantId);
                    }
                    for (RawDataAgentCallback rawDataAgentCallback : this.rawDataSubscribers) {
                        rawDataAgentCallback.definedStream(aStreamDefinition, tenantId);
                    }
                }
            }
            this.domainNameStreamTypeHolderCache.put(tenantId, streamTypeHolder);
        }
        return streamTypeHolder;
    }

    private synchronized StreamTypeHolder updateDomainNameStreamTypeHolderCache(int tenantId) {
        StreamTypeHolder streamTypeHolder = this.domainNameStreamTypeHolderCache.get(tenantId);
        if (null != streamTypeHolder) {
            Collection<StreamDefinition> allStreamDefinitions = this.streamDefinitionStore.getAllStreamDefinitions(tenantId);
            if (null != allStreamDefinitions) {
                for (StreamDefinition streamDefinition : allStreamDefinitions) {
                    if (streamTypeHolder.getAttributeComposite(streamDefinition.getStreamId()) != null) continue;
                    streamTypeHolder.putStreamDefinition(streamDefinition);
                    for (AgentCallback agentCallback : this.subscribers) {
                        agentCallback.definedStream(streamDefinition, tenantId);
                    }
                    for (RawDataAgentCallback rawDataAgentCallback : this.rawDataSubscribers) {
                        rawDataAgentCallback.definedStream(streamDefinition, tenantId);
                    }
                }
                ArrayList<String> streamIdList = new ArrayList<String>();
                for (StreamDefinition streamDefinition : allStreamDefinitions) {
                    streamIdList.add(streamDefinition.getStreamId());
                }
                Iterator<String> iterator = streamTypeHolder.getAttributeCompositeMap().keySet().iterator();
                while (iterator.hasNext()) {
                    if (streamIdList.contains(iterator.next())) continue;
                    iterator.remove();
                }
            }
            this.domainNameStreamTypeHolderCache.put(tenantId, streamTypeHolder);
        }
        return streamTypeHolder;
    }

    public List<AgentCallback> getSubscribers() {
        return this.subscribers;
    }

    public List<RawDataAgentCallback> getRawDataSubscribers() {
        return this.rawDataSubscribers;
    }

    public String findStreamId(String streamName, String streamVersion, AgentSession agentSession) throws StreamDefinitionStoreException {
        int tenantId = agentSession.getCredentials().getTenantId();
        this.updateDomainNameStreamTypeHolderCache(tenantId);
        StreamTypeHolder streamTypeHolder = this.getStreamDefinitionHolder(tenantId);
        StreamAttributeComposite attributeComposite = streamTypeHolder.getAttributeComposite(DataBridgeCommonsUtils.generateStreamId((String)streamName, (String)streamVersion));
        if (attributeComposite != null) {
            return attributeComposite.getStreamDefinition().getStreamId();
        }
        return null;
    }

    public boolean deleteStream(String streamName, String streamVersion, AgentSession agentSession) {
        String streamId;
        int tenantId = agentSession.getCredentials().getTenantId();
        StreamDefinition streamDefinition = this.removeStreamDefinitionFromStreamTypeHolder(tenantId, streamId = DataBridgeCommonsUtils.generateStreamId((String)streamName, (String)streamVersion));
        if (streamDefinition != null) {
            for (AgentCallback agentCallback : this.subscribers) {
                agentCallback.removeStream(streamDefinition, tenantId);
            }
            for (RawDataAgentCallback rawDataAgentCallback : this.rawDataSubscribers) {
                rawDataAgentCallback.removeStream(streamDefinition, tenantId);
            }
        }
        return this.streamDefinitionStore.deleteStreamDefinition(streamName, streamVersion, tenantId);
    }

    private synchronized StreamDefinition removeStreamDefinitionFromStreamTypeHolder(int tenantId, String streamId) {
        StreamAttributeComposite attributeComposite;
        StreamTypeHolder streamTypeHolder = this.domainNameStreamTypeHolderCache.get(tenantId);
        if (streamTypeHolder != null && (attributeComposite = streamTypeHolder.getAttributeCompositeMap().remove(streamId)) != null) {
            return attributeComposite.getStreamDefinition();
        }
        return null;
    }
}

