/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.internal;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;
import org.wso2.carbon.databridge.core.DataBridge;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.DataBridgeServiceValueHolder;
import org.wso2.carbon.databridge.core.DataBridgeSubscriberService;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.databridge.core.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.databridge.core.internal.authentication.CarbonAuthenticationHandler;
import org.wso2.carbon.databridge.core.internal.utils.DataBridgeCoreBuilder;
import org.wso2.carbon.identity.authentication.AuthenticationService;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="databridge.component", immediate=true)
public class DataBridgeDS {
    private static final Log log = LogFactory.getLog(DataBridgeDS.class);
    private AuthenticationService authenticationService;
    private ServiceRegistration receiverServiceRegistration;
    private ServiceRegistration subscriberServiceRegistration;
    private DataBridge databridge;
    private ServiceRegistration databridgeRegistration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext context) {
        block18: {
            try {
                if (this.databridge != null) break block18;
                AbstractStreamDefinitionStore streamDefinitionStore = DataBridgeServiceValueHolder.getStreamDefinitionStore();
                this.databridge = new DataBridge((AuthenticationHandler)new CarbonAuthenticationHandler(this.authenticationService), streamDefinitionStore, DataBridgeCoreBuilder.getDatabridgeConfigPath());
                try {
                    List<String[]> streamDefinitionStrings = DataBridgeCoreBuilder.loadStreamDefinitionXML();
                    for (String[] streamDefinitionString : streamDefinitionStrings) {
                        try {
                            StreamDefinition streamDefinition = EventDefinitionConverterUtils.convertFromJson((String)streamDefinitionString[1]);
                            int tenantId = DataBridgeServiceValueHolder.getRealmService().getTenantManager().getTenantId(streamDefinitionString[0]);
                            if (tenantId == -1) {
                                log.warn((Object)("Tenant " + streamDefinitionString[0] + " does not exist, Error in defining event stream " + streamDefinitionString[1]));
                                continue;
                            }
                            try {
                                PrivilegedCarbonContext.startTenantFlow();
                                PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                                privilegedCarbonContext.setTenantId(tenantId);
                                privilegedCarbonContext.setTenantDomain(streamDefinitionString[0]);
                                streamDefinitionStore.saveStreamDefinition(streamDefinition, tenantId);
                            }
                            catch (DifferentStreamDefinitionAlreadyDefinedException e) {
                                log.warn((Object)("Error redefining event stream of " + streamDefinitionString[0] + ": " + streamDefinitionString[1]), (Throwable)e);
                            }
                            catch (RuntimeException e) {
                                log.error((Object)("Error in defining event stream " + streamDefinitionString[0] + ": " + streamDefinitionString[1]), (Throwable)e);
                            }
                            catch (StreamDefinitionStoreException e) {
                                log.error((Object)("Error in defining event stream in store " + streamDefinitionString[0] + ": " + streamDefinitionString[1]), (Throwable)e);
                            }
                            finally {
                                PrivilegedCarbonContext.endTenantFlow();
                            }
                        }
                        catch (MalformedStreamDefinitionException e) {
                            log.error((Object)("Malformed Stream Definition for " + streamDefinitionString[0] + ": " + streamDefinitionString[1]), (Throwable)e);
                        }
                        catch (UserStoreException e) {
                            log.error((Object)("Error in identifying tenant event stream " + streamDefinitionString[0] + ": " + streamDefinitionString[1]), (Throwable)e);
                        }
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"Cannot load stream definitions ", t);
                }
                this.receiverServiceRegistration = context.getBundleContext().registerService(DataBridgeReceiverService.class.getName(), (Object)this.databridge, null);
                this.subscriberServiceRegistration = context.getBundleContext().registerService(DataBridgeSubscriberService.class.getName(), (Object)this.databridge, null);
                log.info((Object)"Successfully deployed Agent Server ");
            }
            catch (RuntimeException e) {
                log.error((Object)"Error in starting Agent Server ", (Throwable)e);
            }
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        context.getBundleContext().ungetService(this.receiverServiceRegistration.getReference());
        context.getBundleContext().ungetService(this.subscriberServiceRegistration.getReference());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully stopped agent server");
        }
    }

    @Reference(name="org.wso2.carbon.identity.authentication.internal.AuthenticationServiceComponent", service=AuthenticationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAuthenticationService")
    protected void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    protected void unsetAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = null;
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        DataBridgeServiceValueHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        DataBridgeServiceValueHolder.setRealmService(null);
    }

    @Reference(name="stream.definitionStore.service", service=AbstractStreamDefinitionStore.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventStreamStoreService")
    protected void setEventStreamStoreService(AbstractStreamDefinitionStore abstractStreamDefinitionStore) {
        DataBridgeServiceValueHolder.setStreamDefinitionStore(abstractStreamDefinitionStore);
    }

    protected void unsetEventStreamStoreService(AbstractStreamDefinitionStore abstractStreamDefinitionStore) {
        DataBridgeServiceValueHolder.setStreamDefinitionStore(null);
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        DataBridgeServiceValueHolder.setConfigurationContextService(contextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        DataBridgeServiceValueHolder.setConfigurationContextService(null);
    }
}

