/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.definitionstore;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;

public class InMemoryStreamDefinitionStore
extends AbstractStreamDefinitionStore {
    private ConcurrentHashMap<String, StreamDefinition> streamDefinitionStore = new ConcurrentHashMap();

    @Override
    public boolean removeStreamDefinition(String name, String version, int tenantId) {
        return null != this.streamDefinitionStore.remove(DataBridgeCommonsUtils.generateStreamId((String)name, (String)version));
    }

    @Override
    public void saveStreamDefinitionToStore(StreamDefinition streamDefinition, int tenantId) throws StreamDefinitionStoreException {
        this.streamDefinitionStore.put(streamDefinition.getStreamId(), streamDefinition);
    }

    @Override
    public StreamDefinition getStreamDefinitionFromStore(String name, String version, int tenantId) throws StreamDefinitionStoreException {
        return this.getStreamDefinition(DataBridgeCommonsUtils.generateStreamId((String)name, (String)version), tenantId);
    }

    @Override
    public StreamDefinition getStreamDefinitionFromStore(String streamId, int tenantId) throws StreamDefinitionStoreException {
        return this.streamDefinitionStore.get(streamId);
    }

    @Override
    public Collection<StreamDefinition> getAllStreamDefinitionsFromStore(int tenantId) {
        if (this.streamDefinitionStore != null) {
            return this.streamDefinitionStore.values();
        }
        return null;
    }
}

