/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.definitionstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;
import org.wso2.carbon.databridge.core.definitionstore.StreamAddRemoveListener;
import org.wso2.carbon.databridge.core.definitionstore.StreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;

public abstract class AbstractStreamDefinitionStore
implements StreamDefinitionStore {
    private Log log = LogFactory.getLog(AbstractStreamDefinitionStore.class);
    private List<StreamAddRemoveListener> streamAddRemoveListenerList = new ArrayList<StreamAddRemoveListener>();

    @Override
    public StreamDefinition getStreamDefinition(String name, String version, int tenantId) throws StreamDefinitionStoreException {
        return this.getStreamDefinitionFromStore(name, version, tenantId);
    }

    @Override
    public StreamDefinition getStreamDefinition(String streamId, int tenantId) throws StreamDefinitionStoreException {
        return this.getStreamDefinitionFromStore(streamId, tenantId);
    }

    @Override
    public Collection<StreamDefinition> getAllStreamDefinitions(int tenantId) {
        try {
            return this.getAllStreamDefinitionsFromStore(tenantId);
        }
        catch (StreamDefinitionStoreException e) {
            this.log.error((Object)"Error occured when trying to retrieve definitions. Returning empty list.");
            return new ArrayList<StreamDefinition>();
        }
    }

    @Override
    public void saveStreamDefinition(StreamDefinition streamDefinition, int tenantId) throws DifferentStreamDefinitionAlreadyDefinedException, StreamDefinitionStoreException {
        StreamDefinition existingDefinition = this.getStreamDefinition(streamDefinition.getName(), streamDefinition.getVersion(), tenantId);
        if (existingDefinition == null) {
            this.saveStreamDefinitionToStore(streamDefinition, tenantId);
            for (StreamAddRemoveListener streamAddRemoveListener : this.streamAddRemoveListenerList) {
                streamAddRemoveListener.streamAdded(tenantId, streamDefinition.getStreamId());
            }
            return;
        }
        if (!existingDefinition.equals((Object)streamDefinition)) {
            throw new DifferentStreamDefinitionAlreadyDefinedException("Cannot define Stream definition:" + EventDefinitionConverterUtils.convertToJson((StreamDefinition)existingDefinition) + ", Another Stream with same name and version exist :" + EventDefinitionConverterUtils.convertToJson((StreamDefinition)existingDefinition));
        }
    }

    @Override
    public boolean deleteStreamDefinition(String streamName, String streamVersion, int tenantId) {
        if (this.removeStreamDefinition(streamName, streamVersion, tenantId)) {
            for (StreamAddRemoveListener streamAddRemoveListener : this.streamAddRemoveListenerList) {
                streamAddRemoveListener.streamRemoved(tenantId, streamName + ":" + streamVersion);
            }
            return true;
        }
        return false;
    }

    @Override
    public void subscribe(StreamAddRemoveListener streamAddRemoveListener) {
        if (streamAddRemoveListener != null) {
            this.streamAddRemoveListenerList.add(streamAddRemoveListener);
        }
    }

    @Override
    public void unsubscribe(StreamAddRemoveListener streamAddRemoveListener) {
        if (streamAddRemoveListener != null) {
            this.streamAddRemoveListenerList.remove(streamAddRemoveListener);
        }
    }

    public void invalidateStreamDefinition(String streamName, String streamVersion, int tenantId) {
        for (StreamAddRemoveListener streamAddRemoveListener : this.streamAddRemoveListenerList) {
            streamAddRemoveListener.streamRemoved(tenantId, streamName + ":" + streamVersion);
        }
    }

    public abstract StreamDefinition getStreamDefinitionFromStore(String var1, String var2, int var3) throws StreamDefinitionStoreException;

    public abstract StreamDefinition getStreamDefinitionFromStore(String var1, int var2) throws StreamDefinitionStoreException;

    public abstract Collection<StreamDefinition> getAllStreamDefinitionsFromStore(int var1) throws StreamDefinitionStoreException;

    public abstract void saveStreamDefinitionToStore(StreamDefinition var1, int var2) throws StreamDefinitionStoreException;

    public abstract boolean removeStreamDefinition(String var1, String var2, int var3);
}

