/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core.conf;

import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;
import org.wso2.carbon.databridge.core.conf.DataReceiver;

@XmlRootElement(name="dataBridgeConfiguration")
public class DataBridgeConfiguration {
    private List<DataReceiver> dataReceivers;
    private int workerThreads = 10;
    private int maxEventBufferCapacity = 50000000;
    private int eventBufferSize = 2000;
    private int clientTimeoutMin = 30;
    private String keyStoreLocation = null;
    private String keyStorePassword = null;
    private String keyStoreType;
    private String keyManagerType;
    private String trustManagerType;

    @XmlElement(name="dataReceiver")
    public List<DataReceiver> getDataReceivers() {
        return this.dataReceivers;
    }

    public void setDataReceivers(List<DataReceiver> dataReceivers) {
        this.dataReceivers = dataReceivers;
    }

    @XmlElement(name="workerThreads")
    public int getWorkerThreads() {
        return this.workerThreads;
    }

    @XmlElement(name="keyStoreLocation")
    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = DataBridgeCommonsUtils.replaceSystemProperty((String)keyStoreLocation);
    }

    @XmlElement(name="keyStoreType")
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @XmlElement(name="keyManagerType")
    public String getKeyManagerType() {
        return this.keyManagerType;
    }

    public void setKeyManagerType(String keyManagerType) {
        this.keyManagerType = keyManagerType;
    }

    @XmlElement(name="trustManagerType")
    public String getTrustManagerType() {
        return this.trustManagerType;
    }

    public void setTrustManagerType(String trustManagerType) {
        this.trustManagerType = trustManagerType;
    }

    @XmlElement(name="keyStorePassword")
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    @XmlElement(name="maxEventBufferCapacity")
    public int getMaxEventBufferCapacity() {
        return this.maxEventBufferCapacity;
    }

    public void setMaxEventBufferCapacity(int maxEventBufferCapacity) {
        this.maxEventBufferCapacity = maxEventBufferCapacity * 1000000;
    }

    @XmlElement(name="clientTimeoutMin")
    public int getClientTimeoutMin() {
        return this.clientTimeoutMin;
    }

    public void setClientTimeoutMin(int clientTimeoutMin) {
        this.clientTimeoutMin = clientTimeoutMin;
    }

    public DataReceiver getDataReceiver(String name) {
        for (DataReceiver dataReceiver : this.dataReceivers) {
            if (!dataReceiver.getName().equalsIgnoreCase(name)) continue;
            return dataReceiver;
        }
        return null;
    }

    public int getEventBufferSize() {
        return this.eventBufferSize;
    }

    @XmlElement(name="eventBufferSize")
    public void setEventBufferSize(int eventBufferSize) {
        this.eventBufferSize = eventBufferSize;
    }
}

