/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.core.StreamAttributeComposite;
import org.wso2.carbon.databridge.core.internal.EventDispatcher;

public class StreamTypeHolder {
    private int tenantId;
    private Map<String, StreamAttributeComposite> attributeCompositeMap = new ConcurrentHashMap<String, StreamAttributeComposite>();
    private EventDispatcher eventDispatcherCallback;

    public StreamTypeHolder(int tenantId) {
        this.tenantId = tenantId;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public Map<String, StreamAttributeComposite> getAttributeCompositeMap() {
        return this.attributeCompositeMap;
    }

    public AttributeType[][] getDataType(String streamId) {
        StreamAttributeComposite type = this.attributeCompositeMap.get(streamId);
        if (null != type) {
            return type.getAttributeTypes();
        }
        return null;
    }

    public void reloadStreamTypeHolder() {
        this.eventDispatcherCallback.reloadDomainNameStreamTypeHolderCache(this.tenantId);
    }

    public StreamAttributeComposite getAttributeComposite(String streamId) {
        return this.attributeCompositeMap.get(streamId);
    }

    public void putStreamDefinition(StreamDefinition streamDefinition) {
        this.attributeCompositeMap.put(streamDefinition.getStreamId(), new StreamAttributeComposite(streamDefinition));
    }

    public void setEventDispatcherCallback(EventDispatcher eventDispatcherCallback) {
        this.eventDispatcherCallback = eventDispatcherCallback;
    }
}

