/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core;

import java.util.List;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;

public class StreamAttributeComposite {
    private AttributeType[][] attributeTypes;
    private StreamDefinition streamDefinition;
    private int attributeSize;

    public StreamAttributeComposite(StreamDefinition streamDefinition) {
        this.streamDefinition = streamDefinition;
        this.attributeTypes = new AttributeType[][]{EventDefinitionConverterUtils.generateAttributeTypeArray((List)streamDefinition.getMetaData()), EventDefinitionConverterUtils.generateAttributeTypeArray((List)streamDefinition.getCorrelationData()), EventDefinitionConverterUtils.generateAttributeTypeArray((List)streamDefinition.getPayloadData())};
        this.attributeSize = this.getSize(this.attributeTypes);
    }

    private int getSize(AttributeType[][] attributeTypes) {
        int size = 0;
        if (attributeTypes[0] != null) {
            size += attributeTypes[0].length;
        }
        if (attributeTypes[1] != null) {
            size += attributeTypes[1].length;
        }
        if (attributeTypes[2] != null) {
            size += attributeTypes[2].length;
        }
        return size;
    }

    public int getAttributeSize() {
        return this.attributeSize;
    }

    public void setAttributeSize(int attributeSize) {
        this.attributeSize = attributeSize;
    }

    public AttributeType[][] getAttributeTypes() {
        return this.attributeTypes;
    }

    public void setAttributeTypes(AttributeType[][] attributeTypes) {
        this.attributeTypes = attributeTypes;
    }

    public StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }
}

