/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.databridge.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;
import org.wso2.carbon.databridge.core.AgentCallback;
import org.wso2.carbon.databridge.core.DataBridgeReceiverService;
import org.wso2.carbon.databridge.core.DataBridgeSubscriberService;
import org.wso2.carbon.databridge.core.EventConverter;
import org.wso2.carbon.databridge.core.RawDataAgentCallback;
import org.wso2.carbon.databridge.core.Utils.AgentSession;
import org.wso2.carbon.databridge.core.conf.DataBridgeConfiguration;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.definitionstore.StreamAddRemoveListener;
import org.wso2.carbon.databridge.core.definitionstore.StreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionNotFoundException;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.databridge.core.internal.EventDispatcher;
import org.wso2.carbon.databridge.core.internal.authentication.AuthenticationHandler;
import org.wso2.carbon.databridge.core.internal.authentication.Authenticator;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class DataBridge
implements DataBridgeSubscriberService,
DataBridgeReceiverService {
    private static final Log log = LogFactory.getLog(DataBridge.class);
    private StreamDefinitionStore streamDefinitionStore;
    private EventDispatcher eventDispatcher;
    private Authenticator authenticator;
    private AuthenticationHandler authenticatorHandler;
    private List<StreamAddRemoveListener> streamAddRemoveListenerList = new ArrayList<StreamAddRemoveListener>();
    private DataBridgeConfiguration dataBridgeConfiguration;
    private AtomicInteger eventsReceived;
    private AtomicInteger totalEventCounter;
    private long startTime;
    private boolean isProfileReceiver;
    private int cutoff = 100000;

    public DataBridge(AuthenticationHandler authenticationHandler, AbstractStreamDefinitionStore streamDefinitionStore, DataBridgeConfiguration dataBridgeConfiguration) {
        this.eventDispatcher = new EventDispatcher(streamDefinitionStore, dataBridgeConfiguration, authenticationHandler);
        this.streamDefinitionStore = streamDefinitionStore;
        this.authenticatorHandler = authenticationHandler;
        this.authenticator = new Authenticator(authenticationHandler, dataBridgeConfiguration);
        String profileReceiver = System.getProperty("profileReceiver");
        String receiverStatsCutoff = System.getProperty("receiverStatsCutoff");
        if (profileReceiver != null && profileReceiver.equalsIgnoreCase("true")) {
            this.isProfileReceiver = true;
            this.eventsReceived = new AtomicInteger();
            this.totalEventCounter = new AtomicInteger();
            this.startTime = 0L;
            if (receiverStatsCutoff != null && StringUtils.isNumeric((String)receiverStatsCutoff)) {
                this.cutoff = Integer.parseInt(receiverStatsCutoff);
            }
        }
    }

    public DataBridge(AuthenticationHandler authenticationHandler, AbstractStreamDefinitionStore streamDefinitionStore, String dataBridgeConfigPath) {
        DataBridgeConfiguration dataBridgeConfiguration = null;
        try {
            dataBridgeConfiguration = this.createDataBridgeConfiguration(dataBridgeConfigPath);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error while loading the data bridge configuration file : " + dataBridgeConfigPath), (Throwable)e);
        }
        catch (IOException | JAXBException | XMLStreamException e) {
            log.error((Object)"Error while reading the data bridge configuration file", e);
        }
        this.setInitialConfig(dataBridgeConfiguration);
        this.eventDispatcher = new EventDispatcher(streamDefinitionStore, dataBridgeConfiguration, authenticationHandler);
        this.streamDefinitionStore = streamDefinitionStore;
        this.authenticatorHandler = authenticationHandler;
        this.authenticator = new Authenticator(authenticationHandler, dataBridgeConfiguration);
        String profileReceiver = System.getProperty("profileReceiver");
        String receiverStatsCutoff = System.getProperty("receiverStatsCutoff");
        if (profileReceiver != null && profileReceiver.equalsIgnoreCase("true")) {
            this.isProfileReceiver = true;
            this.eventsReceived = new AtomicInteger();
            this.totalEventCounter = new AtomicInteger();
            this.startTime = 0L;
            if (receiverStatsCutoff != null && StringUtils.isNumeric((String)receiverStatsCutoff)) {
                this.cutoff = Integer.parseInt(receiverStatsCutoff);
            }
        }
    }

    @Override
    public String defineStream(String sessionId, String streamDefinition) throws DifferentStreamDefinitionAlreadyDefinedException, MalformedStreamDefinitionException, SessionTimeoutException {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getCredentials() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        try {
            this.authenticatorHandler.initContext(agentSession);
            String streamId = this.eventDispatcher.defineStream(streamDefinition, agentSession);
            if (streamId != null) {
                int tenantId = agentSession.getCredentials().getTenantId();
                for (StreamAddRemoveListener streamAddRemoveListener : this.streamAddRemoveListenerList) {
                    streamAddRemoveListener.streamAdded(tenantId, streamId);
                }
            }
            String string = streamId;
            return string;
        }
        catch (MalformedStreamDefinitionException e) {
            throw new MalformedStreamDefinitionException(e.getErrorMessage(), (Throwable)e);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            throw new DifferentStreamDefinitionAlreadyDefinedException(e.getErrorMessage(), (Throwable)e);
        }
        catch (StreamDefinitionStoreException e) {
            throw new MalformedStreamDefinitionException(e.getErrorMessage(), (Throwable)e);
        }
        finally {
            this.authenticatorHandler.destroyContext(agentSession);
        }
    }

    @Override
    public String defineStream(String sessionId, String streamDefinition, String indexDefinition) throws DifferentStreamDefinitionAlreadyDefinedException, MalformedStreamDefinitionException, SessionTimeoutException {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getCredentials() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        try {
            this.authenticatorHandler.initContext(agentSession);
            String streamId = this.eventDispatcher.defineStream(streamDefinition, agentSession, indexDefinition);
            if (streamId != null) {
                int tenantId = agentSession.getCredentials().getTenantId();
                for (StreamAddRemoveListener streamAddRemoveListener : this.streamAddRemoveListenerList) {
                    streamAddRemoveListener.streamAdded(tenantId, streamId);
                }
            }
            String string = streamId;
            return string;
        }
        catch (MalformedStreamDefinitionException e) {
            throw new MalformedStreamDefinitionException(e.getErrorMessage(), (Throwable)e);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            throw new DifferentStreamDefinitionAlreadyDefinedException(e.getErrorMessage(), (Throwable)e);
        }
        catch (StreamDefinitionStoreException e) {
            throw new MalformedStreamDefinitionException(e.getErrorMessage(), (Throwable)e);
        }
        finally {
            this.authenticatorHandler.destroyContext(agentSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findStreamId(String sessionId, String streamName, String streamVersion) throws SessionTimeoutException {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getCredentials() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        try {
            this.authenticatorHandler.initContext(agentSession);
            String string = this.eventDispatcher.findStreamId(streamName, streamVersion, agentSession);
            return string;
        }
        catch (StreamDefinitionStoreException e) {
            log.warn((Object)("Cannot find streamId for " + streamName + " " + streamVersion), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            this.authenticatorHandler.destroyContext(agentSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteStream(String sessionId, String streamId) throws SessionTimeoutException {
        boolean status;
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getCredentials() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        try {
            this.authenticatorHandler.initContext(agentSession);
            status = this.eventDispatcher.deleteStream(DataBridgeCommonsUtils.getStreamNameFromStreamId((String)streamId), DataBridgeCommonsUtils.getStreamVersionFromStreamId((String)streamId), agentSession);
            if (status) {
                for (StreamAddRemoveListener streamAddRemoveListener : this.streamAddRemoveListenerList) {
                    streamAddRemoveListener.streamRemoved(agentSession.getCredentials().getTenantId(), streamId);
                }
            }
        }
        finally {
            this.authenticatorHandler.destroyContext(agentSession);
        }
        return status;
    }

    @Override
    public boolean deleteStream(String sessionId, String streamName, String streamVersion) throws SessionTimeoutException {
        return this.deleteStream(sessionId, DataBridgeCommonsUtils.generateStreamId((String)streamName, (String)streamVersion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(Object eventBundle, String sessionId, EventConverter eventConverter) throws UndefinedEventTypeException, SessionTimeoutException {
        this.startTimeMeasurement();
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getCredentials() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        try {
            this.authenticatorHandler.initContext(agentSession);
            this.eventDispatcher.publish(eventBundle, agentSession, eventConverter);
            this.endTimeMeasurement(eventConverter.getNumberOfEvents(eventBundle));
        }
        finally {
            this.authenticatorHandler.destroyContext(agentSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTimeMeasurement(int eventsNum) {
        if (this.isProfileReceiver) {
            this.eventsReceived.addAndGet(eventsNum);
            if (this.eventsReceived.get() > this.cutoff) {
                DataBridge dataBridge = this;
                synchronized (dataBridge) {
                    if (this.eventsReceived.get() > this.cutoff) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                        Date date = new Date();
                        long endTime = System.currentTimeMillis();
                        int currentBatchSize = this.eventsReceived.getAndSet(0);
                        this.totalEventCounter.addAndGet(currentBatchSize);
                        String line = "[" + dateFormat.format(date) + "] # of events : " + currentBatchSize + " start timestamp : " + this.startTime + " end time stamp : " + endTime + " Throughput is (events / sec) : " + (long)(currentBatchSize * 1000) / (endTime - this.startTime) + " Total Event Count : " + this.totalEventCounter + " \n";
                        File file = new File(CarbonUtils.getCarbonHome() + File.separator + "receiver-perf.txt");
                        if (!file.exists()) {
                            log.info((Object)("Creating the performance measurement file at : " + file.getAbsolutePath()));
                        }
                        try {
                            this.appendToFile(IOUtils.toInputStream((String)line), file);
                        }
                        catch (IOException e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                        this.startTime = 0L;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToFile(InputStream in, File f) throws IOException {
        BufferedOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(f, true));
            IOUtils.copy((InputStream)in, (OutputStream)stream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)stream);
    }

    private void startTimeMeasurement() {
        if (this.isProfileReceiver && this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    @Override
    public String login(String username, String password) throws AuthenticationException {
        log.info((Object)("user " + username + " connected"));
        return this.authenticator.authenticate(username, password);
    }

    @Override
    public void logout(String sessionId) throws Exception {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        this.authenticator.logout(sessionId);
        if (agentSession != null && agentSession.getCredentials() != null) {
            log.info((Object)("user " + agentSession.getUsername() + " disconnected"));
        } else {
            log.info((Object)("session " + sessionId + " disconnected"));
        }
    }

    @Override
    public DataBridgeConfiguration getInitialConfig() {
        return this.dataBridgeConfiguration;
    }

    public void setInitialConfig(DataBridgeConfiguration initialConfig) {
        this.dataBridgeConfiguration = initialConfig;
    }

    @Override
    public void subscribe(AgentCallback agentCallback) {
        this.eventDispatcher.addCallback(agentCallback);
    }

    @Override
    public void subscribe(RawDataAgentCallback agentCallback) {
        this.eventDispatcher.addCallback(agentCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamDefinition getStreamDefinition(String sessionId, String streamName, String streamVersion) throws SessionTimeoutException, StreamDefinitionNotFoundException, StreamDefinitionStoreException {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getCredentials() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        try {
            this.authenticatorHandler.initContext(agentSession);
            StreamDefinition streamDefinition = this.getStreamDefinition(streamName, streamVersion, agentSession.getCredentials().getTenantId());
            return streamDefinition;
        }
        finally {
            this.authenticatorHandler.destroyContext(agentSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StreamDefinition> getAllStreamDefinitions(String sessionId) throws SessionTimeoutException {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getCredentials() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        try {
            this.authenticatorHandler.initContext(agentSession);
            Collection collection = this.getAllStreamDefinitions(agentSession.getCredentials().getTenantId());
            return collection;
        }
        finally {
            this.authenticatorHandler.destroyContext(agentSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveStreamDefinition(String sessionId, StreamDefinition streamDefinition) throws SessionTimeoutException, StreamDefinitionStoreException, DifferentStreamDefinitionAlreadyDefinedException {
        AgentSession agentSession = this.authenticator.getSession(sessionId);
        if (agentSession.getCredentials() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("session " + sessionId + " expired "));
            }
            throw new SessionTimeoutException(sessionId + " expired");
        }
        try {
            this.authenticatorHandler.initContext(agentSession);
            this.saveStreamDefinition(streamDefinition, agentSession.getCredentials().getTenantId());
            this.eventDispatcher.updateStreamDefinitionHolder(agentSession);
        }
        finally {
            this.authenticatorHandler.destroyContext(agentSession);
        }
    }

    @Override
    public StreamDefinition getStreamDefinition(String streamName, String streamVersion, int tenantId) throws StreamDefinitionNotFoundException, StreamDefinitionStoreException {
        return this.streamDefinitionStore.getStreamDefinition(streamName, streamVersion, tenantId);
    }

    @Override
    public StreamDefinition getStreamDefinition(String streamId, int tenantId) throws StreamDefinitionNotFoundException, StreamDefinitionStoreException {
        return this.streamDefinitionStore.getStreamDefinition(streamId, tenantId);
    }

    public List<StreamDefinition> getAllStreamDefinitions(int tenantId) {
        return new ArrayList<StreamDefinition>(this.streamDefinitionStore.getAllStreamDefinitions(tenantId));
    }

    @Override
    public void saveStreamDefinition(StreamDefinition streamDefinition, int tenantId) throws DifferentStreamDefinitionAlreadyDefinedException, StreamDefinitionStoreException {
        this.streamDefinitionStore.saveStreamDefinition(streamDefinition, tenantId);
    }

    @Override
    public boolean deleteStreamDefinition(String streamName, String streamVersion, int tenantId) {
        return this.streamDefinitionStore.deleteStreamDefinition(streamName, streamVersion, tenantId);
    }

    @Override
    public List<AgentCallback> getSubscribers() {
        return this.eventDispatcher.getSubscribers();
    }

    @Override
    public List<RawDataAgentCallback> getRawDataSubscribers() {
        return this.eventDispatcher.getRawDataSubscribers();
    }

    @Override
    public void subscribe(StreamAddRemoveListener streamAddRemoveListener) {
        if (streamAddRemoveListener != null) {
            this.streamAddRemoveListenerList.add(streamAddRemoveListener);
        }
    }

    @Override
    public void unsubscribe(StreamAddRemoveListener streamAddRemoveListener) {
        if (streamAddRemoveListener != null) {
            this.streamAddRemoveListenerList.remove(streamAddRemoveListener);
        }
    }

    private DataBridgeConfiguration createDataBridgeConfiguration(String configPath) throws IOException, XMLStreamException, JAXBException {
        File configFile = new File(configPath);
        if (configFile.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(configFile);){
                String resolvedPassword;
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataBridgeConfiguration.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                DataBridgeConfiguration dataBridgeConfiguration = (DataBridgeConfiguration)jaxbUnmarshaller.unmarshal(configFile);
                StAXOMBuilder builder = new StAXOMBuilder((InputStream)fileInputStream);
                OMElement configElement = builder.getDocumentElement();
                SecretResolver secretResolver = SecretResolverFactory.create((OMElement)configElement, (boolean)true);
                OMElement keyStorePasswordElement = configElement.getFirstChildWithName(new QName("keyStorePassword"));
                if (keyStorePasswordElement != null && StringUtils.isNotEmpty((String)(resolvedPassword = MiscellaneousUtil.resolve((OMElement)keyStorePasswordElement, (SecretResolver)secretResolver)))) {
                    dataBridgeConfiguration.setKeyStorePassword(resolvedPassword);
                }
                DataBridgeConfiguration dataBridgeConfiguration2 = dataBridgeConfiguration;
                return dataBridgeConfiguration2;
            }
        }
        log.error((Object)("Cannot find data bridge configuration file : " + configPath));
        return null;
    }
}

