/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.commons.registry;

import java.util.Calendar;
import java.util.Date;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.andes.commons.CommonsUtil;
import org.wso2.carbon.andes.commons.QueueDetails;
import org.wso2.carbon.andes.commons.SubscriptionDetails;
import org.wso2.carbon.andes.commons.internal.CommonsDataHolder;
import org.wso2.carbon.andes.commons.registry.RegistryClientException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryClient {
    private static final String OWNER = "Owner";
    private static final String NAME = "Name";
    private static final String CREATED_TIME = "createdTime";
    private static final String UPDATED_TIME = "updatedTime";
    private static final String CREATED_FROM = "createdFrom";
    private static final String CREATED_FROM_AMQP = "amqp";
    private static final String USER_COUNT = "userCount";
    private static final Log log = LogFactory.getLog(RegistryClient.class);

    public static void createQueue(String queueName, String owner) throws RegistryClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving queue name \"" + queueName + "\" in Registry"));
        }
        try {
            Collection queue;
            RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
            UserRegistry registry = registryService.getGovernanceSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            String queueID = CommonsUtil.getQueueID(queueName);
            if (!registry.resourceExists(queueID)) {
                queue = registry.newCollection();
                queue.setProperty(OWNER, owner);
                queue.setProperty(NAME, queueName);
                queue.setProperty(CREATED_TIME, ConverterUtil.convertToString((Calendar)Calendar.getInstance()));
                queue.setProperty(UPDATED_TIME, ConverterUtil.convertToString((Calendar)Calendar.getInstance()));
                queue.setProperty(CREATED_FROM, CREATED_FROM_AMQP);
                queue.setProperty(USER_COUNT, "1");
            } else {
                queue = (Collection)registry.get(queueID);
                queue.setProperty(UPDATED_TIME, ConverterUtil.convertToString((Calendar)Calendar.getInstance()));
                String userCount = queue.getProperty(USER_COUNT);
                if (null != userCount) {
                    int count = Integer.parseInt(userCount);
                    queue.setProperty(USER_COUNT, Integer.toString(++count));
                }
            }
            registry.put(queueID, (Resource)queue);
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }

    public static void deleteQueue(String queueName) throws RegistryClientException {
        try {
            Collection queue;
            String userCount;
            String createdFrom;
            String queueID;
            UserRegistry registry;
            RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
            if (registryService != null && (registry = registryService.getGovernanceSystemRegistry()).resourceExists(queueID = CommonsUtil.getQueueID(queueName)) && null != (createdFrom = registry.get(queueID).getProperty(CREATED_FROM)) && CREATED_FROM_AMQP.equals(createdFrom) && null != (userCount = (queue = (Collection)registry.get(queueID)).getProperty(USER_COUNT))) {
                int count = Integer.parseInt(userCount);
                if (count > 1) {
                    queue.setProperty(USER_COUNT, Integer.toString(--count));
                    registry.put(queueID, (Resource)queue);
                } else {
                    registry.delete(queueID);
                }
            }
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }

    public static QueueDetails[] getQueues() throws RegistryClientException {
        try {
            QueueDetails[] queueDetailsArray = new QueueDetails[]{};
            RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
            UserRegistry registry = registryService.getGovernanceSystemRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : CarbonContext.getThreadLocalCarbonContext().getTenantId());
            String queuesID = CommonsUtil.getQueuesID();
            if (registry.resourceExists(queuesID)) {
                Collection queueCollection = (Collection)registry.get(queuesID);
                queueDetailsArray = new QueueDetails[queueCollection.getChildCount()];
                int index = 0;
                for (String queueId : queueCollection.getChildren()) {
                    Collection queue = (Collection)registry.get(queueId);
                    QueueDetails queueDetails = new QueueDetails();
                    queueDetails.setName(queue.getProperty(NAME));
                    queueDetails.setOwner(queue.getProperty(OWNER));
                    queueDetails.setCreatedTime(queue.getProperty(CREATED_TIME));
                    queueDetailsArray[index++] = queueDetails;
                }
            }
            return queueDetailsArray;
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }

    public static void createSubscription(String topic, String subscriptionName, String owner) throws RegistryClientException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving topic name: \"" + topic + "\" in registry, and subscription name for this topic is: " + subscriptionName));
        }
        try {
            RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
            UserRegistry registry = registryService.getGovernanceSystemRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : CarbonContext.getThreadLocalCarbonContext().getTenantId());
            String tenantBasedTopicName = RegistryClient.getTenantBasedTopicName(topic);
            String subscriptionID = CommonsUtil.getSubscriptionID(tenantBasedTopicName, subscriptionName);
            Collection subscription = !registry.resourceExists(subscriptionID) ? registry.newCollection() : (Collection)registry.get(subscriptionID);
            subscription.setProperty(OWNER, owner);
            subscription.setProperty(NAME, subscriptionName);
            subscription.setProperty(CREATED_TIME, ConverterUtil.convertToString((Date)new Date()));
            registry.put(subscriptionID, (Resource)subscription);
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }

    public static String getTenantBasedTopicName(String topicName) {
        String formattedTenantDomain;
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        String tenantBasedTopicName = topicName;
        if (tenantDomain != null && !tenantDomain.equals("carbon.super") && topicName.contains(formattedTenantDomain = tenantDomain + "/")) {
            tenantBasedTopicName = topicName.substring(formattedTenantDomain.length());
        }
        return tenantBasedTopicName;
    }

    public static void deleteSubscription(String topic, String subscriptionName) throws RegistryClientException {
        try {
            String tenantBasedTopicName;
            String subscriptionID;
            UserRegistry registry;
            RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
            if (registryService != null && (registry = registryService.getGovernanceSystemRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : CarbonContext.getThreadLocalCarbonContext().getTenantId())).resourceExists(subscriptionID = CommonsUtil.getSubscriptionID(tenantBasedTopicName = RegistryClient.getTenantBasedTopicName(topic), subscriptionName))) {
                registry.delete(subscriptionID);
            }
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }

    public static SubscriptionDetails[] getSubscriptions(String topic) throws RegistryClientException {
        try {
            SubscriptionDetails[] subscriptionDetailsArray = new SubscriptionDetails[]{};
            RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
            UserRegistry registry = registryService.getGovernanceSystemRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : CarbonContext.getThreadLocalCarbonContext().getTenantId());
            String tenantBasedTopicName = RegistryClient.getTenantBasedTopicName(topic);
            String subscriptionsID = CommonsUtil.getSubscriptionsID(tenantBasedTopicName);
            if (registry.resourceExists(subscriptionsID)) {
                Collection subscriptionCollection = (Collection)registry.get(subscriptionsID);
                subscriptionDetailsArray = new SubscriptionDetails[subscriptionCollection.getChildCount()];
                int index = 0;
                for (String subs : subscriptionCollection.getChildren()) {
                    Collection subscription = (Collection)registry.get(subs);
                    SubscriptionDetails subscriptionDetails = new SubscriptionDetails();
                    subscriptionDetails.setName(subscription.getProperty(NAME));
                    subscriptionDetails.setOwner(subscription.getProperty(OWNER));
                    subscriptionDetails.setCreatedTime(subscription.getProperty(CREATED_TIME));
                    subscriptionDetailsArray[index++] = subscriptionDetails;
                }
            }
            return subscriptionDetailsArray;
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }

    public static boolean isResourceExist(String resourceId) throws RegistryClientException {
        RegistryService registryService = CommonsDataHolder.getInstance().getRegistryService();
        try {
            UserRegistry registry = registryService.getGovernanceSystemRegistry(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            return registry.resourceExists(resourceId);
        }
        catch (RegistryException e) {
            throw new RegistryClientException(e);
        }
    }
}

