/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.commons;

import org.wso2.carbon.context.CarbonContext;

public class CommonsUtil {
    private static final String JMS_QUEUES = "event/queues/jms";
    private static final String TOPICS = "event/topics";
    private static final String JMS_SUBSCRIPTIONS = "jms.subscriptions";

    public static String getQueueID(String queueName) {
        String tenantDomain;
        if (CarbonContext.getThreadLocalCarbonContext().getTenantId() > 0 && queueName.startsWith(tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain())) {
            queueName = queueName.substring(tenantDomain.length() + 1);
        }
        if (queueName.contains(";")) {
            queueName = queueName.substring(0, queueName.indexOf(";"));
        }
        return "event/queues/jms/" + queueName;
    }

    public static String getQueuesID() {
        return JMS_QUEUES;
    }

    public static String getTopicID(String topicName) {
        String topicID = TOPICS;
        if (!(topicName = topicName.replaceAll("\\.", "/")).startsWith("/")) {
            topicID = topicID + "/";
        }
        if (topicName.contains("*")) {
            topicName = topicName.indexOf("*") > 0 ? topicName.substring(0, topicName.indexOf("*") - 1) : topicName.replace("*/", "");
        } else if (topicName.contains("#")) {
            topicName = topicName.indexOf("#") > 0 ? topicName.substring(0, topicName.indexOf("#") - 1) : topicName.replace("#/", "");
        }
        return topicID + topicName;
    }

    public static String getSubscriptionID(String topicName, String subscriptionName) {
        return CommonsUtil.getTopicID(topicName) + "/" + JMS_SUBSCRIPTIONS + "/" + subscriptionName;
    }

    public static String getSubscriptionsID(String topicName) {
        return CommonsUtil.getTopicID(topicName) + "/" + JMS_SUBSCRIPTIONS;
    }
}

