/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.operation.mgt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.OperationPersistenceManager;
import org.wso2.carbon.core.util.ParameterUtil;
import org.wso2.carbon.operation.mgt.OperationMetaData;
import org.wso2.carbon.operation.mgt.OperationMetaDataWrapper;

public class OperationAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(OperationAdmin.class);
    private OperationPersistenceManager opm = new OperationPersistenceManager(this.getAxisConfiguration());

    private AxisConfiguration getAxisConfiguration() {
        return this.getConfigurationContext().getAxisConfiguration();
    }

    private ConfigurationContext getConfigurationContext() {
        return MessageContext.getCurrentMessageContext().getConfigurationContext();
    }

    public OperationMetaDataWrapper listAllOperations(String serviceName) throws AxisFault {
        OperationMetaDataWrapper operationMetaDataWrapper = new OperationMetaDataWrapper();
        operationMetaDataWrapper.setPublishedOperations(this.listPublishedOperations(serviceName));
        operationMetaDataWrapper.setControlOperations(this.listControlOperations(serviceName));
        return operationMetaDataWrapper;
    }

    public OperationMetaData[] listControlOperations(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        ArrayList<OperationMetaData> opMetaDataList = new ArrayList<OperationMetaData>();
        for (Object o : axisService.getControlOperations()) {
            AxisOperation axisOperation = (AxisOperation)o;
            opMetaDataList.add(this.getOperationMetaData(serviceName, axisOperation.getName().getLocalPart()));
        }
        return opMetaDataList.toArray(new OperationMetaData[opMetaDataList.size()]);
    }

    public OperationMetaData[] listPublishedOperations(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        ArrayList<OperationMetaData> opList = new ArrayList<OperationMetaData>();
        for (Object o : axisService.getPublishedOperations()) {
            AxisOperation axisOperation = (AxisOperation)o;
            opList.add(this.getOperationMetaData(serviceName, axisOperation.getName().getLocalPart()));
        }
        return opList.toArray(new OperationMetaData[opList.size()]);
    }

    public OperationMetaData getOperationStatistics(String serviceName, String operationName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        if (axisService != null) {
            return this.getOperationMetaData(serviceName, operationName);
        }
        return null;
    }

    public void configureMTOM(String flag, String serviceName, String operationName) throws AxisFault {
        Parameter parameter;
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        if (axisService == null) {
            throw new AxisFault("Service " + serviceName + " cannot be found");
        }
        AxisOperation operation = axisService.getOperation(new QName(operationName));
        if (operation == null) {
            throw new AxisFault("Operation " + operationName + " in service " + serviceName + " cannot be found");
        }
        ArrayList parameters = operation.getParameters();
        boolean found = false;
        for (Parameter parameter2 : parameters) {
            if (parameter2.getParameterType() != 1 || !parameter2.getValue().toString().equals("enableMTOM")) continue;
            parameter2.setValue((Object)flag.trim());
            found = true;
            break;
        }
        if (!found) {
            parameter = ParameterUtil.createParameter((String)"enableMTOM", (String)flag.trim());
            operation.addParameter(parameter);
        }
        parameter = operation.getParameter("enableMTOM");
    }

    public String[] getOperationParameters(String serviceId, String operationId) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceId);
        AxisOperation op = axisService.getOperation(new QName(operationId));
        if (op == null) {
            throw new AxisFault("Invalid operation : " + operationId + " not available in service : " + serviceId);
        }
        ArrayList<String> allParameters = new ArrayList<String>();
        ArrayList globalParameters = this.getAxisConfig().getParameters();
        for (Object globalParameter : globalParameters) {
            Parameter parameter = (Parameter)globalParameter;
            allParameters.add(parameter.getParameterElement().toString());
        }
        AxisService service = this.getAxisConfig().getServiceForActivation(serviceId);
        if (service == null) {
            throw new AxisFault("invalid service name");
        }
        ArrayList serviceParams = service.getParameters();
        for (Object serviceParam : serviceParams) {
            Parameter parameter = (Parameter)serviceParam;
            allParameters.add(parameter.getParameterElement().toString());
        }
        AxisServiceGroup axisServiceGroup = (AxisServiceGroup)service.getParent();
        ArrayList serviceGroupParams = axisServiceGroup.getParameters();
        for (Object serviceGroupParam : serviceGroupParams) {
            Parameter parameter = (Parameter)serviceGroupParam;
            allParameters.add(parameter.getParameterElement().toString());
        }
        ArrayList opParams = op.getParameters();
        for (Object opParam : opParams) {
            Parameter parameter = (Parameter)opParam;
            allParameters.add(parameter.getParameterElement().toString());
        }
        Collections.sort(allParameters, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg0.compareToIgnoreCase(arg1);
            }
        });
        return allParameters.toArray(new String[allParameters.size()]);
    }

    public String[] getDeclaredOperationParameters(String serviceName, String operationName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        AxisOperation op = axisService.getOperation(new QName(operationName));
        if (op == null) {
            throw new AxisFault("Invalid operation : " + operationName + " not available in service : " + serviceName);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        ArrayList opParams = op.getParameters();
        for (Object opParam : opParams) {
            Parameter parameter = (Parameter)opParam;
            OMElement element = parameter.getParameterElement();
            if (element == null) continue;
            parameters.add(element.toString());
        }
        Collections.sort(parameters, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg0.compareToIgnoreCase(arg1);
            }
        });
        return parameters.toArray(new String[parameters.size()]);
    }

    public void setOperationParameters(String serviceId, String operationId, String[] parameters) throws AxisFault {
        for (String parameter : parameters) {
            this.setOperationParameter(serviceId, operationId, parameter);
        }
    }

    private void setOperationParameter(String serviceName, String operationName, String parameterStr) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name service not found : " + serviceName);
        }
        AxisOperation axisOp = axisService.getOperation(new QName(operationName));
        if (axisOp == null) {
            throw new AxisFault("Invalid operation : " + operationName + " not available in service : " + serviceName);
        }
        OMElement paramEle = null;
        try {
            XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(parameterStr.getBytes()));
            paramEle = new StAXOMBuilder(xmlSR).getDocumentElement();
        }
        catch (XMLStreamException e) {
            this.handleException("Cannot create OMElement from parameter: " + parameterStr, e);
        }
        Parameter parameter = ParameterUtil.createParameter((OMElement)paramEle);
        axisOp.addParameter(parameter);
        try {
            this.opm.updateOperationParameter(axisOp, parameter);
        }
        catch (Exception e) {
            String msg = "Cannot persist operation parameter for operation " + axisOp.getName();
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public void removeOperationParameter(String serviceName, String operationName, String parameterName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        if (axisService == null) {
            throw new AxisFault("invalid service name service not found : " + serviceName);
        }
        AxisOperation axisOp = axisService.getOperation(new QName(operationName));
        if (axisOp == null) {
            throw new AxisFault("Invalid operation : " + operationName + " not available in service : " + serviceName);
        }
        Parameter parameter = ParameterUtil.createParameter((String)parameterName, null);
        axisOp.removeParameter(parameter);
        try {
            this.opm.removeOperationParameter(axisOp, parameter);
        }
        catch (Exception e) {
            String msg = "Cannot persist operation parameter removal. Operation " + serviceName + ":" + operationName;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public String[] listOperationPhases(String serviceName, String operationName, int flow) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        AxisOperation op = axisService.getOperation(new QName(operationName));
        if (op == null) {
            throw new AxisFault("Invalid operation : " + operationName + " not available in service : " + serviceName);
        }
        String[] phaseNames = null;
        switch (flow) {
            case 1: {
                ArrayList inflow = op.getRemainingPhasesInFlow();
                phaseNames = new String[inflow.size()];
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    phaseNames[i] = phase.getPhaseName();
                }
                break;
            }
            case 2: {
                ArrayList inflow = op.getPhasesOutFlow();
                phaseNames = new String[inflow.size()];
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    phaseNames[i] = phase.getPhaseName();
                }
                break;
            }
            case 3: {
                ArrayList inflow = op.getPhasesInFaultFlow();
                phaseNames = new String[inflow.size()];
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    phaseNames[i] = phase.getPhaseName();
                }
                break;
            }
            case 4: {
                ArrayList inflow = op.getPhasesOutFaultFlow();
                phaseNames = new String[inflow.size()];
                for (int i = 0; i < inflow.size(); ++i) {
                    Phase phase = (Phase)inflow.get(i);
                    phaseNames[i] = phase.getPhaseName();
                }
                break;
            }
        }
        return phaseNames;
    }

    public String[] listOperationPhaseHandlers(String serviceName, String operationName, int flow, String phaseName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        AxisOperation op = axisService.getOperation(new QName(operationName));
        if (op == null) {
            throw new AxisFault("Invalid operation : " + operationName + " not available in service : " + serviceName);
        }
        String[] handlers = null;
        switch (flow) {
            case 1: {
                ArrayList inflow = op.getRemainingPhasesInFlow();
                for (Object anInflow : inflow) {
                    Phase phase = (Phase)anInflow;
                    if (!phase.getPhaseName().equals(phaseName)) continue;
                    handlers = new String[phase.getHandlerCount()];
                    List hands = phase.getHandlers();
                    for (int j = 0; j < hands.size(); ++j) {
                        Handler handler = (Handler)hands.get(j);
                        handlers[j] = handler.getName();
                    }
                }
                break;
            }
            case 2: {
                ArrayList inflow = op.getPhasesOutFlow();
                for (Object anInflow : inflow) {
                    Phase phase = (Phase)anInflow;
                    if (!phase.getPhaseName().equals(phaseName)) continue;
                    handlers = new String[phase.getHandlerCount()];
                    List hands = phase.getHandlers();
                    for (int j = 0; j < hands.size(); ++j) {
                        Handler handler = (Handler)hands.get(j);
                        handlers[j] = handler.getName();
                    }
                }
                break;
            }
            case 3: {
                ArrayList inflow = op.getPhasesInFaultFlow();
                for (Object anInflow : inflow) {
                    Phase phase = (Phase)anInflow;
                    if (!phase.getPhaseName().equals(phaseName)) continue;
                    handlers = new String[phase.getHandlerCount()];
                    List hands = phase.getHandlers();
                    for (int j = 0; j < hands.size(); ++j) {
                        Handler handler = (Handler)hands.get(j);
                        handlers[j] = handler.getName();
                    }
                }
                break;
            }
            case 4: {
                ArrayList inflow = op.getPhasesOutFaultFlow();
                for (Object anInflow : inflow) {
                    Phase phase = (Phase)anInflow;
                    if (!phase.getPhaseName().equals(phaseName)) continue;
                    handlers = new String[phase.getHandlerCount()];
                    List hands = phase.getHandlers();
                    for (int j = 0; j < hands.size(); ++j) {
                        Handler handler = (Handler)hands.get(j);
                        handlers[j] = handler.getName();
                    }
                }
                break;
            }
        }
        return handlers;
    }

    public OperationMetaData getOperationMetaData(String serviceName, String operationName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        AxisOperation axisOperation = null;
        if (axisService != null) {
            axisOperation = axisService.getOperation(new QName(operationName));
        }
        if (axisOperation == null) {
            return null;
        }
        OperationMetaData opMetaData = new OperationMetaData();
        opMetaData.setName(axisOperation.getName().getLocalPart());
        opMetaData.setControlOperation(axisOperation.isControlOperation());
        Parameter parameter = axisOperation.getParameter("enableMTOM");
        if (parameter != null) {
            opMetaData.setEnableMTOM((String)parameter.getValue());
        } else {
            opMetaData.setEnableMTOM("false");
        }
        return opMetaData;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

