/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rest.api.service;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.api.API;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.rest.APIFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.rest.api.APIData;
import org.wso2.carbon.rest.api.APIException;
import org.wso2.carbon.rest.api.ConfigHolder;
import org.wso2.carbon.rest.api.RestApiAdminUtils;
import org.wso2.carbon.rest.api.UnauthorizedAccessException;

public class RestApiAdminService {
    private static final Log log = LogFactory.getLog(RestApiAdminService.class);
    private static final String TENANT_DELIMITER = "/t/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addApi(APIData apiData) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
            if (!RestApiAdminUtils.isNullOrEmpty(tenantDomain) && !"carbon.super".equals(tenantDomain)) {
                String tenantApiContext = apiData.getContext();
                apiData.setContext(TENANT_DELIMITER + tenantDomain + tenantApiContext);
            }
            this.addApi(RestApiAdminUtils.retrieveAPIOMElement(apiData), null, false);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addApiForTenant(APIData apiData, String tenantDomain) throws APIException {
        boolean status;
        if (-1234 != CarbonContext.getThreadLocalCarbonContext().getTenantId()) {
            throw new UnauthorizedAccessException("This method is only accessible to a valid super tenant user");
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
            status = this.addApi(apiData);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addApiFromString(String apiData) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            OMElement apiElement = AXIOMUtil.stringToOM((String)apiData);
            this.addApi(apiElement, null, false);
            boolean bl = true;
            return bl;
        }
        catch (XMLStreamException e) {
            this.handleException(log, "Could not parse String to OMElement", e);
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addApiForTenant(String apiData, String tenantDomain) throws APIException {
        boolean status = false;
        if (-1234 != CarbonContext.getThreadLocalCarbonContext().getTenantId()) {
            throw new UnauthorizedAccessException("This method is only accessible to a valid super tenant user");
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            status = this.addApiFromString(apiData);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIData getApiForTenant(String apiName, String tenantDomain) throws APIException {
        APIData apiData = null;
        if (-1234 != CarbonContext.getThreadLocalCarbonContext().getTenantId()) {
            throw new UnauthorizedAccessException("This method is only accessible to a valid super tenant user");
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            apiData = this.getApiByName(apiName);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return apiData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIData getApiByName(String apiName) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = RestApiAdminUtils.getSynapseConfiguration();
            API api = synapseConfiguration.getAPI(apiName);
            APIData aPIData = RestApiAdminUtils.convertApiToAPIData(api);
            return aPIData;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateApiFromString(String apiName, String apiData) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(log, apiName);
            OMElement apiElement = AXIOMUtil.stringToOM((String)apiData);
            OMAttribute nameAttribute = apiElement.getAttribute(new QName("name"));
            if (nameAttribute == null || "".equals(nameAttribute.getAttributeValue().trim())) {
                apiElement.addAttribute("name", apiName, null);
            }
            API api = APIFactory.createAPI((OMElement)apiElement);
            SynapseConfiguration synapseConfiguration = RestApiAdminUtils.getSynapseConfiguration();
            API oldAPI = synapseConfiguration.getAPI(apiName);
            if (oldAPI != null) {
                oldAPI.destroy();
                api.setFileName(oldAPI.getFileName());
            }
            synapseConfiguration.removeAPI(apiName);
            synapseConfiguration.addAPI(api.getName(), api);
            api.init(RestApiAdminUtils.getSynapseEnvironment());
            if ((oldAPI != null ? oldAPI.getArtifactContainerName() : null) != null) {
                api.setArtifactContainerName(oldAPI.getArtifactContainerName());
                api.setIsEdited(true);
                this.getApiByName(apiName).setIsEdited(true);
            } else if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                MediationPersistenceManager pm = RestApiAdminUtils.getMediationPersistenceManager();
                String fileName = api.getFileName();
                pm.deleteItem(apiName, fileName, 13);
                pm.saveItem(apiName, 13);
            }
            boolean bl = true;
            return bl;
        }
        catch (XMLStreamException e) {
            this.handleException(log, "Could not parse String to OMElement", e);
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateApiForTenant(String apiName, String apiData, String tenantDomain) throws APIException {
        boolean status = false;
        if (-1234 != CarbonContext.getThreadLocalCarbonContext().getTenantId()) {
            throw new UnauthorizedAccessException("This method is only accessible to a valid super tenant user");
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            status = this.updateApiFromString(apiName, apiData);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteApi(String apiName) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(log, apiName);
            apiName = apiName.trim();
            SynapseConfiguration synapseConfiguration = RestApiAdminUtils.getSynapseConfiguration();
            API api = synapseConfiguration.getAPI(apiName);
            if (api.getArtifactContainerName() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting API : " + apiName + " from the configuration"));
                }
                api.destroy();
                synapseConfiguration.removeAPI(apiName);
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    MediationPersistenceManager pm = RestApiAdminUtils.getMediationPersistenceManager();
                    String fileName = api.getFileName();
                    pm.deleteItem(apiName, fileName, 13);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Api : " + apiName + " removed from the configuration"));
                }
            }
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteApiForTenant(String apiName, String tenantDomain) throws APIException {
        boolean status = false;
        if (-1234 != CarbonContext.getThreadLocalCarbonContext().getTenantId()) {
            throw new UnauthorizedAccessException("This method is only accessible to a valid super tenant user");
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            status = this.deleteApi(apiName);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return status;
    }

    protected Lock getLock() throws APIException {
        AxisConfiguration axisConfig = ConfigHolder.getInstance().getAxisConfiguration();
        Parameter p = axisConfig.getParameter("synapse.config.lock");
        if (p != null) {
            return (Lock)p.getValue();
        }
        log.warn((Object)"synapse.config.lock is null, Recreating a new lock");
        ReentrantLock lock = new ReentrantLock();
        try {
            axisConfig.addParameter("synapse.config.lock", (Object)lock);
            return lock;
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while setting synapse.config.lock");
            return null;
        }
    }

    private void addApi(OMElement apiElement, String fileName, boolean updateMode) throws APIException {
        if (!apiElement.getQName().getLocalPart().equals(XMLConfigConstants.API_ELT.getLocalPart())) {
            this.handleException(log, "Invalid API definition", null);
        }
        String apiName = apiElement.getAttributeValue(new QName("name"));
        String apiTransports = apiElement.getAttributeValue(new QName("transports"));
        try {
            AxisService apiImpl = RestApiAdminUtils.getSynapseConfiguration().getAxisConfiguration().getService(apiName);
            if (apiImpl != null) {
                this.handleException(log, "A service named " + apiName + " already exists", null);
            }
        }
        catch (AxisFault axisFault) {
            this.handleException(log, "Error occurred while checking if a service named '" + apiName + "' exists", null);
        }
        API api = APIFactory.createAPI((OMElement)apiElement);
        try {
            RestApiAdminUtils.getSynapseConfiguration().addAPI(api.getName(), api);
            if (log.isDebugEnabled()) {
                log.debug((Object)("API '" + apiName + "' is being added"));
                log.debug((Object)("Configured Transports : " + apiTransports));
            }
            if (apiTransports != null) {
                if ("http".equalsIgnoreCase(apiTransports)) {
                    api.setProtocol(1);
                } else if ("https".equalsIgnoreCase(apiTransports)) {
                    api.setProtocol(2);
                }
            }
            if (updateMode) {
                api.setFileName(fileName);
            } else if (fileName != null) {
                api.setFileName(fileName);
            } else {
                api.setFileName(ServiceBusUtils.generateFileName((String)api.getName()));
            }
            api.init(RestApiAdminUtils.getSynapseEnvironment());
            RestApiAdminUtils.persistApi(api);
        }
        catch (APIException e) {
            api.destroy();
            RestApiAdminUtils.getSynapseConfiguration().removeAPI(api.getName());
            try {
                AxisConfiguration axisConfig = ConfigHolder.getInstance().getAxisConfiguration();
                if (axisConfig.getService(api.getName()) != null) {
                    axisConfig.removeService(api.getName());
                }
            }
            catch (AxisFault axisFault) {
                // empty catch block
            }
            this.handleException(log, "Error occurred while trying to add the API to the ESB configuration : " + api.getName(), e);
        }
    }

    private void handleException(Log log, String message, Exception e) throws APIException {
        if (e != null) {
            log.error((Object)message, (Throwable)e);
            throw new APIException(e.getMessage(), e);
        }
        log.error((Object)message);
        throw new APIException(message);
    }

    private void assertNameNotEmpty(Log log, String apiName) throws APIException {
        if (apiName == null || "".equals(apiName.trim())) {
            this.handleException(log, "Invalid name : Name is empty.", null);
        }
    }
}

