/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rest.api.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.api.API;
import org.apache.synapse.api.dispatch.DispatcherHelper;
import org.apache.synapse.api.dispatch.URITemplateHelper;
import org.apache.synapse.api.dispatch.URLMappingHelper;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.rest.APIFactory;
import org.apache.synapse.config.xml.rest.APISerializer;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.CarbonConfigurationContextFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.mediation.commons.rest.api.swagger.APIGenException;
import org.wso2.carbon.mediation.commons.rest.api.swagger.APIGenerator;
import org.wso2.carbon.mediation.commons.rest.api.swagger.GenericApiObjectDefinition;
import org.wso2.carbon.mediation.commons.rest.api.swagger.OpenAPIProcessor;
import org.wso2.carbon.mediation.commons.rest.api.swagger.SwaggerConstants;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.mediation.registry.RegistryServiceHolder;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.rest.api.APIData;
import org.wso2.carbon.rest.api.APIDataSorter;
import org.wso2.carbon.rest.api.APIException;
import org.wso2.carbon.rest.api.ConfigHolder;
import org.wso2.carbon.rest.api.ResourceData;
import org.wso2.carbon.rest.api.RestApiAdminUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.NetworkUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class RestApiAdmin
extends AbstractServiceBusAdmin {
    private static Log log = LogFactory.getLog(RestApiAdmin.class);
    private static final String TENANT_DELIMITER = "/t/";
    private static final String APPLICATION_JSON_TYPE = "application/json";
    public static final String SYNAPSE_CONFIGURATION = "SynapseConfiguration";
    private static final String CONFIG_REG_PREFIX = "conf:";
    private static final String GOV_REG_PREFIX = "gov:";
    private static final String FILE_PREFIX = "file:";
    private static final String TITLE = "title";
    private boolean saveRuntimeArtifacts = SynapsePropertiesLoader.getBooleanProperty((String)"synapse.artifacts.file.storage.enabled", (Boolean)true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addApi(APIData apiData) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
            if (tenantDomain != null && !tenantDomain.isEmpty() && !tenantDomain.equals("carbon.super")) {
                String tenantApiContext = apiData.getContext();
                apiData.setContext(TENANT_DELIMITER + tenantDomain + tenantApiContext);
            }
            this.addApi(RestApiAdminUtils.retrieveAPIOMElement(apiData), null, false);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addApiFromString(String apiData) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            OMElement apiElement = AXIOMUtil.stringToOM((String)apiData);
            this.addApi(apiElement, null, false);
            boolean bl = true;
            return bl;
        }
        catch (XMLStreamException e) {
            this.handleException(log, "Could not parse String to OMElement", e);
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addApiForTenant(String apiData, String tenantDomain) throws APIException {
        try {
            boolean status;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            boolean bl = status = this.addApiFromString(apiData);
            return bl;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateApi(String apiName, APIData apiData) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(apiName);
            API oldAPI = null;
            Properties properties = new Properties();
            properties.put(SYNAPSE_CONFIGURATION, this.getSynapseConfiguration());
            API api = APIFactory.createAPI((OMElement)RestApiAdminUtils.retrieveAPIOMElement(apiData), (Properties)properties);
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            oldAPI = synapseConfiguration.getAPI(apiName);
            if (oldAPI != null) {
                oldAPI.destroy();
                api.setFileName(oldAPI.getFileName());
            }
            synapseConfiguration.updateAPI(apiName, api);
            api.init(this.getSynapseEnvironment());
            if (oldAPI.getArtifactContainerName() != null) {
                api.setIsEdited(true);
                api.setArtifactContainerName(oldAPI.getArtifactContainerName());
                apiData.setIsEdited(true);
            } else if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && this.saveRuntimeArtifacts) {
                MediationPersistenceManager pm = this.getMediationPersistenceManager();
                String fileName = api.getFileName();
                pm.deleteItem(apiName, fileName, 13);
                pm.saveItem(apiName, 13);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateApiFromString(String apiName, String apiData) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(apiName);
            OMElement apiElement = AXIOMUtil.stringToOM((String)apiData);
            OMAttribute nameAttribute = apiElement.getAttribute(new QName("name"));
            if (nameAttribute == null || nameAttribute.getAttributeValue().trim().isEmpty()) {
                apiElement.addAttribute("name", apiName, null);
            }
            Properties properties = new Properties();
            properties.put(SYNAPSE_CONFIGURATION, this.getSynapseConfiguration());
            API api = APIFactory.createAPI((OMElement)apiElement, (Properties)properties);
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            API oldAPI = synapseConfiguration.getAPI(apiName);
            if (oldAPI != null) {
                oldAPI.destroy();
                api.setFileName(oldAPI.getFileName());
            }
            synapseConfiguration.removeAPI(apiName);
            synapseConfiguration.addAPI(api.getName(), api);
            api.init(this.getSynapseEnvironment());
            if (oldAPI.getArtifactContainerName() != null) {
                api.setArtifactContainerName(oldAPI.getArtifactContainerName());
                api.setIsEdited(true);
                this.getApiByName(api.getName()).setIsEdited(true);
            } else if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && this.saveRuntimeArtifacts) {
                MediationPersistenceManager pm = this.getMediationPersistenceManager();
                String fileName = api.getFileName();
                pm.deleteItem(apiName, fileName, 13);
                pm.saveItem(apiName, 13);
            }
            boolean bl = true;
            return bl;
        }
        catch (XMLStreamException e) {
            this.handleException(log, "Could not parse String to OMElement", e);
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateApiForTenant(String apiName, String apiData, String tenantDomain) throws APIException {
        try {
            boolean status;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            boolean bl = status = this.updateApiFromString(apiName, apiData);
            return bl;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteApi(String apiName) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(apiName);
            apiName = apiName.trim();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            API api = synapseConfiguration.getAPI(apiName);
            if (api.getArtifactContainerName() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting API : " + apiName + " from the configuration"));
                }
                api.destroy();
                synapseConfiguration.removeAPI(apiName);
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && this.saveRuntimeArtifacts) {
                    MediationPersistenceManager pm = this.getMediationPersistenceManager();
                    String fileName = api.getFileName();
                    pm.deleteItem(apiName, fileName, 13);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Api : " + apiName + " removed from the configuration"));
                }
            }
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedApi(String[] apiNames) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            for (String apiName : apiNames) {
                this.assertNameNotEmpty(apiName);
                apiName = apiName.trim();
                SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
                API api = synapseConfiguration.getAPI(apiName);
                if (api.getArtifactContainerName() != null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting API : " + apiName + " from the configuration"));
                }
                api.destroy();
                synapseConfiguration.removeAPI(apiName);
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && this.saveRuntimeArtifacts) {
                    MediationPersistenceManager pm = this.getMediationPersistenceManager();
                    String fileName = api.getFileName();
                    pm.deleteItem(apiName, fileName, 13);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Api : " + apiName + " removed from the configuration"));
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void deleteAllApi() throws APIException {
        String[] allApiNames = this.getApiNames();
        this.deleteSelectedApi(allApiNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteApiForTenant(String apiName, String tenantDomain) throws APIException {
        try {
            boolean status;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            boolean bl = status = this.deleteApi(apiName);
            return bl;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIData[] getAPIsForListing(int pageNumber, int itemsPerPage) {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Collection apis = synapseConfiguration.getAPIs();
            ArrayList<APIData> apiDataList = null;
            if (apis != null) {
                apiDataList = new ArrayList<APIData>(apis.size());
                for (API api : apis) {
                    APIData apiData = new APIData();
                    apiData.setName(api.getName());
                    apiData.setContext(api.getContext());
                    if (api.getAspectConfiguration() != null && api.getAspectConfiguration().isStatisticsEnable()) {
                        apiData.setStatisticsEnable(true);
                    } else {
                        apiData.setStatisticsEnable(false);
                    }
                    if (api.getAspectConfiguration() != null && api.getAspectConfiguration().isTracingEnabled()) {
                        apiData.setTracingEnable(true);
                    } else {
                        apiData.setTracingEnable(false);
                    }
                    if (api.getArtifactContainerName() != null) {
                        apiData.setArtifactContainerName(api.getArtifactContainerName());
                    }
                    if (api.isEdited()) {
                        apiData.setIsEdited(true);
                    }
                    apiData.setSwaggerDefKey(api.getSwaggerResourcePath());
                    apiDataList.add(apiData);
                }
                Collections.sort(apiDataList, new APIDataSorter());
                int size = apiDataList.size();
                int startIndex = pageNumber * itemsPerPage;
                int endIndex = (pageNumber + 1) * itemsPerPage;
                List returnList = null;
                if (size <= startIndex) {
                    APIData[] aPIDataArray = null;
                    return aPIDataArray;
                }
                returnList = size <= endIndex ? apiDataList.subList(startIndex, size) : apiDataList.subList(startIndex, endIndex);
                APIData[] aPIDataArray = returnList.toArray(new APIData[returnList.size()]);
                return aPIDataArray;
            }
            APIData[] aPIDataArray = null;
            return aPIDataArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAPICount() {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Collection apis = synapseConfiguration.getAPIs();
            if (apis != null) {
                int n = apis.size();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public String getServerContext() throws APIException {
        String host;
        AxisConfiguration configuration = null;
        try {
            configuration = ConfigHolder.getInstance().getAxisConfiguration();
        }
        catch (APIException e) {
            this.handleException(log, "Could not retrieve server context", e);
        }
        TransportInDescription transportInDescription = configuration.getTransportIn("http");
        if (transportInDescription == null) {
            transportInDescription = configuration.getTransportIn("https");
        }
        if (transportInDescription == null) {
            throw new APIException("http/https transport required");
        }
        String protocol = transportInDescription.getName();
        String portValue = (String)transportInDescription.getParameter("port").getValue();
        Parameter hostParam = configuration.getParameter("hostname");
        if (hostParam != null) {
            host = (String)hostParam.getValue();
        } else {
            try {
                host = NetworkUtils.getLocalHostname();
            }
            catch (SocketException e) {
                log.warn((Object)"SocketException occured when trying to obtain IP address of local machine");
                host = "localhost";
            }
        }
        String serverContext = "";
        try {
            int port = Integer.parseInt(portValue);
            if ("http".equals(protocol) && port == 80) {
                port = -1;
            } else if ("https".equals(protocol) && port == 443) {
                port = -1;
            }
            URL serverURL = new URL(protocol, host, port, "");
            serverContext = serverURL.toExternalForm();
        }
        catch (MalformedURLException e) {
            this.handleException(log, "Error when generating server context URL", e);
        }
        catch (NumberFormatException e) {
            this.handleException(log, "Error when getting the port for server context URL", e);
        }
        return serverContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getApiNames() {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Collection apis = synapseConfiguration.getAPIs();
            String[] stringArray = this.listToNames(apis.toArray(new API[apis.size()]));
            return stringArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIData getApiByName(String apiName) {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            API api = synapseConfiguration.getAPI(apiName);
            APIData aPIData = this.convertApiToAPIData(api);
            return aPIData;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected API getSynapseAPIByName(String apiName) {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            API aPI = synapseConfiguration.getAPI(apiName);
            return aPI;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIData getApiForTenant(String apiName, String tenantDomain) throws APIException {
        try {
            APIData data;
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            APIData aPIData = data = this.getApiByName(apiName);
            return aPIData;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSequences() {
        Lock lock = this.getLock();
        String[] sequenceNames = new String[]{};
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Map sequences = synapseConfiguration.getDefinedSequences();
            if (sequences != null && !sequences.isEmpty()) {
                sequenceNames = new String[sequences.size()];
                String[] stringArray = sequences.keySet().toArray(sequenceNames);
                return stringArray;
            }
            String[] stringArray = sequenceNames;
            return stringArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enableStatistics(String apiName) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            API api = synapseConfiguration.getAPI(apiName);
            if (api != null) {
                if (api.getAspectConfiguration() == null) {
                    AspectConfiguration config = new AspectConfiguration(apiName);
                    config.enableStatistics();
                    api.configure(config);
                } else {
                    api.getAspectConfiguration().enableStatistics();
                }
                if (api.getArtifactContainerName() == null) {
                    this.persistApi(api);
                }
                String string = apiName;
                return string;
            }
            this.handleException(log, "No defined API with name " + apiName + " found to enable statistics in the Synapse configuration", null);
        }
        catch (Exception fault) {
            this.handleException(log, "Couldn't enable statistics of the API " + apiName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String disableStatistics(String apiName) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            API api = synapseConfiguration.getAPI(apiName);
            if (api != null) {
                if (api.getAspectConfiguration() == null) {
                    AspectConfiguration config = new AspectConfiguration(apiName);
                    config.disableStatistics();
                    api.configure(config);
                } else {
                    api.getAspectConfiguration().disableStatistics();
                }
                if (api.getArtifactContainerName() == null) {
                    this.persistApi(api);
                }
                String string = apiName;
                return string;
            }
            this.handleException(log, "No defined API with name " + apiName + " found to disable statistics in the Synapse configuration", null);
        }
        catch (Exception fault) {
            this.handleException(log, "Couldn't disable statistics of the API " + apiName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enableTracing(String apiName) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            API api = synapseConfiguration.getAPI(apiName);
            if (api != null) {
                if (api.getAspectConfiguration() == null) {
                    AspectConfiguration config = new AspectConfiguration(apiName);
                    config.enableTracing();
                    config.enableStatistics();
                    api.configure(config);
                } else {
                    api.getAspectConfiguration().enableTracing();
                    api.getAspectConfiguration().enableStatistics();
                }
                if (api.getArtifactContainerName() == null) {
                    this.persistApi(api);
                }
                String string = apiName;
                return string;
            }
            this.handleException(log, "No defined API with name " + apiName + " found to enable tracing in the Synapse configuration", null);
        }
        catch (Exception fault) {
            this.handleException(log, "Couldn't enable tracing of the API " + apiName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String disableTracing(String apiName) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            API api = synapseConfiguration.getAPI(apiName);
            if (api != null) {
                if (api.getAspectConfiguration() == null) {
                    AspectConfiguration config = new AspectConfiguration(apiName);
                    config.disableTracing();
                    api.configure(config);
                } else {
                    api.getAspectConfiguration().disableTracing();
                }
                if (api.getArtifactContainerName() == null) {
                    this.persistApi(api);
                }
                String string = apiName;
                return string;
            }
            this.handleException(log, "No defined API with name " + apiName + " found to disable tracing in the Synapse configuration", null);
        }
        catch (Exception fault) {
            this.handleException(log, "Couldn't disable tracing of the API " + apiName + " : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    public String getApiSource(APIData apiData) {
        return RestApiAdminUtils.retrieveAPIOMElement(apiData).toString();
    }

    public String getResourceSource(ResourceData resourceData) {
        return RestApiAdminUtils.retrieveResourceOMElement(resourceData).toString();
    }

    private APIData convertApiToAPIData(API api) {
        if (api == null) {
            return null;
        }
        APIData apiData = new APIData();
        apiData.setName(api.getName());
        apiData.setContext(api.getContext());
        apiData.setHost(api.getHost());
        apiData.setPort(api.getPort());
        apiData.setFileName(api.getFileName());
        apiData.setVersion(api.getVersion());
        apiData.setVersionType(api.getVersionStrategy().getVersionType());
        if (api.getAspectConfiguration() != null && api.getAspectConfiguration().isStatisticsEnable()) {
            apiData.setStatisticsEnable(true);
        } else {
            apiData.setStatisticsEnable(false);
        }
        if (api.getAspectConfiguration() != null && api.getAspectConfiguration().isTracingEnabled()) {
            apiData.setTracingEnable(true);
        } else {
            apiData.setTracingEnable(false);
        }
        if (api.getSwaggerResourcePath() != null) {
            apiData.setSwaggerDefKey(api.getSwaggerResourcePath());
        }
        org.apache.synapse.api.Resource[] resources = api.getResources();
        ResourceData[] resourceDatas = new ResourceData[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            org.apache.synapse.api.Resource resource = resources[i];
            ResourceData data = new ResourceData();
            String[] methods = resource.getMethods();
            data.setMethods(methods);
            data.setContentType(resource.getContentType());
            data.setProtocol(resource.getProtocol());
            DispatcherHelper dispatcherHelper = resource.getDispatcherHelper();
            if (dispatcherHelper instanceof URITemplateHelper) {
                data.setUriTemplate(dispatcherHelper.getString());
            } else if (dispatcherHelper instanceof URLMappingHelper) {
                data.setUrlMapping(dispatcherHelper.getString());
            }
            if (resource.getInSequenceKey() != null) {
                data.setInSequenceKey(resource.getInSequenceKey());
            } else if (resource.getInSequence() != null) {
                data.setInSeqXml(RestApiAdminUtils.createAnonymousSequenceElement(resource.getInSequence(), "inSequence").toString());
            }
            if (resource.getOutSequenceKey() != null) {
                data.setOutSequenceKey(resource.getOutSequenceKey());
            } else if (resource.getOutSequence() != null) {
                data.setOutSeqXml(RestApiAdminUtils.createAnonymousSequenceElement(resource.getOutSequence(), "outSequence").toString());
            }
            if (resource.getFaultSequenceKey() != null) {
                data.setFaultSequenceKey(resource.getFaultSequenceKey());
            } else if (resource.getFaultSequence() != null) {
                data.setFaultSeqXml(RestApiAdminUtils.createAnonymousSequenceElement(resource.getFaultSequence(), "faultSequence").toString());
            }
            data.setUserAgent(resource.getUserAgent());
            resourceDatas[i] = data;
        }
        apiData.setResources(resourceDatas);
        return apiData;
    }

    private String[] listToNames(API[] apis) {
        if (apis == null) {
            return null;
        }
        String[] datas = new String[apis.length];
        for (int i = 0; i < apis.length; ++i) {
            API api = apis[i];
            datas[i] = api.getName();
        }
        return datas;
    }

    private void addApi(OMElement apiElement, String fileName, boolean updateMode) throws APIException {
        block18: {
            try {
                if (apiElement.getQName().getLocalPart().equals(XMLConfigConstants.API_ELT.getLocalPart())) {
                    String apiName = apiElement.getAttributeValue(new QName("name"));
                    String apiTransports = apiElement.getAttributeValue(new QName("transports"));
                    if (this.getSynapseConfiguration().getAxisConfiguration().getService(apiName) != null) {
                        this.handleException(log, "A service named " + apiName + " already exists", null);
                        break block18;
                    }
                    Properties properties = new Properties();
                    properties.put(SYNAPSE_CONFIGURATION, this.getSynapseConfiguration());
                    API api = APIFactory.createAPI((OMElement)apiElement, (Properties)properties);
                    try {
                        this.getSynapseConfiguration().addAPI(api.getName(), api);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Added API : " + apiName));
                            log.debug((Object)("Authorized Transports : " + apiTransports));
                        }
                        if (apiTransports != null) {
                            if ("http".equalsIgnoreCase(apiTransports)) {
                                api.setProtocol(1);
                            } else if ("https".equalsIgnoreCase(apiTransports)) {
                                api.setProtocol(2);
                            }
                        }
                        if (updateMode) {
                            api.setFileName(fileName);
                        } else if (fileName != null) {
                            api.setFileName(fileName);
                        } else {
                            api.setFileName(ServiceBusUtils.generateFileName((String)api.getName()));
                        }
                        api.init(this.getSynapseEnvironment());
                        this.persistApi(api);
                    }
                    catch (Exception e) {
                        api.destroy();
                        this.getSynapseConfiguration().removeAPI(api.getName());
                        try {
                            if (this.getAxisConfig().getService(api.getName()) != null) {
                                this.getAxisConfig().removeService(api.getName());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.handleException(log, "Error trying to add the API to the ESB configuration : " + api.getName(), e);
                    }
                    break block18;
                }
                this.handleException(log, "Invalid API definition", null);
            }
            catch (AxisFault af) {
                this.handleException(log, "Invalid API definition", (Exception)((Object)af));
            }
        }
    }

    private void handleException(Log log, String message, Exception e) throws APIException {
        if (e == null) {
            APIException apiException = new APIException(message);
            log.error((Object)message, (Throwable)apiException);
            throw apiException;
        }
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new APIException(message, e);
    }

    private void persistApi(API api) throws APIException {
        MediationPersistenceManager pm;
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && this.saveRuntimeArtifacts && (pm = this.getMediationPersistenceManager()) != null) {
            pm.saveItem(api.getName(), 13);
        }
    }

    private void assertNameNotEmpty(String apiName) throws APIException {
        if (apiName == null || "".equals(apiName.trim())) {
            this.handleFault("Invalid name : Name is empty.", null);
        }
    }

    private void handleFault(String message, Exception e) throws APIException {
        if (e != null) {
            log.error((Object)message, (Throwable)e);
            throw new APIException(e.getMessage(), e);
        }
        log.error((Object)message);
        throw new APIException(message);
    }

    protected SynapseConfiguration getSynapseConfiguration() {
        return (SynapseConfiguration)this.getAxisConfig().getParameter("synapse.config").getValue();
    }

    protected AxisConfiguration getAxisConfig() {
        return this.axisConfig != null ? this.axisConfig : this.getConfigContext().getAxisConfiguration();
    }

    protected ConfigurationContext getConfigContext() {
        if (this.configurationContext != null) {
            return this.configurationContext;
        }
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        if (msgContext != null) {
            ConfigurationContext mainConfigContext = msgContext.getConfigurationContext();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            String domain = carbonContext.getTenantDomain();
            if (domain != null && !"carbon.super".equals(domain)) {
                return TenantAxisUtils.getTenantConfigurationContext((String)domain, (ConfigurationContext)mainConfigContext);
            }
            if (carbonContext.getTenantId() == -1234) {
                return mainConfigContext;
            }
            throw new UnsupportedOperationException("Tenant domain unidentified. Upstream code needs to identify & set the tenant domain & tenant ID.  The TenantDomain SOAP header could be set by the clients or tenant authentication should be carried out.");
        }
        return CarbonConfigurationContextFactory.getConfigurationContext();
    }

    public void addSwaggerDocument(String apiName, String swaggerJsonString, int tenantId) throws APIException {
        String resourcePath = SwaggerConstants.DEFAULT_SWAGGER_REGISTRY_PATH + apiName + "/swagger.json";
        RegistryService registryService = RegistryServiceHolder.getInstance().getRegistryService();
        try {
            UserRegistry registry = registryService.getConfigSystemRegistry(tenantId);
            if (swaggerJsonString != null) {
                Resource resource = registry.newResource();
                resource.setContent((Object)swaggerJsonString);
                resource.setMediaType(APPLICATION_JSON_TYPE);
                registry.put(resourcePath, resource);
            }
        }
        catch (RegistryException e) {
            this.handleException(log, "Could not add swagger document", (Exception)((Object)e));
        }
    }

    public void updateSwaggerDocument(String apiName, String swaggerJsonString, int tenantId) throws APIException {
        API api = this.getSynapseAPIByName(apiName);
        if (api == null) {
            throw new APIException("API with name \"" + apiName + "\" does not exists.");
        }
        String resourcePath = this.getSwaggerResourcePath(api);
        RegistryService registryService = RegistryServiceHolder.getInstance().getRegistryService();
        try {
            Resource resource;
            UserRegistry registry = registryService.getConfigSystemRegistry(tenantId);
            if (resourcePath.startsWith(CONFIG_REG_PREFIX)) {
                resourcePath = resourcePath.substring(5);
                registry = registryService.getConfigSystemRegistry(tenantId);
            } else if (resourcePath.startsWith(GOV_REG_PREFIX)) {
                resourcePath = resourcePath.substring(4);
                registry = registryService.getGovernanceSystemRegistry(tenantId);
            } else {
                throw new APIException("Unable to update other sources. Only capable of updating swagger definitions resides in configuration or governance registry");
            }
            if (!registry.resourceExists(resourcePath)) {
                resource = registry.newResource();
                resource.setContent((Object)swaggerJsonString);
                resource.setMediaType(APPLICATION_JSON_TYPE);
            } else {
                resource = registry.get(resourcePath);
                resource.setContent((Object)swaggerJsonString);
            }
            registry.put(resourcePath, resource);
        }
        catch (RegistryException e) {
            this.handleException(log, "Could not update swagger document", (Exception)((Object)e));
        }
    }

    public String getSwaggerDocument(String apiName, int tenantId) throws APIException {
        API api = this.getSynapseAPIByName(apiName);
        if (api == null) {
            throw new APIException("API with name \"" + apiName + "\" does not exists.");
        }
        String resourcePath = this.getSwaggerResourcePath(api);
        String swaggerJsonString = null;
        if (resourcePath.startsWith(CONFIG_REG_PREFIX) || resourcePath.startsWith(GOV_REG_PREFIX)) {
            try {
                swaggerJsonString = this.getResourceFromRegistry(resourcePath, tenantId);
            }
            catch (RegistryException e) {
                this.handleException(log, "Could not get swagger document", (Exception)((Object)e));
            }
        } else {
            try {
                swaggerJsonString = this.readFromURI(resourcePath);
            }
            catch (IOException e) {
                log.error((Object)("Error occurred while reading swagger definition from: " + resourcePath), (Throwable)e);
            }
        }
        if (swaggerJsonString == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generate swagger definition for the API : " + apiName));
            }
            swaggerJsonString = this.generateSwaggerFromSynapseAPI(api);
        }
        return swaggerJsonString;
    }

    public String generateSwaggerFromSynapseAPIByFormat(API api, boolean isJSON) throws APIException {
        String swaggerJsonString = "";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate swagger definition for the API : " + api.getAPIName()));
        }
        try {
            return new OpenAPIProcessor(api).getOpenAPISpecification(isJSON);
        }
        catch (AxisFault axisFault) {
            this.handleException(log, "Error occurred while generating swagger definition", (Exception)((Object)axisFault));
            return swaggerJsonString;
        }
    }

    public String generateSwaggerFromSynapseAPI(API api) throws APIException {
        return this.generateSwaggerFromSynapseAPIByFormat(api, true);
    }

    public String generateAPIFromSwagger(String swaggerJsonString) throws APIException {
        return this.generateAPIFromSwaggerByFormat(swaggerJsonString, true);
    }

    public String generateAPIFromSwaggerByFormat(String swaggerString, boolean isJSON) throws APIException {
        JsonParser jsonParser;
        JsonElement swaggerJson;
        if (swaggerString == null || swaggerString.isEmpty()) {
            this.handleException(log, "Swagger provided is empty, hence unable to generate API", null);
        }
        if (!isJSON) {
            try {
                swaggerString = GenericApiObjectDefinition.convertYamlToJson((String)swaggerString);
            }
            catch (JsonProcessingException e) {
                this.handleException(log, "Error occurred while converting the provided YAML to JSON", null);
            }
        }
        if ((swaggerJson = (jsonParser = new JsonParser()).parse(swaggerString)).isJsonObject()) {
            APIGenerator apiGenerator = new APIGenerator(swaggerJson.getAsJsonObject());
            try {
                API api = apiGenerator.generateSynapseAPI();
                return APISerializer.serializeAPI((API)api).toString();
            }
            catch (APIGenException e) {
                this.handleException(log, "Error occurred while generating API", (Exception)((Object)e));
            }
        } else {
            this.handleException(log, "Error in swagger definition format: should be a json object", null);
        }
        return "";
    }

    public String generateUpdatedAPIFromSwagger(String swaggerJsonString, String existingApiName) throws APIException {
        JsonParser jsonParser;
        JsonElement swaggerJson;
        if (swaggerJsonString == null || swaggerJsonString.isEmpty()) {
            this.handleException(log, "Provided swagger definition is empty, hence unable to generate API", null);
        }
        if (existingApiName == null || existingApiName.isEmpty()) {
            this.handleException(log, "Provided existing API name is empty, hence unable to generate API", null);
        }
        if ((swaggerJson = (jsonParser = new JsonParser()).parse(swaggerJsonString)).isJsonObject()) {
            APIGenerator apiGenerator = new APIGenerator(swaggerJson.getAsJsonObject());
            try {
                API api = apiGenerator.generateUpdatedSynapseAPI(this.getSynapseAPIByName(existingApiName));
                return APISerializer.serializeAPI((API)api).toString();
            }
            catch (APIGenException e) {
                this.handleException(log, "Error occurred while generating API", (Exception)((Object)e));
            }
        } else {
            this.handleException(log, "Error in swagger definition format: should be a json object", null);
        }
        return "";
    }

    public String generateUpdatedAPIFromSwaggerByFormat(String swaggerJsonString, boolean isJSON, API existingApi) throws APIException {
        JsonParser jsonParser;
        JsonElement swaggerJson;
        if (swaggerJsonString == null || swaggerJsonString.isEmpty()) {
            this.handleException(log, "Provided swagger definition is empty, hence unable to generate API", null);
        }
        if (existingApi == null) {
            this.handleException(log, "Provided existing API name is empty, hence unable to generate API", null);
        }
        if (!isJSON) {
            try {
                swaggerJsonString = GenericApiObjectDefinition.convertYamlToJson((String)swaggerJsonString);
            }
            catch (JsonProcessingException e) {
                this.handleException(log, "Error occurred while converting the provided YAML to JSON", null);
            }
        }
        if ((swaggerJson = (jsonParser = new JsonParser()).parse(swaggerJsonString)).isJsonObject()) {
            APIGenerator apiGenerator = new APIGenerator(swaggerJson.getAsJsonObject());
            try {
                API api = apiGenerator.generateUpdatedSynapseAPI(existingApi);
                return APISerializer.serializeAPI((API)api).toString();
            }
            catch (APIGenException e) {
                this.handleException(log, "Error occurred while generating API", (Exception)((Object)e));
            }
        } else {
            this.handleException(log, "Error in swagger definition format: should be a json object", null);
        }
        return "";
    }

    public String generateUpdatedAPIFromSwaggerForAPI(String swaggerJsonString, API existingApi) throws APIException {
        return this.generateUpdatedAPIFromSwaggerByFormat(swaggerJsonString, true, existingApi);
    }

    private String getResourceFromRegistry(String resourcePath, int tenantId) throws RegistryException {
        UserRegistry registry;
        String swaggerJsonString = null;
        RegistryService registryService = RegistryServiceHolder.getInstance().getRegistryService();
        if (resourcePath.startsWith(CONFIG_REG_PREFIX)) {
            resourcePath = resourcePath.substring(5);
            registry = registryService.getConfigSystemRegistry(tenantId);
        } else {
            resourcePath = resourcePath.substring(4);
            registry = registryService.getGovernanceSystemRegistry(tenantId);
        }
        if (registry.resourceExists(resourcePath)) {
            Resource resource = registry.get(resourcePath);
            if (resource.getContent() != null && resource.getContent() instanceof byte[] && ((byte[])resource.getContent()).length > 0) {
                swaggerJsonString = new String((byte[])resource.getContent(), Charset.defaultCharset());
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No resource found in the path " + resourcePath));
        }
        return swaggerJsonString;
    }

    private String getSwaggerResourcePath(API api) {
        String resourcePath = api.getSwaggerResourcePath() != null && !api.getSwaggerResourcePath().isEmpty() ? api.getSwaggerResourcePath() : CONFIG_REG_PREFIX + SwaggerConstants.DEFAULT_SWAGGER_REGISTRY_PATH + api.getName() + "/swagger.json";
        return resourcePath;
    }

    private String readFromURI(String resourcePath) throws IOException {
        URL url = new URL(resourcePath);
        if ("file".equals(url.getProtocol())) {
            url = new URL(url.getProtocol() + ":" + CarbonUtils.getCarbonHome() + url.getPath());
            try {
                url.openStream();
            }
            catch (IOException e) {
                log.error((Object)("Error occurred while accessing file resource: " + url), (Throwable)e);
                return null;
            }
        }
        URLConnection urlConnection = url.openConnection();
        urlConnection.connect();
        try (InputStream inputStream = urlConnection.getInputStream();){
            if (inputStream == null) {
                String string = null;
                return string;
            }
            StringBuilder strBuilder = new StringBuilder();
            try (BufferedReader bReader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = bReader.readLine()) != null) {
                    strBuilder.append(line);
                }
            }
            String string = strBuilder.toString();
            return string;
        }
    }

    public String generateUpdatedSwaggerFromAPI(String existingSwagger, boolean isJSONIn, boolean isJSONOut, API api) throws APIGenException {
        OpenAPIProcessor openAPIProcessor = new OpenAPIProcessor(api);
        return openAPIProcessor.getUpdatedSwaggerFromApi(existingSwagger, isJSONIn, isJSONOut);
    }

    public String updateNameInSwagger(String newName, String swagger) throws APIException {
        JsonParser parser = new JsonParser();
        try {
            JsonElement jsonElement = parser.parse(swagger);
            Boolean openApi = jsonElement.getAsJsonObject().has("openapi");
            if (openApi.booleanValue()) {
                JsonObject infoObject = jsonElement.getAsJsonObject().get("info").getAsJsonObject();
                infoObject.remove(TITLE);
                infoObject.add(TITLE, (JsonElement)new JsonPrimitive(newName));
                return jsonElement.toString();
            }
            this.handleException(log, "Provided swagger is not OpenApi 3.0", null);
        }
        catch (JsonSyntaxException ex) {
            Yaml yaml = new Yaml();
            Map obj = (Map)yaml.load(swagger);
            Map infoMap = (Map)obj.get("info");
            infoMap.remove(TITLE);
            infoMap.put(TITLE, newName);
            DumperOptions options = new DumperOptions();
            options.setIndent(2);
            options.setPrettyFlow(true);
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml output = new Yaml(options);
            return output.dump((Object)obj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement getAPIContent(String apiName, String tenantDomain) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            API api = this.getSynapseAPIByName(apiName);
            if (api != null) {
                OMElement oMElement = APISerializer.serializeAPI((API)api);
                return oMElement;
            }
            OMElement oMElement = null;
            return oMElement;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

