/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rest.api;

import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.api.API;
import org.apache.synapse.api.Resource;
import org.apache.synapse.api.dispatch.DispatcherHelper;
import org.apache.synapse.api.dispatch.URITemplateHelper;
import org.apache.synapse.api.dispatch.URLMappingHelper;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.rest.api.APIData;
import org.wso2.carbon.rest.api.APIException;
import org.wso2.carbon.rest.api.ConfigHolder;
import org.wso2.carbon.rest.api.ResourceData;

public class RestApiAdminUtils {
    private static String PROTOCOL_HTTP = "http";
    private static String PROTOCOL_HTTPS = "https";

    public static OMElement retrieveAPIOMElement(APIData apiData) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace syn = SynapseConstants.SYNAPSE_OMNAMESPACE;
        OMNamespace nullNS = fac.createOMNamespace("", "");
        OMElement api = fac.createOMElement("api", syn);
        api.addAttribute("name", apiData.getName(), nullNS);
        if (apiData.getContext() != null) {
            api.addAttribute("context", apiData.getContext(), nullNS);
        }
        if (apiData.getHost() != null) {
            api.addAttribute("hostname", apiData.getHost(), nullNS);
        }
        if (apiData.getPort() != -1) {
            api.addAttribute("port", String.valueOf(apiData.getPort()), nullNS);
        }
        if (apiData.getVersion() != null) {
            api.addAttribute("version", String.valueOf(apiData.getVersion()), nullNS);
        }
        if (apiData.getVersionType() != null) {
            api.addAttribute("version-type", String.valueOf(apiData.getVersionType()), nullNS);
        }
        if (apiData.getSwaggerDefKey() != null) {
            api.addAttribute("publishSwagger", apiData.getSwaggerDefKey(), nullNS);
        }
        if (apiData.getResources() != null && apiData.getResources().length != 0) {
            for (ResourceData resourceData : apiData.getResources()) {
                api.addChild((OMNode)RestApiAdminUtils.retrieveResourceOMElement(resourceData));
            }
        }
        return api;
    }

    public static OMElement retrieveResourceOMElement(ResourceData resourceData) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace syn = SynapseConstants.SYNAPSE_OMNAMESPACE;
        OMNamespace nullNS = fac.createOMNamespace("", "");
        OMElement resource = fac.createOMElement("resource", syn);
        if (resourceData.getMethods() != null && resourceData.getMethods().length != 0) {
            String methodsString = RestApiAdminUtils.createSSString(resourceData.getMethods());
            resource.addAttribute("methods", methodsString, nullNS);
        }
        if (resourceData.getUriTemplate() != null) {
            resource.addAttribute("uri-template", resourceData.getUriTemplate(), nullNS);
        } else if (resourceData.getUrlMapping() != null) {
            resource.addAttribute("url-mapping", resourceData.getUrlMapping(), nullNS);
        }
        if (resourceData.getContentType() != null) {
            resource.addAttribute("contentType", resourceData.getContentType(), nullNS);
        }
        if (resourceData.getUserAgent() != null) {
            resource.addAttribute("userAgent", resourceData.getUserAgent(), nullNS);
        }
        if (resourceData.getProtocol() != 0) {
            if (resourceData.getProtocol() == 1) {
                resource.addAttribute("protocol", PROTOCOL_HTTP, nullNS);
            } else if (resourceData.getProtocol() == 2) {
                resource.addAttribute("protocol", PROTOCOL_HTTPS, nullNS);
            } else {
                resource.addAttribute("protocol", String.valueOf(resourceData.getProtocol()), nullNS);
            }
        }
        try {
            if (resourceData.getInSequenceKey() != null) {
                resource.addAttribute("inSequence", resourceData.getInSequenceKey(), nullNS);
            } else if (resourceData.getInSeqXml() != null && !resourceData.getInSeqXml().isEmpty()) {
                resource.addChild((OMNode)AXIOMUtil.stringToOM((String)resourceData.getInSeqXml()));
            }
            if (resourceData.getOutSequenceKey() != null) {
                resource.addAttribute("outSequence", resourceData.getOutSequenceKey(), nullNS);
            } else if (resourceData.getOutSeqXml() != null && !resourceData.getOutSeqXml().isEmpty()) {
                resource.addChild((OMNode)AXIOMUtil.stringToOM((String)resourceData.getOutSeqXml()));
            }
            if (resourceData.getFaultSequenceKey() != null) {
                resource.addAttribute("faultSequence", resourceData.getFaultSequenceKey(), nullNS);
            } else if (resourceData.getFaultSeqXml() != null && !resourceData.getFaultSeqXml().isEmpty()) {
                resource.addChild((OMNode)AXIOMUtil.stringToOM((String)resourceData.getFaultSeqXml()));
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return null;
        }
        return resource;
    }

    private static String createSSString(String[] lst) {
        String str = "";
        for (String item : lst) {
            str = str + item + " ";
        }
        return str.substring(0, str.length() - 1);
    }

    public static OMElement createAnonymousSequenceElement(SequenceMediator sequenceMediator, String seqElemName) {
        SequenceMediatorSerializer serializer = new SequenceMediatorSerializer();
        OMElement sequenceElem = serializer.serializeAnonymousSequence(null, sequenceMediator);
        if (!("inSequence".equals(seqElemName) || "outSequence".equals(seqElemName) || "faultSequence".equals(seqElemName))) {
            return null;
        }
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace syn = SynapseConstants.SYNAPSE_OMNAMESPACE;
        OMNamespace nullNS = fac.createOMNamespace("", "");
        OMElement seq = fac.createOMElement(seqElemName, syn);
        Iterator attributes = sequenceElem.getAllAttributes();
        while (attributes.hasNext()) {
            OMAttribute attrb = (OMAttribute)attributes.next();
            seq.addAttribute(attrb.getLocalName(), attrb.getAttributeValue(), nullNS);
        }
        Iterator children = sequenceElem.getChildElements();
        while (children.hasNext()) {
            OMElement child = (OMElement)children.next();
            seq.addChild((OMNode)child);
        }
        return seq;
    }

    public static SynapseConfiguration getSynapseConfiguration() throws APIException {
        return (SynapseConfiguration)ConfigHolder.getInstance().getAxisConfiguration().getParameter("synapse.config").getValue();
    }

    public static MediationPersistenceManager getMediationPersistenceManager() throws APIException {
        return ServiceBusUtils.getMediationPersistenceManager((AxisConfiguration)ConfigHolder.getInstance().getAxisConfiguration());
    }

    public static SynapseEnvironment getSynapseEnvironment() throws APIException {
        return RestApiAdminUtils.getSynapseEnvironment(ConfigHolder.getInstance().getAxisConfiguration());
    }

    public static SynapseEnvironment getSynapseEnvironment(AxisConfiguration axisCfg) {
        return (SynapseEnvironment)axisCfg.getParameter("synapse.env").getValue();
    }

    public static APIData convertApiToAPIData(API api) {
        if (api == null) {
            return null;
        }
        APIData apiData = new APIData();
        apiData.setName(api.getName());
        apiData.setContext(api.getContext());
        apiData.setHost(api.getHost());
        apiData.setPort(api.getPort());
        apiData.setFileName(api.getFileName());
        apiData.setVersion(api.getVersion());
        apiData.setVersionType(api.getVersionStrategy().getVersionType());
        Resource[] resources = api.getResources();
        ResourceData[] resourceDatas = new ResourceData[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            Resource resource = resources[i];
            ResourceData data = new ResourceData();
            String[] methods = resource.getMethods();
            data.setMethods(methods);
            data.setContentType(resource.getContentType());
            data.setProtocol(resource.getProtocol());
            DispatcherHelper dispatcherHelper = resource.getDispatcherHelper();
            if (dispatcherHelper instanceof URITemplateHelper) {
                data.setUriTemplate(dispatcherHelper.getString());
            } else if (dispatcherHelper instanceof URLMappingHelper) {
                data.setUrlMapping(dispatcherHelper.getString());
            }
            if (resource.getInSequenceKey() != null) {
                data.setInSequenceKey(resource.getInSequenceKey());
            } else if (resource.getInSequence() != null) {
                data.setInSeqXml(RestApiAdminUtils.createAnonymousSequenceElement(resource.getInSequence(), "inSequence").toString());
            }
            if (resource.getOutSequenceKey() != null) {
                data.setOutSequenceKey(resource.getOutSequenceKey());
            } else if (resource.getOutSequence() != null) {
                data.setOutSeqXml(RestApiAdminUtils.createAnonymousSequenceElement(resource.getOutSequence(), "outSequence").toString());
            }
            if (resource.getFaultSequenceKey() != null) {
                data.setFaultSequenceKey(resource.getFaultSequenceKey());
            } else if (resource.getFaultSequence() != null) {
                data.setFaultSeqXml(RestApiAdminUtils.createAnonymousSequenceElement(resource.getFaultSequence(), "faultSequence").toString());
            }
            data.setUserAgent(resource.getUserAgent());
            resourceDatas[i] = data;
        }
        apiData.setResources(resourceDatas);
        return apiData;
    }

    public static void persistApi(API api) throws APIException {
        MediationPersistenceManager pm;
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && (pm = RestApiAdminUtils.getMediationPersistenceManager()) != null) {
            pm.saveItem(api.getName(), 13);
        }
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

