/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rest.api;

import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.api.API;
import org.wso2.carbon.mediation.commons.rest.api.swagger.ServerConfig;
import org.wso2.carbon.mediation.commons.rest.api.swagger.SwaggerConstants;
import org.wso2.carbon.rest.api.APIException;
import org.wso2.carbon.rest.api.ConfigHolder;
import org.wso2.carbon.utils.NetworkUtils;

public class CarbonServerConfig
implements ServerConfig {
    private static final Log log = LogFactory.getLog(CarbonServerConfig.class);
    private AxisConfiguration axisConfiguration = ConfigHolder.getInstance().getAxisConfiguration();

    public String getHost(API api) throws AxisFault {
        if (api.getHost() != null) {
            return api.getHost();
        }
        TransportInDescription transportIn = this.axisConfiguration.getTransportIn(api.getProtocol() == 1 ? "http" : "https");
        if (transportIn != null) {
            if (transportIn.getParameter(SwaggerConstants.WSDL_EPR_PREFIX) != null) {
                String wsdlPrefixParam = (String)transportIn.getParameter(SwaggerConstants.WSDL_EPR_PREFIX).getValue();
                if (!wsdlPrefixParam.isEmpty()) {
                    try {
                        URI hostUri = new URI(wsdlPrefixParam);
                        try {
                            String protocol = transportIn.getName();
                            if ("https".equals(protocol) && hostUri.getPort() == 443 || "http".equals(protocol) && hostUri.getPort() == 80) {
                                return hostUri.getHost();
                            }
                        }
                        catch (NumberFormatException e) {
                            throw new AxisFault("Error occurred while parsing the port", (Throwable)e);
                        }
                        return hostUri.getHost() + ":" + hostUri.getPort();
                    }
                    catch (URISyntaxException e) {
                        log.error((Object)"WSDLEPRPrefix is not a valid URI", (Throwable)e);
                    }
                } else {
                    log.error((Object)"\"WSDLEPRPrefix\" is empty. Please provide relevant URI or comment out parameter");
                }
            }
            String portStr = (String)transportIn.getParameter("port").getValue();
            String hostname = "localhost";
            if (this.axisConfiguration.getParameter("hostname") != null) {
                hostname = (String)this.axisConfiguration.getParameter("hostname").getValue();
            } else {
                try {
                    hostname = NetworkUtils.getLocalHostname();
                }
                catch (SocketException e) {
                    log.warn((Object)"SocketException occurred when trying to obtain IP address of local machine");
                }
            }
            return hostname + ':' + portStr;
        }
        throw new AxisFault("http/https transport listeners are required in axis2.xml");
    }

    public String getHost(String transport) throws AxisFault {
        return null;
    }
}

