/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.common.builders;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import javax.crypto.SecretKey;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialContextSet;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.util.KeyStoreManager;

public class SignKeyDataHolder
implements X509Credential {
    private String signatureAlgorithm = null;
    private X509Certificate[] issuerCerts = null;
    private PrivateKey issuerPK = null;

    public SignKeyDataHolder() throws Exception {
        try {
            String keyAlias = ServerConfiguration.getInstance().getFirstProperty("Security.KeyStore.KeyAlias");
            KeyStoreManager keyMan = KeyStoreManager.getInstance((int)-1234);
            Certificate[] certificates = keyMan.getPrimaryKeyStore().getCertificateChain(keyAlias);
            this.issuerPK = keyMan.getDefaultPrivateKey();
            this.issuerCerts = new X509Certificate[certificates.length];
            int i = 0;
            for (Certificate certificate : certificates) {
                this.issuerCerts[i++] = (X509Certificate)certificate;
            }
            this.signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            String pubKeyAlgo = this.issuerCerts[0].getPublicKey().getAlgorithm();
            if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                this.signatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
        }
        catch (Exception e) {
            throw new Exception("Error while reading the key", e);
        }
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public Collection<X509CRL> getCRLs() {
        return null;
    }

    public X509Certificate getEntityCertificate() {
        return this.issuerCerts[0];
    }

    public Collection<X509Certificate> getEntityCertificateChain() {
        return Arrays.asList(this.issuerCerts);
    }

    public CredentialContextSet getCredentialContextSet() {
        return null;
    }

    public Class<? extends Credential> getCredentialType() {
        return null;
    }

    public String getEntityId() {
        return null;
    }

    public Collection<String> getKeyNames() {
        return null;
    }

    public PrivateKey getPrivateKey() {
        return this.issuerPK;
    }

    public PublicKey getPublicKey() {
        return this.issuerCerts[0].getPublicKey();
    }

    public SecretKey getSecretKey() {
        return null;
    }

    public UsageType getUsageType() {
        return null;
    }
}

