/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.common.builders;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.SessionIndexBuilder;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.Util;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.builders.SignKeyDataHolder;

public class LogoutRequestBuilder {
    private static final Log log = LogFactory.getLog(LogoutRequestBuilder.class);

    public LogoutRequest buildLogoutRequest(String subject, String reason, String sessionIndexStr) throws Exception {
        log.info((Object)"Building logout request");
        Util.doBootstrap();
        LogoutRequest logoutReq = new org.opensaml.saml.saml2.core.impl.LogoutRequestBuilder().buildObject();
        logoutReq.setID(Util.createID());
        String destination = Util.getIdentityProviderSLOServiceURL();
        if (StringUtils.isEmpty((String)destination)) {
            destination = Util.getIdentityProviderSSOServiceURL();
        }
        logoutReq.setDestination(destination);
        DateTime issueInstant = new DateTime();
        logoutReq.setIssueInstant(issueInstant);
        logoutReq.setNotOnOrAfter(new DateTime(issueInstant.getMillis() + 300000L));
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(Util.getServiceProviderId());
        logoutReq.setIssuer(issuer);
        NameID nameId = new NameIDBuilder().buildObject();
        nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        nameId.setValue(subject);
        logoutReq.setNameID(nameId);
        SessionIndex sessionIndex = new SessionIndexBuilder().buildObject();
        sessionIndex.setSessionIndex(sessionIndexStr);
        logoutReq.getSessionIndexes().add(sessionIndex);
        logoutReq.setReason(reason);
        Util.setSignature(logoutReq, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", new SignKeyDataHolder());
        return logoutReq;
    }
}

