/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.common.builders;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.SubjectBuilder;
import org.opensaml.security.x509.X509Credential;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.Util;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.builders.SignKeyDataHolder;
import org.wso2.carbon.ui.CarbonUIUtil;

public class AuthenticationRequestBuilder {
    private static final Log log = LogFactory.getLog(AuthenticationRequestBuilder.class);

    private static Issuer buildIssuer() {
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(Util.getServiceProviderId());
        return issuer;
    }

    private static NameIDPolicy buildNameIDPolicy(String nameIdPolicyFormat) {
        NameIDPolicy nameIDPolicy = new NameIDPolicyBuilder().buildObject();
        if (nameIdPolicyFormat == null) {
            nameIdPolicyFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        }
        nameIDPolicy.setFormat(nameIdPolicyFormat);
        nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
        return nameIDPolicy;
    }

    public AuthnRequest buildAuthenticationRequest(String subjectName, String nameIdPolicyFormat) throws Exception {
        return this.buildAuthenticationRequest(subjectName, nameIdPolicyFormat, false);
    }

    public AuthnRequest buildAuthenticationRequest(String subjectName, String nameIdPolicyFormat, boolean isPassive) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Building Authentication Request");
        }
        Util.doBootstrap();
        AuthnRequest authnRequest = (AuthnRequest)Util.buildXMLObject(AuthnRequest.DEFAULT_ELEMENT_NAME);
        authnRequest.setID(Util.createID());
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setIssuer(AuthenticationRequestBuilder.buildIssuer());
        authnRequest.setNameIDPolicy(AuthenticationRequestBuilder.buildNameIDPolicy(nameIdPolicyFormat));
        authnRequest.setIsPassive(Boolean.valueOf(isPassive));
        authnRequest.setDestination(Util.getIdentityProviderSSOServiceURL());
        String acs = Util.getAssertionConsumerServiceURL();
        if (acs != null && acs.trim().length() > 0) {
            authnRequest.setAssertionConsumerServiceURL(acs);
        } else {
            authnRequest.setAssertionConsumerServiceURL(CarbonUIUtil.getAdminConsoleURL((String)"").replace("carbon/", "acs"));
        }
        if (subjectName != null) {
            Subject subject = new SubjectBuilder().buildObject();
            NameID nameId = new NameIDBuilder().buildObject();
            nameId.setValue(subjectName);
            nameId.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            subject.setNameID(nameId);
            authnRequest.setSubject(subject);
        }
        Util.setSignature(authnRequest, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", (X509Credential)new SignKeyDataHolder());
        return authnRequest;
    }
}

