/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.SAML2SSOUIAuthenticatorException;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.X509CredentialImpl;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.builders.SignKeyDataHolder;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.internal.SAML2SSOAuthFEDataHolder;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.util.CarbonEntityResolver;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.saml.common.util.SAMLInitializer;
import org.xml.sax.SAXException;

public class Util {
    private static final char[] charMapping = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
    private static boolean bootStrapped = false;
    private static final Log log = LogFactory.getLog(Util.class);
    private static Random random = new Random();
    private static String serviceProviderId = null;
    private static String identityProviderSSOServiceURL = null;
    private static Map<String, String> parameters = new HashMap<String, String>();
    private static String identityProviderSLOServiceURL = parameters.get("IdentityProviderSLOServiceURL");
    private static String loginPage = "/carbon/admin/login.jsp";
    private static String landingPage = null;
    private static String externalLogoutPage = null;
    private static boolean logoutSupportedIDP = false;
    private static String assertionConsumerServiceUrl = null;
    private static boolean initSuccess = false;
    private static Properties saml2IdpProperties = new Properties();
    private static Map<String, String> cachedIdps = new ConcurrentHashMap<String, String>();

    private Util() {
    }

    public static XMLObject unmarshall(String authReqStr) throws SAML2SSOUIAuthenticatorException {
        try {
            Util.doBootstrap();
            DocumentBuilderFactory documentBuilderFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
            Document document = Util.getDocument(documentBuilderFactory, authReqStr);
            if (Util.isSignedWithComments(document)) {
                documentBuilderFactory.setIgnoringComments(false);
                document = Util.getDocument(documentBuilderFactory, authReqStr);
            }
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            return unmarshaller.unmarshall(element);
        }
        catch (Exception e) {
            log.error((Object)"Error in constructing AuthRequest from the encoded String", (Throwable)e);
            throw new SAML2SSOUIAuthenticatorException("Error in constructing AuthRequest from the encoded String ", e);
        }
    }

    private static boolean isSignedWithComments(Document document) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            String assertionId = (String)xPath.compile("//*[local-name()='Assertion']/@ID").evaluate(document, XPathConstants.STRING);
            if (StringUtils.isBlank((String)assertionId)) {
                return false;
            }
            NodeList nodeList = (NodeList)xPath.compile("//*[local-name()='Assertion']/*[local-name()='Signature']/*[local-name()='SignedInfo']/*[local-name()='Reference'][@URI='#" + assertionId + "']/*[local-name()='Transforms']/*[local-name()='Transform'][@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#WithComments']").evaluate(document, XPathConstants.NODESET);
            return nodeList != null && nodeList.getLength() > 0;
        }
        catch (XPathExpressionException e) {
            String message = "Failed to find the canonicalization algorithm of the assertion. Defaulting to: http://www.w3.org/2001/10/xml-exc-c14n#";
            log.warn((Object)message);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            return false;
        }
    }

    private static Document getDocument(DocumentBuilderFactory documentBuilderFactory, String samlString) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        docBuilder.setEntityResolver(new CarbonEntityResolver());
        return docBuilder.parse(new ByteArrayInputStream(samlString.trim().getBytes()));
    }

    public static String marshall(XMLObject xmlObject) throws SAML2SSOUIAuthenticatorException {
        try {
            Util.doBootstrap();
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            Element element = marshaller.marshall(xmlObject);
            ByteArrayOutputStream byteArrayOutputStrm = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(byteArrayOutputStrm);
            writer.write(element, output);
            return byteArrayOutputStrm.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error Serializing the SAML Response");
            throw new SAML2SSOUIAuthenticatorException("Error Serializing the SAML Response", e);
        }
    }

    public static String encode(String xmlString) throws Exception {
        String encodedRequestMessage = Base64Support.encode((byte[])xmlString.getBytes(), (boolean)false);
        return encodedRequestMessage.trim();
    }

    public static String decode(String encodedStr) throws SAML2SSOUIAuthenticatorException {
        try {
            Base64 base64Decoder = new Base64();
            byte[] xmlBytes = encodedStr.getBytes("UTF-8");
            byte[] base64DecodedByteArray = base64Decoder.decode(xmlBytes);
            return new String(base64DecodedByteArray, 0, base64DecodedByteArray.length, "UTF-8");
        }
        catch (IOException e) {
            throw new SAML2SSOUIAuthenticatorException("Error when decoding the SAML Request.", e);
        }
    }

    public static void doBootstrap() {
        if (!bootStrapped) {
            try {
                SAMLInitializer.doBootstrap();
                bootStrapped = true;
            }
            catch (InitializationException e) {
                log.error((Object)"Error in bootstrapping the OpenSAML3 library", (Throwable)e);
            }
        }
    }

    public static AuthnRequest setSignature(AuthnRequest authnRequest, String signatureAlgorithm, X509Credential cred) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Signing the AuthnRequest");
        }
        Util.doBootstrap();
        try {
            Signature signature = (Signature)Util.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential((Credential)cred);
            signature.setSignatureAlgorithm(signatureAlgorithm);
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            try {
                KeyInfo keyInfo = (KeyInfo)Util.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
                X509Data data = (X509Data)Util.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
                X509Certificate cert = (X509Certificate)Util.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
                String value = org.apache.xml.security.utils.Base64.encode((byte[])cred.getEntityCertificate().getEncoded());
                cert.setValue(value);
                data.getX509Certificates().add(cert);
                keyInfo.getX509Datas().add(data);
                signature.setKeyInfo(keyInfo);
            }
            catch (CertificateEncodingException e) {
                throw new SAML2SSOUIAuthenticatorException("errorGettingCert ", e);
            }
            authnRequest.setSignature(signature);
            ArrayList<Signature> signatureList = new ArrayList<Signature>();
            signatureList.add(signature);
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)authnRequest);
            marshaller.marshall((XMLObject)authnRequest);
            Init.init();
            Signer.signObjects(signatureList);
            return authnRequest;
        }
        catch (Exception e) {
            throw new Exception("Error While signing the assertion.", e);
        }
    }

    public static LogoutRequest setSignature(LogoutRequest logoutReq, String signatureAlgorithm, SignKeyDataHolder cred) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Signing the AuthnRequest");
        }
        Util.doBootstrap();
        try {
            Signature signature = (Signature)Util.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential((Credential)cred);
            signature.setSignatureAlgorithm(signatureAlgorithm);
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            try {
                KeyInfo keyInfo = (KeyInfo)Util.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
                X509Data data = (X509Data)Util.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
                X509Certificate cert = (X509Certificate)Util.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
                String value = org.apache.xml.security.utils.Base64.encode((byte[])cred.getEntityCertificate().getEncoded());
                cert.setValue(value);
                data.getX509Certificates().add(cert);
                keyInfo.getX509Datas().add(data);
                signature.setKeyInfo(keyInfo);
            }
            catch (CertificateEncodingException e) {
                throw new Exception("errorGettingCert ", e);
            }
            logoutReq.setSignature(signature);
            ArrayList<Signature> signatureList = new ArrayList<Signature>();
            signatureList.add(signature);
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)logoutReq);
            marshaller.marshall((XMLObject)logoutReq);
            Init.init();
            Signer.signObjects(signatureList);
            return logoutReq;
        }
        catch (Exception e) {
            throw new Exception("Error While signing the assertion.", e);
        }
    }

    public static XMLObject buildXMLObject(QName objectQName) throws Exception {
        XMLObjectBuilder builder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            throw new Exception("Unable to retrieve builder for object QName " + objectQName);
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    public static String createID() {
        RandomIdentifierGenerationStrategy generator = new RandomIdentifierGenerationStrategy();
        return generator.generateIdentifier();
    }

    public static boolean initSSOConfigParams() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig("SAML2SSOAuthenticator");
        if (authenticatorConfig != null) {
            parameters = authenticatorConfig.getParameters();
            serviceProviderId = parameters.get("ServiceProviderID");
            identityProviderSSOServiceURL = parameters.get("IdentityProviderSSOServiceURL");
            identityProviderSLOServiceURL = parameters.get("IdentityProviderSLOServiceURL");
            loginPage = parameters.get("LoginPage");
            landingPage = parameters.get("LandingPage");
            externalLogoutPage = parameters.get("ExternalLogoutPage");
            logoutSupportedIDP = Boolean.parseBoolean(parameters.get("LogoutSupportedIDP"));
            assertionConsumerServiceUrl = parameters.get("AssertionConsumerServiceURL");
            initSuccess = true;
        }
        return initSuccess;
    }

    public static boolean isAuthenticatorEnabled() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig("SAML2SSOAuthenticator");
        return !authenticatorConfig.isDisabled();
    }

    public static String getServiceProviderId() {
        if (!initSuccess) {
            Util.initSSOConfigParams();
        }
        return serviceProviderId;
    }

    public static String getIdentityProviderSSOServiceURL() {
        if (!initSuccess) {
            Util.initSSOConfigParams();
        }
        return identityProviderSSOServiceURL;
    }

    public static String getIdentityProviderSLOServiceURL() {
        if (!initSuccess) {
            Util.initSSOConfigParams();
        }
        return identityProviderSLOServiceURL;
    }

    public static String getAssertionConsumerServiceURL() {
        if (!initSuccess) {
            Util.initSSOConfigParams();
        }
        return assertionConsumerServiceUrl;
    }

    public static String getIdentityProviderSSOServiceURL(String federatedDomain) {
        if (!initSuccess) {
            Util.initSSOConfigParams();
        }
        String fedeartedIdp = null;
        if (federatedDomain == null) {
            return null;
        }
        String selfDomain = parameters.get("IdpSelfDomain");
        federatedDomain = federatedDomain.trim().toUpperCase();
        if (selfDomain != null && selfDomain.trim().toUpperCase().equals(federatedDomain)) {
            return null;
        }
        fedeartedIdp = cachedIdps.get(federatedDomain);
        if (fedeartedIdp == null) {
            fedeartedIdp = saml2IdpProperties.getProperty(federatedDomain);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Federated domain : " + fedeartedIdp));
        }
        if (fedeartedIdp != null) {
            cachedIdps.put(federatedDomain, fedeartedIdp);
        }
        return fedeartedIdp;
    }

    public static String getLoginPage() {
        return loginPage;
    }

    public static String getLandingPage() {
        return landingPage;
    }

    public static String getExternalLogoutPage() {
        return externalLogoutPage;
    }

    public static boolean isLogoutSupportedIDP() {
        return logoutSupportedIDP;
    }

    public static String getLoginAttributeName() {
        if (!initSuccess) {
            Util.initSSOConfigParams();
        }
        return parameters.get("LoginAttributeName");
    }

    public static String getUsername(XMLObject xmlObject) {
        if (xmlObject instanceof Response) {
            return Util.getUsernameFromResponse((Response)xmlObject);
        }
        if (xmlObject instanceof Assertion) {
            return Util.getUsernameFromAssertion((Assertion)xmlObject);
        }
        return null;
    }

    public static String getUsernameFromResponse(Response response) {
        List assertions = response.getAssertions();
        Assertion assertion = null;
        if (assertions != null && assertions.size() > 0) {
            assertion = (Assertion)assertions.get(0);
            return Util.getUsernameFromAssertion(assertion);
        }
        List encryptedAssertions = response.getEncryptedAssertions();
        if (encryptedAssertions.size() > 0) {
            EncryptedAssertion encryptedAssertion = (EncryptedAssertion)encryptedAssertions.get(0);
            String tenantDomain = "carbon.super";
            try {
                assertion = Util.getDecryptedAssertion(encryptedAssertion, tenantDomain);
            }
            catch (SAML2SSOUIAuthenticatorException e) {
                log.error((Object)"Error while obtaining user name from response.");
            }
            return Util.getUsernameFromAssertion(assertion);
        }
        return null;
    }

    public static String getUsernameFromAssertion(Assertion assertion) {
        List attributeStatements;
        String loginAttributeName = Util.getLoginAttributeName();
        if (loginAttributeName != null && (attributeStatements = assertion.getAttributeStatements()) != null) {
            for (AttributeStatement attributeStatement : attributeStatements) {
                List attributes = attributeStatement.getAttributes();
                if (attributes == null) continue;
                for (Attribute attribute : attributes) {
                    String attributeName = attribute.getDOM().getAttribute("Name");
                    if (!attributeName.equals(loginAttributeName)) continue;
                    List attributeValues = attribute.getAttributeValues();
                    return ((XMLObject)attributeValues.get(0)).getDOM().getTextContent();
                }
            }
        }
        return assertion.getSubject().getNameID().getValue();
    }

    private static X509CredentialImpl getX509CredentialImplForTenant(String domainName) throws SAML2SSOUIAuthenticatorException {
        int tenantID = -1234;
        KeyStoreManager keyStoreManager = null;
        keyStoreManager = KeyStoreManager.getInstance((int)tenantID);
        X509CredentialImpl credentialImpl = null;
        String alias = SAML2SSOAuthFEDataHolder.getInstance().getIdPCertAlias();
        try {
            if (tenantID != -1234) {
                KeyStore keystore = keyStoreManager.getKeyStore(Util.generateKSNameFromDomainName(domainName));
                java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)keystore.getCertificate(domainName);
                String ksName = domainName.trim().replace(".", "-");
                String jksName = ksName + ".jks";
                Key privateKey = keyStoreManager.getPrivateKey(jksName, domainName);
                credentialImpl = new X509CredentialImpl(cert, privateKey);
            } else {
                PrivateKey privateKey = keyStoreManager.getDefaultPrivateKey();
                java.security.cert.X509Certificate cert = null;
                if (alias != null) {
                    cert = (java.security.cert.X509Certificate)keyStoreManager.getPrimaryKeyStore().getCertificate(alias);
                    if (cert == null) {
                        String errorMsg = "Cannot find a certificate with the alias " + alias + " in the default key store. Please check the 'IdPCertAlias' property in the SSO configuration of the authenticators.xml";
                        throw new SAML2SSOUIAuthenticatorException(errorMsg);
                    }
                } else {
                    cert = keyStoreManager.getDefaultPrimaryCertificate();
                }
                credentialImpl = new X509CredentialImpl(cert, privateKey);
            }
        }
        catch (SAML2SSOUIAuthenticatorException e) {
            String errorMsg = "Error instantiating an X509CredentialImpl object for the public cert.";
            throw new SAML2SSOUIAuthenticatorException(errorMsg, (Throwable)((Object)e));
        }
        catch (Exception e) {
            String errorMsg = "Error while loading the keystores.";
            throw new SAML2SSOUIAuthenticatorException(errorMsg, e);
        }
        return credentialImpl;
    }

    public static Assertion getDecryptedAssertion(EncryptedAssertion encryptedAssertion, String domainName) throws SAML2SSOUIAuthenticatorException {
        X509CredentialImpl credential = Util.getX509CredentialImplForTenant(domainName);
        try {
            StaticKeyInfoCredentialResolver keyResolver = new StaticKeyInfoCredentialResolver((Credential)credential);
            EncryptedKey key = (EncryptedKey)encryptedAssertion.getEncryptedData().getKeyInfo().getEncryptedKeys().get(0);
            Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)keyResolver, null);
            SecretKey dkey = (SecretKey)decrypter.decryptKey(key, encryptedAssertion.getEncryptedData().getEncryptionMethod().getAlgorithm());
            BasicCredential shared = CredentialSupport.getSimpleCredential((SecretKey)dkey);
            decrypter = new Decrypter((KeyInfoCredentialResolver)new StaticKeyInfoCredentialResolver((Credential)shared), null, null);
            decrypter.setRootInNewDocument(true);
            return decrypter.decrypt(encryptedAssertion);
        }
        catch (DecryptionException e) {
            throw new SAML2SSOUIAuthenticatorException("Error while decrypting the saml response.", e);
        }
    }

    private static String generateKSNameFromDomainName(String tenantDomain) {
        String ksName = tenantDomain.trim().replace(".", "-");
        return ksName + ".jks";
    }
}

