/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.jms.listener.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.KeyManagerConfiguration;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.jms.listener.internal.ServiceReferenceHolder;

public class KeyManagerJMSMessageListener
implements MessageListener {
    private static final Log log = LogFactory.getLog(KeyManagerJMSMessageListener.class);

    public void onMessage(Message message) {
        try {
            if (message != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event received in JMS Event Receiver - " + message));
                }
                Topic jmsDestination = (Topic)message.getJMSDestination();
                if (message instanceof TextMessage) {
                    String textMessage = ((TextMessage)message).getText();
                    JsonNode payloadData = new ObjectMapper().readTree(textMessage).path("event").path("payloadData");
                    if ("keyManager".equalsIgnoreCase(jmsDestination.getTopicName()) && "key_manager_configuration".equals(payloadData.get("event_type").asText())) {
                        String name = payloadData.get("name").asText();
                        String tenantDomain = payloadData.get("tenantDomain").asText();
                        String action = payloadData.get("action").asText();
                        String type = payloadData.get("type").asText();
                        boolean enabled = payloadData.get("enabled").asBoolean();
                        String value = payloadData.get("value").asText();
                        if (StringUtils.isNotEmpty((CharSequence)value)) {
                            KeyManagerConfiguration keyManagerConfiguration = APIUtil.toKeyManagerConfiguration((String)value);
                            keyManagerConfiguration.setEnabled(enabled);
                            if ("add".equals(action)) {
                                ServiceReferenceHolder.getInstance().getKeyManagerService().addKeyManagerConfiguration(tenantDomain, name, type, keyManagerConfiguration);
                            }
                            if ("update".equals(action)) {
                                ServiceReferenceHolder.getInstance().getKeyManagerService().updateKeyManagerConfiguration(tenantDomain, name, type, keyManagerConfiguration);
                            }
                        }
                        if ("delete".equals(action)) {
                            ServiceReferenceHolder.getInstance().getKeyManagerService().removeKeyManagerConfiguration(tenantDomain, name);
                        }
                    }
                } else {
                    log.warn((Object)("Event dropped due to unsupported message type " + message.getClass()));
                }
            } else {
                log.warn((Object)"Dropping the empty/null event received through jms receiver");
            }
        }
        catch (JsonProcessingException | JMSException e) {
            log.error((Object)"JMSException occurred when processing the received message ", e);
        }
        catch (APIManagementException e) {
            log.error((Object)"Error occurred while registering Key Manager", (Throwable)e);
        }
    }
}

