/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.jms.listener.utils;

import javax.jms.MessageListener;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.jms.JMSTransportHandler;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto;
import org.wso2.carbon.apimgt.jms.listener.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.jms.listener.utils.KeyManagerJMSMessageListener;
import org.wso2.carbon.core.ServerShutdownHandler;
import org.wso2.carbon.core.ServerStartupObserver;

public class JMSListenerStartupShutdownListener
implements ServerStartupObserver,
ServerShutdownHandler {
    private Log log = LogFactory.getLog(JMSListenerStartupShutdownListener.class);
    private JMSTransportHandler jmsTransportHandlerForEventHub;

    public JMSListenerStartupShutdownListener() {
        EventHubConfigurationDto.EventHubReceiverConfiguration eventHubReceiverConfiguration = ServiceReferenceHolder.getInstance().getAPIMConfiguration().getEventHubConfigurationDto().getEventHubReceiverConfiguration();
        if (eventHubReceiverConfiguration != null) {
            this.jmsTransportHandlerForEventHub = new JMSTransportHandler(eventHubReceiverConfiguration.getJmsConnectionParameters());
        }
    }

    public void completingServerStartup() {
    }

    public void completedServerStartup() {
        String enableKeyManagerRetrieval;
        APIManagerConfiguration apimConfiguration = ServiceReferenceHolder.getInstance().getAPIMConfiguration();
        if (apimConfiguration != null && JavaUtils.isTrueExplicitly((String)(enableKeyManagerRetrieval = apimConfiguration.getFirstProperty("APIKeyValidator.EnableKeyManagerConfigurationRetriever")))) {
            this.jmsTransportHandlerForEventHub.subscribeForJmsEvents("keyManager", (MessageListener)new KeyManagerJMSMessageListener());
        }
    }

    public void invoke() {
        if (this.jmsTransportHandlerForEventHub != null) {
            this.log.debug((Object)"Unsubscribe from JMS Events...");
            this.jmsTransportHandlerForEventHub.unSubscribeFromEvents();
        }
    }
}

