/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.jms.listener.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.APIManagerConfigurationService;
import org.wso2.carbon.apimgt.impl.keymgt.KeyManagerConfigurationService;
import org.wso2.carbon.apimgt.jms.listener.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.jms.listener.utils.JMSListenerStartupShutdownListener;
import org.wso2.carbon.core.ServerShutdownHandler;
import org.wso2.carbon.core.ServerStartupObserver;

@Component(name="org.wso2.apimgt.jms.listener", immediate=true)
public class JMSListenerComponent {
    private static final Log log = LogFactory.getLog(JMSListenerComponent.class);
    private ServiceRegistration registration;

    @Activate
    protected void activate(ComponentContext context) {
        log.debug((Object)"Activating component...");
        APIManagerConfiguration configuration = ServiceReferenceHolder.getInstance().getAPIMConfiguration();
        if (configuration == null) {
            log.warn((Object)"API Manager Configuration not properly set.");
            return;
        }
        JMSListenerStartupShutdownListener jmsListenerStartupShutdownListener = new JMSListenerStartupShutdownListener();
        this.registration = context.getBundleContext().registerService(ServerStartupObserver.class, (Object)jmsListenerStartupShutdownListener, null);
        this.registration = context.getBundleContext().registerService(ServerShutdownHandler.class, (Object)jmsListenerStartupShutdownListener, null);
    }

    @Reference(name="api.manager.config.service", service=APIManagerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAPIManagerConfigurationService")
    protected void setAPIManagerConfigurationService(APIManagerConfigurationService configurationService) {
        log.debug((Object)"Setting APIM Configuration Service");
        ServiceReferenceHolder.getInstance().setAPIMConfigurationService(configurationService);
    }

    protected void unsetAPIManagerConfigurationService(APIManagerConfigurationService configurationService) {
        log.debug((Object)"Setting APIM Configuration Service");
        ServiceReferenceHolder.getInstance().setAPIMConfigurationService(null);
    }

    @Reference(name="key.manager.service", service=KeyManagerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetKeyManagerService")
    protected void setKeyManagerService(KeyManagerConfigurationService keyManagerService) {
        log.debug((Object)"Setting KeyManager Configuration Service");
        ServiceReferenceHolder.getInstance().setKeyManagerService(keyManagerService);
    }

    protected void unsetKeyManagerService(KeyManagerConfigurationService keyManagerService) {
        log.debug((Object)"unSetting KeyManager Configuration Service");
        ServiceReferenceHolder.getInstance().setKeyManagerService(null);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deactivating component");
        }
        if (this.registration != null) {
            this.registration.unregister();
        }
    }
}

