/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.BaseContainer;
import org.glassfish.tyrus.core.CloseReasons;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.InputStreamBuffer;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.ReaderBuffer;
import org.glassfish.tyrus.core.ReflectionHelper;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusServerEndpointConfig;
import org.glassfish.tyrus.core.TyrusSession;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.WebSocketException;
import org.glassfish.tyrus.core.cluster.BroadcastListener;
import org.glassfish.tyrus.core.cluster.ClusterContext;
import org.glassfish.tyrus.core.cluster.ClusterSession;
import org.glassfish.tyrus.core.coder.CoderWrapper;
import org.glassfish.tyrus.core.coder.InputStreamDecoder;
import org.glassfish.tyrus.core.coder.NoOpByteArrayCoder;
import org.glassfish.tyrus.core.coder.NoOpByteBufferCoder;
import org.glassfish.tyrus.core.coder.NoOpTextCoder;
import org.glassfish.tyrus.core.coder.PrimitiveDecoders;
import org.glassfish.tyrus.core.coder.ReaderDecoder;
import org.glassfish.tyrus.core.coder.ToStringEncoder;
import org.glassfish.tyrus.core.frame.BinaryFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.frame.TextFrame;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;
import org.glassfish.tyrus.core.monitoring.EndpointEventListener;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;

public class TyrusEndpointWrapper {
    private static final Logger LOGGER = Logger.getLogger(TyrusEndpointWrapper.class.getName());
    private final WebSocketContainer container;
    private final String contextPath;
    private final String endpointPath;
    private final String serverEndpointPath;
    private final List<CoderWrapper<Decoder>> decoders = new ArrayList<CoderWrapper<Decoder>>();
    private final List<CoderWrapper<Encoder>> encoders = new ArrayList<CoderWrapper<Encoder>>();
    private final EndpointConfig configuration;
    private final Class<? extends Endpoint> endpointClass;
    private final Endpoint endpoint;
    private final Map<TyrusWebSocket, TyrusSession> webSocketToSession = new ConcurrentHashMap<TyrusWebSocket, TyrusSession>();
    private final Map<String, ClusterSession> clusteredSessions = new ConcurrentHashMap<String, ClusterSession>();
    private final ComponentProviderService componentProvider;
    private final ServerEndpointConfig.Configurator configurator;
    private final Method onOpen;
    private final Method onClose;
    private final Method onError;
    private final SessionListener sessionListener;
    private final EndpointEventListener endpointEventListener;
    private final ClusterContext clusterContext;
    private final Session dummySession;

    public TyrusEndpointWrapper(Class<? extends Endpoint> endpointClass, EndpointConfig configuration, ComponentProviderService componentProvider, WebSocketContainer container, String contextPath, ServerEndpointConfig.Configurator configurator, SessionListener sessionListener, ClusterContext clusterContext, EndpointEventListener endpointEventListener) throws DeploymentException {
        this(null, endpointClass, configuration, componentProvider, container, contextPath, configurator, sessionListener, clusterContext, endpointEventListener);
    }

    public TyrusEndpointWrapper(Endpoint endpoint, EndpointConfig configuration, ComponentProviderService componentProvider, WebSocketContainer container, String contextPath, ServerEndpointConfig.Configurator configurator, SessionListener sessionListener, ClusterContext clusterContext, EndpointEventListener endpointEventListener) throws DeploymentException {
        this(endpoint, null, configuration, componentProvider, container, contextPath, configurator, sessionListener, clusterContext, endpointEventListener);
    }

    /*
     * WARNING - void declaration
     */
    private TyrusEndpointWrapper(Endpoint endpoint, Class<? extends Endpoint> endpointClass, EndpointConfig configuration, ComponentProviderService componentProvider, WebSocketContainer container, String contextPath, final ServerEndpointConfig.Configurator configurator, SessionListener sessionListener, final ClusterContext clusterContext, EndpointEventListener endpointEventListener) throws DeploymentException {
        Class<?> type;
        Method method;
        this.endpointClass = endpointClass;
        this.endpoint = endpoint;
        this.container = container;
        this.contextPath = contextPath;
        this.configurator = configurator;
        this.sessionListener = sessionListener;
        this.clusterContext = clusterContext;
        this.endpointEventListener = endpointEventListener != null ? endpointEventListener : EndpointEventListener.NO_OP;
        if (configuration instanceof ServerEndpointConfig) {
            this.serverEndpointPath = ((ServerEndpointConfig)configuration).getPath();
            this.endpointPath = (contextPath.endsWith("/") ? contextPath.substring(0, contextPath.length() - 1) : contextPath) + "/" + (this.serverEndpointPath.startsWith("/") ? this.serverEndpointPath.substring(1) : this.serverEndpointPath);
        } else {
            this.serverEndpointPath = null;
            this.endpointPath = null;
        }
        this.componentProvider = configurator == null ? componentProvider : new ComponentProviderService(componentProvider){

            public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
                return (T)configurator.getEndpointInstance(endpointClass);
            }
        };
        Class<Endpoint> clazz = endpointClass == null ? endpoint.getClass() : endpointClass;
        Object var12_12 = null;
        Method onCloseMethod = null;
        Method onErrorMethod = null;
        for (Method m : Endpoint.class.getMethods()) {
            if (m.getName().equals("onOpen")) {
                Method method2 = m;
                continue;
            }
            if (m.getName().equals("onClose")) {
                onCloseMethod = m;
                continue;
            }
            if (!m.getName().equals("onError")) continue;
            onErrorMethod = m;
        }
        try {
            void var12_13;
            assert (var12_13 != null);
            assert (onCloseMethod != null);
            assert (onErrorMethod != null);
            method = clazz.getMethod(var12_13.getName(), var12_13.getParameterTypes());
            onCloseMethod = clazz.getMethod(onCloseMethod.getName(), onCloseMethod.getParameterTypes());
            onErrorMethod = clazz.getMethod(onErrorMethod.getName(), onErrorMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
        if (endpoint != null) {
            this.onOpen = method;
            this.onClose = onCloseMethod;
            this.onError = onErrorMethod;
        } else {
            this.onOpen = componentProvider.getInvocableMethod(method);
            this.onClose = componentProvider.getInvocableMethod(onCloseMethod);
            this.onError = componentProvider.getInvocableMethod(onErrorMethod);
        }
        this.configuration = configuration == null ? new EndpointConfig(){
            private final Map<String, Object> properties = new HashMap<String, Object>();

            @Override
            public List<Class<? extends Encoder>> getEncoders() {
                return Collections.emptyList();
            }

            @Override
            public List<Class<? extends Decoder>> getDecoders() {
                return Collections.emptyList();
            }

            @Override
            public Map<String, Object> getUserProperties() {
                return this.properties;
            }
        } : configuration;
        for (Class<? extends Decoder> clazz2 : this.configuration.getDecoders()) {
            type = this.getDecoderClassType(clazz2);
            this.decoders.add(new CoderWrapper<Class<? extends Decoder>>(clazz2, type));
        }
        if (endpoint == null || !(endpoint instanceof AnnotatedEndpoint)) {
            for (Class<? extends Decoder> clazz3 : TyrusEndpointWrapper.getDefaultDecoders()) {
                type = this.getDecoderClassType(clazz3);
                this.decoders.add(new CoderWrapper<Class<? extends Decoder>>(clazz3, type));
            }
        }
        for (Class<Object> clazz4 : this.configuration.getEncoders()) {
            type = this.getEncoderClassType(clazz4);
            this.encoders.add(new CoderWrapper<Class<Object>>(clazz4, type));
        }
        this.encoders.add(new CoderWrapper<Class<NoOpTextCoder>>(NoOpTextCoder.class, (Class<?>)String.class));
        this.encoders.add(new CoderWrapper<Class<NoOpByteBufferCoder>>(NoOpByteBufferCoder.class, (Class<?>)ByteBuffer.class));
        this.encoders.add(new CoderWrapper<Class<NoOpByteArrayCoder>>(NoOpByteArrayCoder.class, (Class<?>)byte[].class));
        this.encoders.add(new CoderWrapper<Class<ToStringEncoder>>(ToStringEncoder.class, (Class<?>)Object.class));
        if (clusterContext != null) {
            this.dummySession = new ClusterSession(null, null, null, null, null);
            clusterContext.registerSessionListener(this.getEndpointPath(), new org.glassfish.tyrus.core.cluster.SessionListener(){

                @Override
                public void onSessionOpened(String sessionId) {
                    Map<ClusterSession.DistributedMapKey, Object> distributedSessionProperties = clusterContext.getDistributedSessionProperties(sessionId);
                    TyrusEndpointWrapper.this.clusteredSessions.put(sessionId, new ClusterSession(sessionId, clusterContext, distributedSessionProperties, TyrusEndpointWrapper.this, TyrusEndpointWrapper.this.dummySession));
                }

                @Override
                public void onSessionClosed(String sessionId) {
                    TyrusEndpointWrapper.this.clusteredSessions.remove(sessionId);
                }
            });
            clusterContext.registerBroadcastListener(this.getEndpointPath(), new BroadcastListener(){

                @Override
                public void onBroadcast(String text) {
                    TyrusEndpointWrapper.this.broadcast(text, true);
                }

                @Override
                public void onBroadcast(byte[] data) {
                    TyrusEndpointWrapper.this.broadcast(ByteBuffer.wrap(data), true);
                }
            });
            for (String string : clusterContext.getRemoteSessionIds(this.getEndpointPath())) {
                Map<ClusterSession.DistributedMapKey, Object> distributedSessionProperties = clusterContext.getDistributedSessionProperties(string);
                this.clusteredSessions.put(string, new ClusterSession(string, clusterContext, distributedSessionProperties, this, this.dummySession));
            }
        } else {
            this.dummySession = null;
        }
    }

    static List<Class<? extends Decoder>> getDefaultDecoders() {
        ArrayList<Class<? extends Decoder>> classList = new ArrayList<Class<? extends Decoder>>();
        classList.addAll(PrimitiveDecoders.ALL);
        classList.add(NoOpTextCoder.class);
        classList.add(NoOpByteBufferCoder.class);
        classList.add(NoOpByteArrayCoder.class);
        classList.add(ReaderDecoder.class);
        classList.add(InputStreamDecoder.class);
        return classList;
    }

    private static URI getURI(String uri, String queryString) {
        if (queryString != null && !queryString.isEmpty()) {
            return URI.create(String.format("%s?%s", uri, queryString));
        }
        return URI.create(uri);
    }

    private <T> Object getCoderInstance(Session session, CoderWrapper<T> wrapper) {
        T coder = wrapper.getCoder();
        if (coder == null) {
            ErrorCollector collector = new ErrorCollector();
            Object coderInstance = this.componentProvider.getCoderInstance(wrapper.getCoderClass(), session, this.getEndpointConfig(), collector);
            if (!collector.isEmpty()) {
                DeploymentException deploymentException = collector.composeComprehensiveException();
                LOGGER.log(Level.WARNING, deploymentException.getMessage(), deploymentException);
                return null;
            }
            return coderInstance;
        }
        return coder;
    }

    Object decodeCompleteMessage(Session session, Object message, Class<?> type, CoderWrapper<Decoder> selectedDecoder) throws DecodeException, IOException {
        Class<Decoder> decoderClass = selectedDecoder.getCoderClass();
        if (Decoder.Text.class.isAssignableFrom(decoderClass)) {
            if (type != null && type.isAssignableFrom(selectedDecoder.getType())) {
                Decoder.Text decoder = (Decoder.Text)this.getCoderInstance(session, selectedDecoder);
                return decoder.decode((String)message);
            }
        } else if (Decoder.Binary.class.isAssignableFrom(decoderClass)) {
            if (type != null && type.isAssignableFrom(selectedDecoder.getType())) {
                Decoder.Binary decoder = (Decoder.Binary)this.getCoderInstance(session, selectedDecoder);
                return decoder.decode((ByteBuffer)message);
            }
        } else if (Decoder.TextStream.class.isAssignableFrom(decoderClass)) {
            if (type != null && type.isAssignableFrom(selectedDecoder.getType())) {
                return ((Decoder.TextStream)this.getCoderInstance(session, selectedDecoder)).decode(new StringReader((String)message));
            }
        } else if (Decoder.BinaryStream.class.isAssignableFrom(decoderClass) && type != null && type.isAssignableFrom(selectedDecoder.getType())) {
            byte[] array = ((ByteBuffer)message).array();
            return ((Decoder.BinaryStream)this.getCoderInstance(session, selectedDecoder)).decode(new ByteArrayInputStream(array));
        }
        return null;
    }

    private ArrayList<CoderWrapper<Decoder>> findApplicableDecoders(Session session, Object message, boolean isString) {
        ArrayList<CoderWrapper<Decoder>> result = new ArrayList<CoderWrapper<Decoder>>();
        for (CoderWrapper<Decoder> dec : this.decoders) {
            Decoder decoder;
            if (isString && Decoder.Text.class.isAssignableFrom(dec.getCoderClass())) {
                decoder = (Decoder.Text)this.getCoderInstance(session, dec);
                if (!decoder.willDecode((String)message)) continue;
                result.add(dec);
                continue;
            }
            if (!isString && Decoder.Binary.class.isAssignableFrom(dec.getCoderClass())) {
                decoder = (Decoder.Binary)this.getCoderInstance(session, dec);
                if (!decoder.willDecode((ByteBuffer)message)) continue;
                result.add(dec);
                continue;
            }
            if (isString && Decoder.TextStream.class.isAssignableFrom(dec.getCoderClass())) {
                result.add(dec);
                continue;
            }
            if (isString || !Decoder.BinaryStream.class.isAssignableFrom(dec.getCoderClass())) continue;
            result.add(dec);
        }
        return result;
    }

    public Object doEncode(Session session, Object message) throws EncodeException, IOException {
        for (CoderWrapper<Encoder> enc : this.encoders) {
            Class<Encoder> encoderClass = enc.getCoderClass();
            if (Encoder.Binary.class.isAssignableFrom(encoderClass)) {
                if (!enc.getType().isAssignableFrom(message.getClass())) continue;
                Encoder.Binary encoder = (Encoder.Binary)this.getCoderInstance(session, enc);
                return encoder.encode(message);
            }
            if (Encoder.Text.class.isAssignableFrom(encoderClass)) {
                if (!enc.getType().isAssignableFrom(message.getClass())) continue;
                Encoder.Text encoder = (Encoder.Text)this.getCoderInstance(session, enc);
                return encoder.encode(message);
            }
            if (Encoder.BinaryStream.class.isAssignableFrom(encoderClass)) {
                if (!enc.getType().isAssignableFrom(message.getClass())) continue;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                Encoder.BinaryStream encoder = (Encoder.BinaryStream)this.getCoderInstance(session, enc);
                encoder.encode(message, stream);
                return stream;
            }
            if (!Encoder.TextStream.class.isAssignableFrom(encoderClass) || !enc.getType().isAssignableFrom(message.getClass())) continue;
            StringWriter writer = new StringWriter();
            Encoder.TextStream encoder = (Encoder.TextStream)this.getCoderInstance(session, enc);
            encoder.encode(message, writer);
            return writer;
        }
        throw new EncodeException(message, LocalizationMessages.ENCODING_FAILED());
    }

    public String getEndpointPath() {
        return this.endpointPath;
    }

    public String getServerEndpointPath() {
        return this.serverEndpointPath;
    }

    public List<Extension> getNegotiatedExtensions(List<Extension> clientExtensions) {
        if (this.configuration instanceof ServerEndpointConfig) {
            return this.configurator.getNegotiatedExtensions(((ServerEndpointConfig)this.configuration).getExtensions(), clientExtensions);
        }
        return Collections.emptyList();
    }

    public String getNegotiatedProtocol(List<String> clientProtocols) {
        if (this.configuration instanceof ServerEndpointConfig) {
            return this.configurator.getNegotiatedSubprotocol(((ServerEndpointConfig)this.configuration).getSubprotocols(), clientProtocols);
        }
        return null;
    }

    public Set<Session> getOpenSessions(TyrusSession tyrusSession) {
        HashSet<Session> result = new HashSet<Session>();
        for (Session session : this.webSocketToSession.values()) {
            if (!session.isOpen()) continue;
            result.add(session);
        }
        if (this.clusterContext != null) {
            result.addAll(this.clusteredSessions.values());
        }
        return Collections.unmodifiableSet(result);
    }

    public Session createSessionForRemoteEndpoint(TyrusWebSocket socket, String subprotocol, List<Extension> extensions) {
        TyrusSession session = new TyrusSession(this.container, socket, this, subprotocol, extensions, false, TyrusEndpointWrapper.getURI(this.contextPath, null), null, Collections.<String, String>emptyMap(), null, Collections.<String, List<String>>emptyMap(), null, null, null);
        this.webSocketToSession.put(socket, session);
        return session;
    }

    private TyrusSession getSession(TyrusWebSocket socket) {
        return this.webSocketToSession.get(socket);
    }

    public Session onConnect(TyrusWebSocket socket, UpgradeRequest upgradeRequest, String subProtocol, List<Extension> extensions, String connectionId) {
        Endpoint toCall;
        TyrusSession session = this.webSocketToSession.get(socket);
        if (session == null) {
            HashMap<String, String> templateValues = new HashMap<String, String>();
            for (Map.Entry entry : upgradeRequest.getParameterMap().entrySet()) {
                templateValues.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
            session = new TyrusSession(this.container, socket, this, subProtocol, extensions, upgradeRequest.isSecure(), TyrusEndpointWrapper.getURI(upgradeRequest.getRequestURI().toString(), upgradeRequest.getQueryString()), upgradeRequest.getQueryString(), templateValues, upgradeRequest.getUserPrincipal(), upgradeRequest.getParameterMap(), this.clusterContext, connectionId, ((RequestContext)upgradeRequest).getRemoteAddr());
            this.webSocketToSession.put(socket, session);
            boolean maxSessionPerEndpointExceeded = this.configuration instanceof TyrusServerEndpointConfig && ((TyrusServerEndpointConfig)((Object)this.configuration)).getMaxSessions() > 0 && this.webSocketToSession.size() > ((TyrusServerEndpointConfig)((Object)this.configuration)).getMaxSessions();
            SessionListener.OnOpenResult onOpenResult = this.sessionListener.onOpen(session);
            if (maxSessionPerEndpointExceeded || !onOpenResult.equals((Object)SessionListener.OnOpenResult.SESSION_ALLOWED)) {
                try {
                    String refuseDetail;
                    this.webSocketToSession.remove(socket);
                    if (maxSessionPerEndpointExceeded) {
                        refuseDetail = LocalizationMessages.MAX_SESSIONS_PER_ENDPOINT_EXCEEDED();
                    } else {
                        switch (onOpenResult) {
                            case MAX_SESSIONS_PER_APP_EXCEEDED: {
                                refuseDetail = LocalizationMessages.MAX_SESSIONS_PER_APP_EXCEEDED();
                                break;
                            }
                            case MAX_SESSIONS_PER_REMOTE_ADDR_EXCEEDED: {
                                refuseDetail = LocalizationMessages.MAX_SESSIONS_PER_REMOTEADDR_EXCEEDED();
                                break;
                            }
                            default: {
                                refuseDetail = null;
                            }
                        }
                    }
                    LOGGER.log(Level.FINE, "Session opening refused: " + refuseDetail);
                    session.close(new CloseReason(CloseReason.CloseCodes.TRY_AGAIN_LATER, refuseDetail));
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
                return null;
            }
            socket.setMessageEventListener(this.endpointEventListener.onSessionOpened(session.getId()));
        }
        ErrorCollector collector = new ErrorCollector();
        Endpoint endpoint = toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
        if (toCall == null) {
            if (!collector.isEmpty()) {
                DeploymentException t = collector.composeComprehensiveException();
                LOGGER.log(Level.FINE, t.getMessage(), t);
            }
            this.webSocketToSession.remove(socket);
            this.sessionListener.onClose(session, CloseReasons.UNEXPECTED_CONDITION.getCloseReason());
            try {
                session.close(CloseReasons.UNEXPECTED_CONDITION.getCloseReason());
            }
            catch (IOException e) {
                LOGGER.log(Level.FINEST, e.getMessage(), e);
            }
            return null;
        }
        try {
            if (!collector.isEmpty()) {
                throw collector.composeComprehensiveException();
            }
            if (this.endpoint != null) {
                toCall.onOpen(session, this.configuration);
            } else {
                this.onOpen.invoke((Object)toCall, session, this.configuration);
            }
        }
        catch (Throwable t) {
            if (this.endpoint != null) {
                toCall.onError(session, t);
            } else {
                try {
                    this.onError.invoke((Object)toCall, session, t);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, t.getMessage(), t);
                }
            }
            this.endpointEventListener.onError(session.getId(), t);
        }
        return session;
    }

    public void onMessage(TyrusWebSocket socket, ByteBuffer messageBytes) {
        block13: {
            TyrusSession session = this.getSession(socket);
            if (session == null) {
                LOGGER.log(Level.FINE, "Message received on already closed connection.");
                return;
            }
            try {
                session.restartIdleTimeoutExecutor();
                TyrusSession.State state = session.getState();
                if (state == TyrusSession.State.RECEIVING_BINARY || state == TyrusSession.State.RECEIVING_TEXT) {
                    session.setState(TyrusSession.State.RUNNING);
                }
                if (session.isWholeBinaryHandlerPresent()) {
                    session.notifyMessageHandlers((Object)messageBytes, this.findApplicableDecoders(session, messageBytes, false));
                    break block13;
                }
                if (session.isPartialBinaryHandlerPresent()) {
                    session.notifyMessageHandlers((Object)messageBytes, true);
                    break block13;
                }
                throw new IllegalStateException(LocalizationMessages.BINARY_MESSAGE_HANDLER_NOT_FOUND(session));
            }
            catch (Throwable t) {
                Endpoint toCall;
                if (this.processThrowable(t, session)) break block13;
                ErrorCollector collector = new ErrorCollector();
                Endpoint endpoint = toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
                if (toCall != null) {
                    if (this.endpoint != null) {
                        toCall.onError(session, t);
                    } else {
                        try {
                            this.onError.invoke((Object)toCall, session, t);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, t.getMessage(), t);
                        }
                    }
                } else if (!collector.isEmpty()) {
                    DeploymentException deploymentException = collector.composeComprehensiveException();
                    LOGGER.log(Level.WARNING, deploymentException.getMessage(), deploymentException);
                }
                this.endpointEventListener.onError(session.getId(), t);
            }
        }
    }

    public void onMessage(TyrusWebSocket socket, String messageString) {
        block13: {
            TyrusSession session = this.getSession(socket);
            if (session == null) {
                LOGGER.log(Level.FINE, "Message received on already closed connection.");
                return;
            }
            try {
                session.restartIdleTimeoutExecutor();
                TyrusSession.State state = session.getState();
                if (state == TyrusSession.State.RECEIVING_BINARY || state == TyrusSession.State.RECEIVING_TEXT) {
                    session.setState(TyrusSession.State.RUNNING);
                }
                if (session.isWholeTextHandlerPresent()) {
                    session.notifyMessageHandlers((Object)messageString, this.findApplicableDecoders(session, messageString, true));
                    break block13;
                }
                if (session.isPartialTextHandlerPresent()) {
                    session.notifyMessageHandlers((Object)messageString, true);
                    break block13;
                }
                throw new IllegalStateException(LocalizationMessages.TEXT_MESSAGE_HANDLER_NOT_FOUND(session));
            }
            catch (Throwable t) {
                Endpoint toCall;
                if (this.processThrowable(t, session)) break block13;
                ErrorCollector collector = new ErrorCollector();
                Endpoint endpoint = toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
                if (toCall != null) {
                    if (this.endpoint != null) {
                        toCall.onError(session, t);
                    } else {
                        try {
                            this.onError.invoke((Object)toCall, session, t);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, t.getMessage(), t);
                        }
                    }
                } else if (!collector.isEmpty()) {
                    DeploymentException deploymentException = collector.composeComprehensiveException();
                    LOGGER.log(Level.WARNING, deploymentException.getMessage(), deploymentException);
                }
                this.endpointEventListener.onError(session.getId(), t);
            }
        }
    }

    public void onPartialMessage(TyrusWebSocket socket, String partialString, boolean last) {
        block26: {
            TyrusSession session = this.getSession(socket);
            if (session == null) {
                LOGGER.log(Level.FINE, "Message received on already closed connection.");
                return;
            }
            try {
                session.restartIdleTimeoutExecutor();
                TyrusSession.State state = session.getState();
                if (session.isPartialTextHandlerPresent()) {
                    session.notifyMessageHandlers((Object)partialString, last);
                    if (state == TyrusSession.State.RECEIVING_BINARY || state == TyrusSession.State.RECEIVING_TEXT) {
                        session.setState(TyrusSession.State.RUNNING);
                    }
                    break block26;
                }
                if (session.isReaderHandlerPresent()) {
                    ReaderBuffer buffer = session.getReaderBuffer();
                    switch (state) {
                        case RUNNING: {
                            if (buffer == null) {
                                buffer = new ReaderBuffer(((BaseContainer)this.container).getExecutorService());
                                session.setReaderBuffer(buffer);
                            }
                            buffer.resetBuffer(session.getMaxTextMessageBufferSize());
                            buffer.setMessageHandler(session.getMessageHandler(Reader.class));
                            buffer.appendMessagePart(partialString, last);
                            session.setState(TyrusSession.State.RECEIVING_TEXT);
                            break;
                        }
                        case RECEIVING_TEXT: {
                            buffer.appendMessagePart(partialString, last);
                            if (last) {
                                session.setState(TyrusSession.State.RUNNING);
                                break;
                            }
                            break block26;
                        }
                        default: {
                            if (state == TyrusSession.State.RECEIVING_BINARY) {
                                session.setState(TyrusSession.State.RUNNING);
                            }
                            throw new IllegalStateException(LocalizationMessages.PARTIAL_TEXT_MESSAGE_OUT_OF_ORDER(session));
                        }
                    }
                    break block26;
                }
                if (!session.isWholeTextHandlerPresent()) break block26;
                switch (state) {
                    case RUNNING: {
                        session.getTextBuffer().resetBuffer(session.getMaxTextMessageBufferSize());
                        session.getTextBuffer().appendMessagePart(partialString);
                        session.setState(TyrusSession.State.RECEIVING_TEXT);
                        break;
                    }
                    case RECEIVING_TEXT: {
                        session.getTextBuffer().appendMessagePart(partialString);
                        if (last) {
                            String message = session.getTextBuffer().getBufferedContent();
                            session.notifyMessageHandlers((Object)message, this.findApplicableDecoders(session, message, true));
                            session.setState(TyrusSession.State.RUNNING);
                        }
                        break;
                    }
                    default: {
                        if (state == TyrusSession.State.RECEIVING_BINARY) {
                            session.setState(TyrusSession.State.RUNNING);
                        }
                        throw new IllegalStateException(LocalizationMessages.TEXT_MESSAGE_OUT_OF_ORDER(session));
                    }
                }
            }
            catch (Throwable t) {
                Endpoint toCall;
                if (this.processThrowable(t, session)) break block26;
                ErrorCollector collector = new ErrorCollector();
                Endpoint endpoint = toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
                if (toCall != null) {
                    if (this.endpoint != null) {
                        toCall.onError(session, t);
                    } else {
                        try {
                            this.onError.invoke((Object)toCall, session, t);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, t.getMessage(), t);
                        }
                    }
                } else if (!collector.isEmpty()) {
                    DeploymentException deploymentException = collector.composeComprehensiveException();
                    LOGGER.log(Level.WARNING, deploymentException.getMessage(), deploymentException);
                }
                this.endpointEventListener.onError(session.getId(), t);
            }
        }
    }

    public void onPartialMessage(TyrusWebSocket socket, ByteBuffer partialBytes, boolean last) {
        block26: {
            TyrusSession session = this.getSession(socket);
            if (session == null) {
                LOGGER.log(Level.FINE, "Message received on already closed connection.");
                return;
            }
            try {
                session.restartIdleTimeoutExecutor();
                TyrusSession.State state = session.getState();
                if (session.isPartialBinaryHandlerPresent()) {
                    session.notifyMessageHandlers((Object)partialBytes, last);
                    if (state == TyrusSession.State.RECEIVING_BINARY || state == TyrusSession.State.RECEIVING_TEXT) {
                        session.setState(TyrusSession.State.RUNNING);
                    }
                    break block26;
                }
                if (session.isInputStreamHandlerPresent()) {
                    InputStreamBuffer buffer = session.getInputStreamBuffer();
                    switch (state) {
                        case RUNNING: {
                            if (buffer == null) {
                                buffer = new InputStreamBuffer(((BaseContainer)this.container).getExecutorService());
                                session.setInputStreamBuffer(buffer);
                            }
                            buffer.resetBuffer(session.getMaxBinaryMessageBufferSize());
                            buffer.setMessageHandler(session.getMessageHandler(InputStream.class));
                            buffer.appendMessagePart(partialBytes, last);
                            session.setState(TyrusSession.State.RECEIVING_BINARY);
                            break;
                        }
                        case RECEIVING_BINARY: {
                            buffer.appendMessagePart(partialBytes, last);
                            if (last) {
                                session.setState(TyrusSession.State.RUNNING);
                                break;
                            }
                            break block26;
                        }
                        default: {
                            if (state == TyrusSession.State.RECEIVING_TEXT) {
                                session.setState(TyrusSession.State.RUNNING);
                            }
                            throw new IllegalStateException(LocalizationMessages.PARTIAL_BINARY_MESSAGE_OUT_OF_ORDER(session));
                        }
                    }
                    break block26;
                }
                if (!session.isWholeBinaryHandlerPresent()) break block26;
                switch (state) {
                    case RUNNING: {
                        session.getBinaryBuffer().resetBuffer(session.getMaxBinaryMessageBufferSize());
                        session.getBinaryBuffer().appendMessagePart(partialBytes);
                        session.setState(TyrusSession.State.RECEIVING_BINARY);
                        break;
                    }
                    case RECEIVING_BINARY: {
                        session.getBinaryBuffer().appendMessagePart(partialBytes);
                        if (last) {
                            ByteBuffer bb = session.getBinaryBuffer().getBufferedContent();
                            session.notifyMessageHandlers((Object)bb, this.findApplicableDecoders(session, bb, false));
                            session.setState(TyrusSession.State.RUNNING);
                        }
                        break;
                    }
                    default: {
                        if (state == TyrusSession.State.RECEIVING_TEXT) {
                            session.setState(TyrusSession.State.RUNNING);
                        }
                        throw new IllegalStateException(LocalizationMessages.BINARY_MESSAGE_OUT_OF_ORDER(session));
                    }
                }
            }
            catch (Throwable t) {
                Endpoint toCall;
                if (this.processThrowable(t, session)) break block26;
                ErrorCollector collector = new ErrorCollector();
                Endpoint endpoint = toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
                if (toCall != null) {
                    if (this.endpoint != null) {
                        toCall.onError(session, t);
                    } else {
                        try {
                            this.onError.invoke((Object)toCall, session, t);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, t.getMessage(), t);
                        }
                    }
                } else if (!collector.isEmpty()) {
                    DeploymentException deploymentException = collector.composeComprehensiveException();
                    LOGGER.log(Level.WARNING, deploymentException.getMessage(), deploymentException);
                }
                this.endpointEventListener.onError(session.getId(), t);
            }
        }
    }

    private boolean processThrowable(Throwable throwable, Session session) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("Exception thrown while processing message. Session: '%session'.", session), throwable);
        }
        if (throwable instanceof WebSocketException) {
            try {
                session.close(((WebSocketException)throwable).getCloseReason());
                return false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void onPong(TyrusWebSocket socket, final ByteBuffer bytes) {
        TyrusSession session = this.getSession(socket);
        if (session == null) {
            LOGGER.log(Level.FINE, "Pong received on already closed connection.");
            return;
        }
        session.restartIdleTimeoutExecutor();
        if (session.isPongHandlerPreset()) {
            session.notifyPongHandler(new PongMessage(){

                @Override
                public ByteBuffer getApplicationData() {
                    return bytes;
                }

                public String toString() {
                    return "PongMessage: " + bytes;
                }
            });
        } else {
            LOGGER.log(Level.FINE, String.format("Unhandled pong message. Session: '%s'", session));
        }
    }

    public void onPing(TyrusWebSocket socket, ByteBuffer bytes) {
        TyrusSession session = this.getSession(socket);
        if (session == null) {
            LOGGER.log(Level.FINE, "Ping received on already closed connection.");
            return;
        }
        session.restartIdleTimeoutExecutor();
        try {
            session.getBasicRemote().sendPong(bytes);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(TyrusWebSocket socket, CloseReason closeReason) {
        TyrusSession session = this.getSession(socket);
        if (session == null) {
            return;
        }
        session.setState(TyrusSession.State.CLOSED);
        ErrorCollector collector = new ErrorCollector();
        Endpoint toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
        try {
            if (!collector.isEmpty()) {
                throw collector.composeComprehensiveException();
            }
            if (this.endpoint != null) {
                toCall.onClose(session, closeReason);
            } else {
                this.onClose.invoke((Object)toCall, session, closeReason);
            }
        }
        catch (Throwable t) {
            if (toCall != null) {
                if (this.endpoint != null) {
                    toCall.onError(session, t);
                } else {
                    try {
                        this.onError.invoke((Object)toCall, session, t);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, t.getMessage(), t);
                    }
                }
            } else {
                LOGGER.log(Level.WARNING, t.getMessage(), t);
            }
            this.endpointEventListener.onError(session.getId(), t);
        }
        finally {
            session.setState(TyrusSession.State.CLOSED);
            if (this.clusterContext != null) {
                this.clusterContext.removeSession(session.getId(), this.getEndpointPath());
                this.clusterContext.destroyDistributedUserProperties(session.getConnectionId());
            }
            this.webSocketToSession.remove(socket);
            this.endpointEventListener.onSessionClosed(session.getId());
            this.componentProvider.removeSession(session);
            this.sessionListener.onClose(session, closeReason);
        }
    }

    public EndpointConfig getEndpointConfig() {
        return this.configuration;
    }

    public Map<Session, Future<?>> broadcast(String message) {
        return this.broadcast(message, false);
    }

    private Map<Session, Future<?>> broadcast(String message, boolean local) {
        if (!local && this.clusterContext != null) {
            this.clusterContext.broadcastText(this.getEndpointPath(), message);
        }
        HashMap futures = new HashMap();
        byte[] frame = null;
        for (Map.Entry<TyrusWebSocket, TyrusSession> e : this.webSocketToSession.entrySet()) {
            if (!e.getValue().isOpen()) continue;
            TyrusWebSocket webSocket = e.getKey();
            ProtocolHandler protocolHandler = webSocket.getProtocolHandler();
            if (protocolHandler.hasExtensions()) {
                TextFrame dataFrame = new TextFrame(message, false, true);
                ByteBuffer byteBuffer = webSocket.getProtocolHandler().frame(dataFrame);
                byte[] tempFrame = new byte[byteBuffer.remaining()];
                byteBuffer.get(tempFrame);
                Future<Frame> frameFuture = webSocket.sendRawFrame(ByteBuffer.wrap(tempFrame));
                futures.put(e.getValue(), frameFuture);
                continue;
            }
            if (frame == null) {
                TextFrame dataFrame = new TextFrame(message, false, true);
                ByteBuffer byteBuffer = webSocket.getProtocolHandler().frame(dataFrame);
                frame = new byte[byteBuffer.remaining()];
                byteBuffer.get(frame);
            }
            Future<Frame> frameFuture = webSocket.sendRawFrame(ByteBuffer.wrap(frame));
            futures.put(e.getValue(), frameFuture);
        }
        return futures;
    }

    public Map<Session, Future<?>> broadcast(ByteBuffer message) {
        return this.broadcast(message, false);
    }

    private Map<Session, Future<?>> broadcast(ByteBuffer message, boolean local) {
        HashMap futures = new HashMap();
        byte[] frame = null;
        byte[] byteArrayMessage = Utils.getRemainingArray(message);
        if (!local && this.clusterContext != null) {
            this.clusterContext.broadcastBinary(this.getEndpointPath(), byteArrayMessage);
        }
        for (Map.Entry<TyrusWebSocket, TyrusSession> e : this.webSocketToSession.entrySet()) {
            if (!e.getValue().isOpen()) continue;
            TyrusWebSocket webSocket = e.getKey();
            ProtocolHandler protocolHandler = webSocket.getProtocolHandler();
            if (protocolHandler.hasExtensions()) {
                BinaryFrame dataFrame = new BinaryFrame(byteArrayMessage, false, true);
                ByteBuffer byteBuffer = webSocket.getProtocolHandler().frame(dataFrame);
                byte[] tempFrame = new byte[byteBuffer.remaining()];
                byteBuffer.get(tempFrame);
                Future<Frame> frameFuture = webSocket.sendRawFrame(ByteBuffer.wrap(tempFrame));
                futures.put(e.getValue(), frameFuture);
                continue;
            }
            if (frame == null) {
                BinaryFrame dataFrame = new BinaryFrame(byteArrayMessage, false, true);
                ByteBuffer byteBuffer = webSocket.getProtocolHandler().frame(dataFrame);
                frame = new byte[byteBuffer.remaining()];
                byteBuffer.get(frame);
            }
            Future<Frame> frameFuture = webSocket.sendRawFrame(ByteBuffer.wrap(frame));
            futures.put(e.getValue(), frameFuture);
        }
        return futures;
    }

    List<Decoder> getDecoders() {
        return this.decoders;
    }

    private Class<?> getEncoderClassType(Class<?> encoderClass) {
        if (Encoder.Binary.class.isAssignableFrom(encoderClass)) {
            return ReflectionHelper.getClassType(encoderClass, Encoder.Binary.class);
        }
        if (Encoder.Text.class.isAssignableFrom(encoderClass)) {
            return ReflectionHelper.getClassType(encoderClass, Encoder.Text.class);
        }
        if (Encoder.BinaryStream.class.isAssignableFrom(encoderClass)) {
            return ReflectionHelper.getClassType(encoderClass, Encoder.BinaryStream.class);
        }
        if (Encoder.TextStream.class.isAssignableFrom(encoderClass)) {
            return ReflectionHelper.getClassType(encoderClass, Encoder.TextStream.class);
        }
        return null;
    }

    private Class<?> getDecoderClassType(Class<?> decoderClass) {
        if (Decoder.Binary.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.Binary.class);
        }
        if (Decoder.Text.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.Text.class);
        }
        if (Decoder.BinaryStream.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.BinaryStream.class);
        }
        if (Decoder.TextStream.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.TextStream.class);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TyrusEndpointWrapper");
        sb.append("{endpointClass=").append(this.endpointClass);
        sb.append(", endpoint=").append(this.endpoint);
        sb.append(", contextPath='").append(this.contextPath).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public final boolean upgrade(UpgradeRequest request) {
        String upgradeHeader = request.getHeader("Upgrade");
        if (request.getHeaders().get("Upgrade") != null && "websocket".equalsIgnoreCase(upgradeHeader)) {
            if (!(this.configuration instanceof ServerEndpointConfig)) {
                return false;
            }
            if (this.configurator.checkOrigin(request.getHeader("Origin"))) {
                return true;
            }
            throw new HandshakeException(403, LocalizationMessages.ORIGIN_NOT_VERIFIED());
        }
        return false;
    }

    public TyrusWebSocket createSocket(ProtocolHandler handler) {
        return new TyrusWebSocket(handler, this);
    }

    public boolean onError(TyrusWebSocket socket, Throwable t) {
        Logger.getLogger(TyrusEndpointWrapper.class.getName()).log(Level.WARNING, LocalizationMessages.UNEXPECTED_ERROR_CONNECTION_CLOSE(), t);
        return true;
    }

    public void onHandShakeResponse(UpgradeRequest request, UpgradeResponse response) {
        EndpointConfig configuration = this.getEndpointConfig();
        if (configuration instanceof ServerEndpointConfig) {
            ServerEndpointConfig serverEndpointConfig = (ServerEndpointConfig)configuration;
            serverEndpointConfig.getConfigurator().modifyHandshake(serverEndpointConfig, this.createHandshakeRequest(request), (HandshakeResponse)response);
        }
    }

    private HandshakeRequest createHandshakeRequest(UpgradeRequest webSocketRequest) {
        if (webSocketRequest instanceof RequestContext) {
            RequestContext requestContext = (RequestContext)webSocketRequest;
            requestContext.lock();
            return requestContext;
        }
        return null;
    }

    public static abstract class SessionListener {
        public OnOpenResult onOpen(TyrusSession session) {
            return OnOpenResult.SESSION_ALLOWED;
        }

        public void onClose(TyrusSession session, CloseReason closeReason) {
        }

        public static enum OnOpenResult {
            SESSION_ALLOWED,
            MAX_SESSIONS_PER_APP_EXCEEDED,
            MAX_SESSIONS_PER_REMOTE_ADDR_EXCEEDED;

        }
    }
}

