/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.net.URI;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.tyrus.spi.UpgradeRequest;

public final class RequestContext
extends UpgradeRequest {
    private final URI requestURI;
    private final String queryString;
    private final Object httpSession;
    private final boolean secure;
    private final Principal userPrincipal;
    private final Builder.IsUserInRoleDelegate isUserInRoleDelegate;
    private final String remoteAddr;
    private Map<String, List<String>> headers = new TreeMap<String, List<String>>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.toLowerCase().compareTo(o2.toLowerCase());
        }
    });
    private Map<String, List<String>> parameterMap;

    private RequestContext(URI requestURI, String queryString, Object httpSession, boolean secure, Principal userPrincipal, Builder.IsUserInRoleDelegate IsUserInRoleDelegate2, String remoteAddr, Map<String, List<String>> parameterMap) {
        this.requestURI = requestURI;
        this.queryString = queryString;
        this.httpSession = httpSession;
        this.secure = secure;
        this.userPrincipal = userPrincipal;
        this.isUserInRoleDelegate = IsUserInRoleDelegate2;
        this.remoteAddr = remoteAddr;
        this.parameterMap = parameterMap;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        List<String> stringList = this.headers.get(name);
        if (stringList == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : stringList) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public void lock() {
        this.headers = Collections.unmodifiableMap(this.headers);
        this.parameterMap = Collections.unmodifiableMap(this.parameterMap);
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public boolean isUserInRole(String role) {
        if (this.isUserInRoleDelegate != null) {
            return this.isUserInRoleDelegate.isUserInRole(role);
        }
        return false;
    }

    public Object getHttpSession() {
        return this.httpSession;
    }

    public Map<String, List<String>> getParameterMap() {
        return this.parameterMap;
    }

    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getRequestUri() {
        return this.requestURI.toString();
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public static final class Builder {
        private URI requestURI;
        private String queryString;
        private Object httpSession;
        private boolean secure;
        private Principal userPrincipal;
        private IsUserInRoleDelegate isUserInRoleDelegate;
        private Map<String, List<String>> parameterMap;
        private String remoteAddr;

        public static Builder create() {
            return new Builder();
        }

        public Builder requestURI(URI requestURI) {
            this.requestURI = requestURI;
            return this;
        }

        public Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder httpSession(Object httpSession) {
            this.httpSession = httpSession;
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder userPrincipal(Principal principal) {
            this.userPrincipal = principal;
            return this;
        }

        public Builder isUserInRoleDelegate(IsUserInRoleDelegate isUserInRoleDelegate) {
            this.isUserInRoleDelegate = isUserInRoleDelegate;
            return this;
        }

        public Builder parameterMap(Map<String, String[]> parameterMap) {
            if (parameterMap != null) {
                this.parameterMap = new HashMap<String, List<String>>();
                for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                    this.parameterMap.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
                }
            } else {
                this.parameterMap = null;
            }
            return this;
        }

        public Builder remoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
            return this;
        }

        public RequestContext build() {
            return new RequestContext(this.requestURI, this.queryString, this.httpSession, this.secure, this.userPrincipal, this.isUserInRoleDelegate, this.remoteAddr, this.parameterMap != null ? this.parameterMap : new HashMap());
        }

        public static interface IsUserInRoleDelegate {
            public boolean isUserInRole(String var1);
        }
    }
}

