/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.Extension;
import javax.websocket.Session;
import org.glassfish.tyrus.core.Handshake;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.Version;
import org.glassfish.tyrus.core.WebSocketException;
import org.glassfish.tyrus.core.extension.ExtendedExtension;
import org.glassfish.tyrus.core.frame.CloseFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.spi.ClientEngine;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.Writer;

public class TyrusClientEngine
implements ClientEngine {
    public static final int DEFAULT_INCOMING_BUFFER_SIZE = 0x40000B;
    private static final Logger LOGGER = Logger.getLogger(TyrusClientEngine.class.getName());
    private static final Version DEFAULT_VERSION = Version.DRAFT17;
    private static final int BUFFER_STEP_SIZE = 256;
    private final ProtocolHandler protocolHandler = DEFAULT_VERSION.createHandler(true);
    private final TyrusEndpointWrapper endpointWrapper;
    private final ClientHandshakeListener listener;
    private final Map<String, Object> properties;
    private Handshake clientHandShake = null;
    private volatile ClientEngine.TimeoutHandler timeoutHandler = null;

    TyrusClientEngine(TyrusEndpointWrapper endpointWrapper, ClientHandshakeListener listener, Map<String, Object> properties) {
        this.endpointWrapper = endpointWrapper;
        this.listener = listener;
        this.properties = properties;
    }

    @Override
    public UpgradeRequest createUpgradeRequest(URI uri, ClientEngine.TimeoutHandler timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
        this.clientHandShake = Handshake.createClientHandshake(RequestContext.Builder.create().requestURI(uri).build());
        ClientEndpointConfig config = (ClientEndpointConfig)this.endpointWrapper.getEndpointConfig();
        this.clientHandShake.setExtensions(config.getExtensions());
        this.clientHandShake.setSubProtocols(config.getPreferredSubprotocols());
        this.clientHandShake.prepareRequest();
        config.getConfigurator().beforeRequest(this.clientHandShake.getRequest().getHeaders());
        return this.clientHandShake.getRequest();
    }

    @Override
    public Connection processResponse(UpgradeResponse upgradeResponse, final Writer writer, final Connection.CloseListener closeListener) {
        try {
            this.clientHandShake.validateServerResponse(upgradeResponse);
            final TyrusWebSocket socket = new TyrusWebSocket(this.protocolHandler, this.endpointWrapper);
            List<Extension> handshakeResponseExtensions = TyrusExtension.fromHeaders(upgradeResponse.getHeaders().get("Sec-WebSocket-Extensions"));
            ArrayList<Extension> extensions = new ArrayList<Extension>();
            final ExtendedExtension.ExtensionContext extensionContext = new ExtendedExtension.ExtensionContext(){
                private final Map<String, Object> properties = new HashMap<String, Object>();

                @Override
                public Map<String, Object> getProperties() {
                    return this.properties;
                }
            };
            for (Extension responseExtension : handshakeResponseExtensions) {
                for (Extension installedExtension : ((ClientEndpointConfig)this.endpointWrapper.getEndpointConfig()).getExtensions()) {
                    if (responseExtension.getName() == null || !responseExtension.getName().equals(installedExtension.getName())) continue;
                    if (installedExtension instanceof ExtendedExtension) {
                        ((ExtendedExtension)installedExtension).onHandshakeResponse(extensionContext, responseExtension.getParameters());
                    }
                    extensions.add(installedExtension);
                }
            }
            final Session sessionForRemoteEndpoint = this.endpointWrapper.createSessionForRemoteEndpoint(socket, upgradeResponse.getFirstHeaderValue("Sec-WebSocket-Protocol"), extensions);
            ((ClientEndpointConfig)this.endpointWrapper.getEndpointConfig()).getConfigurator().afterResponse(upgradeResponse);
            this.protocolHandler.setWriter(writer);
            this.protocolHandler.setWebSocket(socket);
            this.protocolHandler.setExtensions(extensions);
            this.protocolHandler.setExtensionContext(extensionContext);
            socket.onConnect(this.clientHandShake.getRequest(), null, null, null);
            this.listener.onSessionCreated(sessionForRemoteEndpoint);
            Integer tyrusIncomingBufferSize = Utils.getProperty(this.properties, "org.glassfish.tyrus.incomingBufferSize", Integer.class);
            Integer wlsIncomingBufferSize = Utils.getProperty(this.endpointWrapper.getEndpointConfig().getUserProperties(), "weblogic.websocket.tyrus.incoming-buffer-size", Integer.class);
            final Integer incomingBufferSize = tyrusIncomingBufferSize == null && wlsIncomingBufferSize == null ? Integer.valueOf(0x40000B) : (wlsIncomingBufferSize != null ? wlsIncomingBufferSize : tyrusIncomingBufferSize);
            return new Connection(){
                private final ReadHandler readHandler;
                {
                    this.readHandler = new TyrusReadHandler(TyrusClientEngine.this.protocolHandler, socket, incomingBufferSize, sessionForRemoteEndpoint.getNegotiatedExtensions(), extensionContext);
                }

                @Override
                public ReadHandler getReadHandler() {
                    return this.readHandler;
                }

                @Override
                public Writer getWriter() {
                    return writer;
                }

                @Override
                public Connection.CloseListener getCloseListener() {
                    return closeListener;
                }

                @Override
                public void close(CloseReason reason) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getMessage(), e);
                    }
                    socket.close(reason.getCloseCode().getCode(), reason.getReasonPhrase());
                    for (Extension extension : sessionForRemoteEndpoint.getNegotiatedExtensions()) {
                        if (!(extension instanceof ExtendedExtension)) continue;
                        ((ExtendedExtension)extension).destroy(extensionContext);
                    }
                }
            };
        }
        catch (Throwable e) {
            this.listener.onError(e);
            return null;
        }
    }

    public ClientEngine.TimeoutHandler getTimeoutHandler() {
        return this.timeoutHandler;
    }

    private static class TyrusReadHandler
    implements ReadHandler {
        private final int incomingBufferSize;
        private final ProtocolHandler handler;
        private final TyrusWebSocket socket;
        private final List<Extension> negotiatedExtensions;
        private final ExtendedExtension.ExtensionContext extensionContext;
        private ByteBuffer buffer = null;

        TyrusReadHandler(ProtocolHandler protocolHandler, TyrusWebSocket socket, int incomingBufferSize, List<Extension> negotiatedExtensions, ExtendedExtension.ExtensionContext extensionContext) {
            this.handler = protocolHandler;
            this.socket = socket;
            this.incomingBufferSize = incomingBufferSize;
            this.negotiatedExtensions = negotiatedExtensions;
            this.extensionContext = extensionContext;
            protocolHandler.setExtensionContext(extensionContext);
        }

        @Override
        public void handle(ByteBuffer data) {
            block11: {
                try {
                    if (data == null || !data.hasRemaining()) break block11;
                    if (this.buffer != null) {
                        data = Utils.appendBuffers(this.buffer, data, this.incomingBufferSize, 256);
                    } else {
                        int newSize = data.remaining();
                        if (newSize > this.incomingBufferSize) {
                            throw new IllegalArgumentException("Buffer overflow.");
                        }
                        int roundedSize = newSize % 256 > 0 ? (newSize / 256 + 1) * 256 : newSize;
                        ByteBuffer result = ByteBuffer.allocate(roundedSize > this.incomingBufferSize ? newSize : roundedSize);
                        result.flip();
                        data = Utils.appendBuffers(result, data, this.incomingBufferSize, 256);
                    }
                    while (true) {
                        Frame frame;
                        if ((frame = this.handler.unframe(data)) == null) {
                            this.buffer = data;
                            break;
                        }
                        for (Extension extension : this.negotiatedExtensions) {
                            if (!(extension instanceof ExtendedExtension)) continue;
                            try {
                                frame = ((ExtendedExtension)extension).processIncoming(this.extensionContext, frame);
                            }
                            catch (Throwable t) {
                                LOGGER.log(Level.FINE, String.format("Extension '%s' threw an exception during processIncoming method invocation: \"%s\".", extension.getName(), t.getMessage()), t);
                            }
                        }
                        this.handler.process(frame, this.socket);
                    }
                }
                catch (WebSocketException e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                    this.socket.onClose(new CloseFrame(e.getCloseReason()));
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                    this.socket.onClose(new CloseFrame(new CloseReason(CloseReason.CloseCodes.UNEXPECTED_CONDITION, e.getMessage())));
                }
            }
        }
    }

    public static interface ClientHandshakeListener {
        public void onSessionCreated(Session var1);

        public void onError(Throwable var1);
    }
}

