/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.crypto.provider.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.crypto.api.CryptoException;
import org.wso2.carbon.crypto.api.InternalCryptoProvider;
import org.wso2.carbon.crypto.api.KeyResolver;
import org.wso2.carbon.crypto.provider.ContextIndependentKeyResolver;
import org.wso2.carbon.crypto.provider.KeyStoreBasedInternalCryptoProvider;
import org.wso2.carbon.crypto.provider.SymmetricKeyInternalCryptoProvider;

@Component(name="org.wso2.carbon.crypto.provider", immediate=true)
public class DefaultCryptoProviderComponent {
    public static final String CRYPTO_SECRET_PROPERTY_PATH = "CryptoService.Secret";
    private static final Log log = LogFactory.getLog(DefaultCryptoProviderComponent.class);
    private static final String INTERNAL_KEYSTORE_FILE_PROPERTY_PATH = "Security.InternalKeyStore.Location";
    private static final String INTERNAL_KEYSTORE_TYPE_PROPERTY_PATH = "Security.InternalKeyStore.Type";
    private static final String INTERNAL_KEYSTORE_PASSWORD_PROPERTY_PATH = "Security.InternalKeyStore.Password";
    private static final String INTERNAL_KEYSTORE_KEY_ALIAS_PROPERTY_PATH = "Security.InternalKeyStore.KeyAlias";
    private static final String INTERNAL_KEYSTORE_KEY_PASSWORD_PROPERTY_PATH = "Security.InternalKeyStore.KeyPassword";
    private static final String CRYPTO_SERVICE_ENABLING_PROPERTY_PATH = "CryptoService.Enabled";
    private ServiceRegistration<InternalCryptoProvider> defaultInternalCryptoProviderRegistration;
    private ServiceRegistration<InternalCryptoProvider> symmetricKeyInternalCryptoProviderRegistration;
    private ServiceRegistration<KeyResolver> contextIndependentResolverRegistration;
    private ServerConfigurationService serverConfigurationService;

    @Activate
    public void activate(ComponentContext context) {
        try {
            BundleContext bundleContext = context.getBundleContext();
            if (this.isCryptoServiceEnabled()) {
                this.registerServiceImplementations(bundleContext);
            } else if (log.isInfoEnabled()) {
                log.debug((Object)"Crypto service is NOT enabled. Therefore the key resolver and crypto provider implementations will NOT be registered.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"'org.wso2.carbon.crypto.provider' bundle has been activated.");
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while activating 'org.wso2.carbon.crypto.provider' component.";
            log.error((Object)errorMessage, (Throwable)e);
        }
    }

    private void registerServiceImplementations(BundleContext bundleContext) throws CryptoException {
        InternalCryptoProvider defaultInternalCryptoProvider = this.getKeyStoreBasedInternalCryptoProviderFromServerConfiguration();
        SymmetricKeyInternalCryptoProvider symmetricKeyInternalCryptoProvider = this.getSymmetricKeyInternalCryptoProvider();
        KeyResolver contextIndependentKeyResolver = this.getContextIndependentKeyResolver();
        this.defaultInternalCryptoProviderRegistration = bundleContext.registerService(InternalCryptoProvider.class, (Object)defaultInternalCryptoProvider, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("'%s' has been registered as an implementation of '%s'", defaultInternalCryptoProvider.getClass().getCanonicalName(), InternalCryptoProvider.class.getCanonicalName()));
        }
        if (symmetricKeyInternalCryptoProvider != null) {
            this.symmetricKeyInternalCryptoProviderRegistration = bundleContext.registerService(InternalCryptoProvider.class, (Object)symmetricKeyInternalCryptoProvider, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("'%s' has been registered as an implementation of '%s'", symmetricKeyInternalCryptoProvider.getClass().getCanonicalName(), InternalCryptoProvider.class.getCanonicalName()));
            }
        }
        this.contextIndependentResolverRegistration = bundleContext.registerService(KeyResolver.class, (Object)contextIndependentKeyResolver, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("'%s' has been registered as an implementation of '%s'", contextIndependentKeyResolver.getClass().getCanonicalName(), KeyResolver.class.getCanonicalName()));
        }
    }

    private SymmetricKeyInternalCryptoProvider getSymmetricKeyInternalCryptoProvider() throws CryptoException {
        String secret = this.serverConfigurationService.getFirstProperty(CRYPTO_SECRET_PROPERTY_PATH);
        if (StringUtils.isBlank((String)secret)) {
            String infoMessage = String.format("'%s' property has not been set. '%s' won't be registered as an internal crypto provider. Please set the secret if the provider needs to be registered.", CRYPTO_SECRET_PROPERTY_PATH, SymmetricKeyInternalCryptoProvider.class.getCanonicalName());
            if (log.isInfoEnabled()) {
                log.info((Object)infoMessage);
            }
            return null;
        }
        return new SymmetricKeyInternalCryptoProvider(secret);
    }

    private KeyResolver getContextIndependentKeyResolver() {
        ContextIndependentKeyResolver contextIndependentKeyResolver = new ContextIndependentKeyResolver(this.serverConfigurationService);
        contextIndependentKeyResolver.setPriority(99);
        return contextIndependentKeyResolver;
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.defaultInternalCryptoProviderRegistration.unregister();
        if (this.symmetricKeyInternalCryptoProviderRegistration != null) {
            this.symmetricKeyInternalCryptoProviderRegistration.unregister();
        }
        this.contextIndependentResolverRegistration.unregister();
    }

    @Reference(name="serverConfigurationService", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, unbind="unsetServerConfigurationService")
    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = null;
    }

    private InternalCryptoProvider getKeyStoreBasedInternalCryptoProviderFromServerConfiguration() throws CryptoException {
        try {
            KeyStore keyStore = this.getInternalKeyStore();
            String keyAlias = this.getKeyStoreConfigurationPropertyOrFail(INTERNAL_KEYSTORE_KEY_ALIAS_PROPERTY_PATH);
            String keyPassword = this.getKeyStoreConfigurationPropertyOrFail(INTERNAL_KEYSTORE_KEY_PASSWORD_PROPERTY_PATH);
            return new KeyStoreBasedInternalCryptoProvider(keyStore, keyAlias, keyPassword);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            String errorMessage = "An error occurred while loading the internal keystore using the configurations in 'Security.InternalKeyStore' block.";
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    private boolean isCryptoServiceEnabled() {
        return StringUtils.isNotBlank((String)this.serverConfigurationService.getFirstProperty(CRYPTO_SERVICE_ENABLING_PROPERTY_PATH));
    }

    private KeyStore getInternalKeyStore() throws CryptoException, IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        FileInputStream keyStoreFileInputStream = null;
        try {
            String keyStoreFileName = this.getKeyStoreConfigurationPropertyOrFail(INTERNAL_KEYSTORE_FILE_PROPERTY_PATH);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Internal key store path : " + keyStoreFileName));
            }
            String file = new File(keyStoreFileName).getAbsolutePath();
            String password = this.getKeyStoreConfigurationPropertyOrFail(INTERNAL_KEYSTORE_PASSWORD_PROPERTY_PATH);
            keyStoreFileInputStream = new FileInputStream(file);
            String keyStoreType = this.getKeyStoreConfigurationPropertyOrFail(INTERNAL_KEYSTORE_TYPE_PROPERTY_PATH);
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(keyStoreFileInputStream, password.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (FileNotFoundException e) {
            String errorMessage = String.format("Internal keystore file does not exist in the path as configured in '%s' property.", INTERNAL_KEYSTORE_FILE_PROPERTY_PATH);
            throw new CryptoException(errorMessage);
        }
        finally {
            if (keyStoreFileInputStream != null) {
                try {
                    keyStoreFileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getKeyStoreConfigurationPropertyOrFail(String internalKeystorePropertyName) throws CryptoException {
        String propertyValue = this.serverConfigurationService.getFirstProperty(internalKeystorePropertyName);
        if (StringUtils.isBlank((String)propertyValue)) {
            throw new CryptoException(String.format("Could not find a non empty value for the property '%s'", internalKeystorePropertyName));
        }
        return propertyValue;
    }
}

