/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.crypto.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.crypto.api.CipherMetaDataHolder;
import org.wso2.carbon.crypto.api.CryptoException;
import org.wso2.carbon.crypto.api.InternalCryptoProvider;
import org.wso2.carbon.uuid.generator.UUIDGeneratorManager;

public class SymmetricKeyInternalCryptoProvider
implements InternalCryptoProvider {
    private static Log log = LogFactory.getLog(SymmetricKeyInternalCryptoProvider.class);
    private String secretKey;
    private static final String DEFAULT_SYMMETRIC_CRYPTO_ALGORITHM = "AES";
    private static final String AES_GCM_SYMMETRIC_CRYPTO_ALGORITHM = "AES/GCM/NoPadding";
    public static final int GCM_IV_LENGTH = 16;
    public static final int GCM_TAG_LENGTH = 128;

    public SymmetricKeyInternalCryptoProvider(String secretKey) {
        this.secretKey = secretKey;
    }

    public byte[] encrypt(byte[] cleartext, String algorithm, String javaSecurityAPIProvider) throws CryptoException {
        try {
            if (StringUtils.isBlank((String)algorithm)) {
                algorithm = AES_GCM_SYMMETRIC_CRYPTO_ALGORITHM;
            }
            Cipher cipher = StringUtils.isBlank((String)javaSecurityAPIProvider) ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, javaSecurityAPIProvider);
            cipher.init(1, this.getSecretKey());
            return cipher.doFinal(cleartext);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            String errorMessage = String.format("An error occurred while encrypting using the algorithm : '%s'", algorithm);
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    public byte[] decrypt(byte[] ciphertext, String algorithm, String javaSecurityAPIProvider) throws CryptoException {
        try {
            if (StringUtils.isBlank((String)algorithm)) {
                algorithm = AES_GCM_SYMMETRIC_CRYPTO_ALGORITHM;
            }
            Cipher cipher = StringUtils.isBlank((String)javaSecurityAPIProvider) ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, javaSecurityAPIProvider);
            if (AES_GCM_SYMMETRIC_CRYPTO_ALGORITHM.equals(algorithm)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Decrypting internal data with '%s' algorithm.", algorithm));
                }
                CipherMetaDataHolder cipherMetaDataHolder = this.getCipherMetaDataHolderFromCipherText(ciphertext);
                cipher.init(2, (Key)this.getSecretKey(), this.getGCMParameterSpec(cipherMetaDataHolder.getIvBase64Decoded()));
                if (cipherMetaDataHolder.getCipherBase64Decoded().length == 0) {
                    return "".getBytes();
                }
                return cipher.doFinal(cipherMetaDataHolder.getCipherBase64Decoded());
            }
            cipher.init(2, this.getSecretKey());
            return cipher.doFinal(ciphertext);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            String errorMessage = String.format("An error occurred while decrypting using the algorithm : '%s'", algorithm);
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    public byte[] encrypt(byte[] cleartext, String algorithm, String javaSecurityAPIProvider, boolean returnSelfContainedCipherText) throws CryptoException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Encrypting data with symmetric key encryption with algorithm: '%s'.", algorithm));
        }
        if (cleartext == null) {
            throw new CryptoException("Plaintext can't be null.");
        }
        if (AES_GCM_SYMMETRIC_CRYPTO_ALGORITHM.equals(algorithm)) {
            return this.encryptWithGCMMode(cleartext, javaSecurityAPIProvider, returnSelfContainedCipherText);
        }
        if (StringUtils.isNotBlank((String)algorithm) && cleartext.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Plaintext is empty. An empty array will be used as the ciphertext bytes.");
            }
            byte[] cipherText = "".getBytes();
            if (returnSelfContainedCipherText) {
                return this.createSelfContainedCiphertextWithPlainAES(cipherText, algorithm);
            }
            return cipherText;
        }
        if (returnSelfContainedCipherText) {
            byte[] cipherText = this.encrypt(cleartext, algorithm, javaSecurityAPIProvider);
            return this.createSelfContainedCiphertextWithPlainAES(cipherText, algorithm);
        }
        return this.encrypt(cleartext, algorithm, javaSecurityAPIProvider);
    }

    private SecretKeySpec getSecretKey() {
        return new SecretKeySpec(this.secretKey.getBytes(), 0, this.secretKey.getBytes().length, DEFAULT_SYMMETRIC_CRYPTO_ALGORITHM);
    }

    private byte[] getInitializationVector() {
        byte[] iv = new byte[16];
        UUID timeBasedUUID = UUIDGeneratorManager.getTimeBasedUUIDGenerator().generate();
        ByteBuffer byteBuffer = ByteBuffer.wrap(iv);
        byteBuffer.putLong(timeBasedUUID.getMostSignificantBits());
        byteBuffer.putLong(timeBasedUUID.getLeastSignificantBits());
        return byteBuffer.array();
    }

    private byte[] encryptWithGCMMode(byte[] plaintext, String javaSecurityAPIProvider, boolean returnSelfContainedCipherText) throws CryptoException {
        byte[] cipherText;
        if (!returnSelfContainedCipherText) {
            throw new CryptoException("Symmetric encryption with GCM mode only supports self contained cipher text generation.");
        }
        byte[] iv = this.getInitializationVector();
        try {
            Cipher cipher = StringUtils.isBlank((String)javaSecurityAPIProvider) ? Cipher.getInstance(AES_GCM_SYMMETRIC_CRYPTO_ALGORITHM) : Cipher.getInstance(AES_GCM_SYMMETRIC_CRYPTO_ALGORITHM, javaSecurityAPIProvider);
            cipher.init(1, (Key)this.getSecretKey(), this.getGCMParameterSpec(iv));
            if (plaintext.length == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Plaintext is empty. An empty array will be used as the ciphertext bytes.");
                }
                cipherText = "".getBytes();
            } else {
                cipherText = cipher.doFinal(plaintext);
            }
            cipherText = this.createSelfContainedCiphertextWithGCMMode(cipherText, AES_GCM_SYMMETRIC_CRYPTO_ALGORITHM, iv);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            String errorMessage = String.format("Error occurred while initializing and encrypting using Cipher object with algorithm: '%s'.", AES_GCM_SYMMETRIC_CRYPTO_ALGORITHM);
            throw new CryptoException(errorMessage, (Throwable)e);
        }
        return cipherText;
    }

    private GCMParameterSpec getGCMParameterSpec(byte[] iv) {
        return new GCMParameterSpec(128, iv);
    }

    private byte[] createSelfContainedCiphertextWithGCMMode(byte[] originalCipher, String transformation, byte[] iv) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        CipherMetaDataHolder cipherHolder = new CipherMetaDataHolder();
        cipherHolder.setCipherText(Base64.encode((byte[])cipherHolder.getSelfContainedCiphertextWithIv(originalCipher, iv)));
        cipherHolder.setTransformation(transformation);
        cipherHolder.setIv(Base64.encode((byte[])iv));
        String cipherWithMetadataStr = gson.toJson((Object)cipherHolder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cipher with meta data : " + cipherWithMetadataStr));
        }
        return cipherWithMetadataStr.getBytes(Charset.defaultCharset());
    }

    private byte[] createSelfContainedCiphertextWithPlainAES(byte[] originalCipher, String transformation) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        CipherMetaDataHolder cipherHolder = new CipherMetaDataHolder();
        cipherHolder.setCipherText(Base64.encode((byte[])originalCipher));
        cipherHolder.setTransformation(transformation);
        String cipherWithMetadataStr = gson.toJson((Object)cipherHolder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cipher with meta data: " + cipherWithMetadataStr));
        }
        return cipherWithMetadataStr.getBytes(Charset.defaultCharset());
    }

    private CipherMetaDataHolder getCipherMetaDataHolderFromCipherText(byte[] cipherTextBytes) {
        CipherMetaDataHolder cipherMetaDataHolder = new CipherMetaDataHolder();
        cipherMetaDataHolder.setIvAndOriginalCipherText(cipherTextBytes);
        return cipherMetaDataHolder;
    }
}

