/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.crypto.provider;

import com.google.gson.Gson;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.crypto.api.CipherMetaDataHolder;
import org.wso2.carbon.crypto.api.CryptoException;
import org.wso2.carbon.crypto.api.InternalCryptoProvider;

public class KeyStoreBasedInternalCryptoProvider
implements InternalCryptoProvider {
    private static Log log = LogFactory.getLog(KeyStoreBasedInternalCryptoProvider.class);
    private static final String DEFAULT_ASSYMETRIC_CRYPTO_ALGORITHM = "RSA";
    private static final String CIPHER_TRANSFORMATION_SYSTEM_PROPERTY = "org.wso2.CipherTransformation";
    private KeyStore keyStore;
    private String keyAlias;
    private String keyPassword;

    public KeyStoreBasedInternalCryptoProvider(KeyStore keyStore, String keyAlias, String keyPassword) {
        this.keyStore = keyStore;
        this.keyAlias = keyAlias;
        this.keyPassword = keyPassword;
    }

    public byte[] encrypt(byte[] cleartext, String algorithm, String javaSecurityAPIProvider) throws CryptoException {
        try {
            if (StringUtils.isBlank((String)algorithm)) {
                algorithm = DEFAULT_ASSYMETRIC_CRYPTO_ALGORITHM;
            }
            Cipher cipher = StringUtils.isBlank((String)javaSecurityAPIProvider) ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, javaSecurityAPIProvider);
            Certificate certificate = this.getCertificateFromStore();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Certificate used for encrypting : " + certificate));
            }
            cipher.init(1, certificate.getPublicKey());
            byte[] ciphertext = cipher.doFinal(cleartext);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Successfully encrypted data using the algorithm '%s' and the Java Security API provider '%s'", algorithm, javaSecurityAPIProvider));
            }
            return ciphertext;
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            String errorMessage = String.format("An error occurred while encrypting using the algorithm '%s' and the Java Security API provider '%s'", algorithm, javaSecurityAPIProvider);
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    public byte[] decrypt(byte[] ciphertext, String algorithm, String javaSecurityAPIProvider) throws CryptoException {
        try {
            if (StringUtils.isBlank((String)algorithm)) {
                algorithm = DEFAULT_ASSYMETRIC_CRYPTO_ALGORITHM;
            }
            Cipher cipher = StringUtils.isBlank((String)javaSecurityAPIProvider) ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, javaSecurityAPIProvider);
            cipher.init(2, this.getPrivateKeyFromKeyStore());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Successfully decrypted data using the algorithm '%s' and the Java Security API provider '%s'", algorithm, javaSecurityAPIProvider));
            }
            return cipher.doFinal(ciphertext);
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            String errorMessage = String.format("An error occurred while decrypting using the algorithm : '%s', and crypto provider : '%s'", algorithm, this.getClass().getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    public byte[] encrypt(byte[] cleartext, String algorithm, String javaSecurityAPIProvider, boolean returnSelfContainedCipherText) throws CryptoException {
        byte[] encryptedKey;
        if (cleartext == null) {
            throw new CryptoException("Plaintext can't be null.");
        }
        if (StringUtils.isNotBlank((String)algorithm) && cleartext.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Plaintext is empty. An empty array will be used as the ciphertext bytes.");
            }
            encryptedKey = "".getBytes();
        } else {
            encryptedKey = this.encrypt(cleartext, algorithm, javaSecurityAPIProvider);
        }
        if (returnSelfContainedCipherText) {
            Certificate certificate = null;
            try {
                certificate = this.getCertificateFromStore();
                encryptedKey = this.createSelfContainedCiphertext(encryptedKey, algorithm, certificate);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateEncodingException e) {
                String errorMessage = String.format("An error occurred while encrypting using the algorithm : '%s', and crypto provider : '%s'", algorithm, this.getClass().getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)errorMessage, (Throwable)e);
                }
                throw new CryptoException(errorMessage, (Throwable)e);
            }
        }
        return encryptedKey;
    }

    private Certificate getCertificateFromStore() throws KeyStoreException {
        return this.keyStore.getCertificate(this.keyAlias);
    }

    private PrivateKey getPrivateKeyFromKeyStore() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        Key key = this.keyStore.getKey(this.keyAlias, this.keyPassword.toCharArray());
        if (key instanceof PrivateKey) {
            return (PrivateKey)key;
        }
        return null;
    }

    private byte[] createSelfContainedCiphertext(byte[] originalCipher, String transformation, Certificate certificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        Gson gson = new Gson();
        CipherMetaDataHolder cipherHolder = new CipherMetaDataHolder();
        cipherHolder.setCipherText(Base64.encode((byte[])originalCipher));
        cipherHolder.setTransformation(transformation);
        cipherHolder.setThumbPrint(this.calculateThumbprint(certificate, "SHA-1"), "SHA-1");
        String cipherWithMetadataStr = gson.toJson((Object)cipherHolder);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cipher with meta data : " + cipherWithMetadataStr));
        }
        return cipherWithMetadataStr.getBytes(Charset.defaultCharset());
    }

    private String calculateThumbprint(Certificate certificate, String digest) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance(digest);
        messageDigest.update(certificate.getEncoded());
        byte[] digestByteArray = messageDigest.digest();
        char[] hexCharacters = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < digestByteArray.length; ++i) {
            int leftNibble = (digestByteArray[i] & 0xF0) >> 4;
            int rightNibble = digestByteArray[i] & 0xF;
            strBuffer.append(hexCharacters[leftNibble]).append(hexCharacters[rightNibble]);
        }
        return strBuffer.toString();
    }
}

