/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.crypto.provider;

import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.crypto.api.CertificateInfo;
import org.wso2.carbon.crypto.api.CryptoContext;
import org.wso2.carbon.crypto.api.KeyResolver;
import org.wso2.carbon.crypto.api.PrivateKeyInfo;

public class ContextIndependentKeyResolver
extends KeyResolver {
    private static final String PRIMARY_KEYSTORE_KEY_ALIAS_PROPERTY_PATH = "Security.KeyStore.KeyAlias";
    private static final String PRIMARY_KEYSTORE_KEY_PASSWORD_PROPERTY_PATH = "Security.KeyStore.KeyPassword";
    private ServerConfigurationService serverConfigurationService;

    public ContextIndependentKeyResolver(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public boolean isApplicable(CryptoContext cryptoContext) {
        return true;
    }

    public PrivateKeyInfo getPrivateKeyInfo(CryptoContext cryptoContext) {
        String keyPassword;
        String keyAlias;
        if (-1234 == cryptoContext.getTenantId()) {
            keyAlias = this.serverConfigurationService.getFirstProperty(PRIMARY_KEYSTORE_KEY_ALIAS_PROPERTY_PATH);
            keyPassword = this.serverConfigurationService.getFirstProperty(PRIMARY_KEYSTORE_KEY_PASSWORD_PROPERTY_PATH);
        } else {
            keyAlias = cryptoContext.getTenantDomain();
            keyPassword = null;
        }
        return new PrivateKeyInfo(keyAlias, keyPassword);
    }

    public CertificateInfo getCertificateInfo(CryptoContext cryptoContext) {
        String certificateAlias = -1234 == cryptoContext.getTenantId() ? this.serverConfigurationService.getFirstProperty(PRIMARY_KEYSTORE_KEY_ALIAS_PROPERTY_PATH) : cryptoContext.getTenantDomain();
        return new CertificateInfo(certificateAlias, null);
    }
}

