/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.secret.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.BaseCipher;
import org.wso2.securevault.CipherFactory;
import org.wso2.securevault.CipherOperationMode;
import org.wso2.securevault.EncodingType;
import org.wso2.securevault.commons.MiscellaneousUtil;
import org.wso2.securevault.definition.CipherInformation;
import org.wso2.securevault.keystore.IdentityKeyStoreWrapper;
import org.wso2.securevault.keystore.KeyStoreWrapper;
import org.wso2.securevault.keystore.TrustKeyStoreWrapper;
import org.wso2.securevault.secret.SecretRepository;

public class FileBaseSecretRepository
implements SecretRepository {
    private static Log log = LogFactory.getLog(FileBaseSecretRepository.class);
    private static final String LOCATION = "location";
    private static final String KEY_STORE = "keyStore";
    private static final String DOT = ".";
    private static final String ALGORITHM = "algorithm";
    private static final String DEFAULT_ALGORITHM = "RSA";
    private static final String TRUSTED = "trusted";
    private static final String DEFAULT_CONF_LOCATION = "cipher-text.properties";
    private SecretRepository parentRepository;
    private final Map<String, String> secrets = new HashMap<String, String>();
    private final Map<String, String> encryptedData = new HashMap<String, String>();
    private IdentityKeyStoreWrapper identity;
    private TrustKeyStoreWrapper trust;
    private boolean initialize = false;

    public FileBaseSecretRepository(IdentityKeyStoreWrapper identity, TrustKeyStoreWrapper trust) {
        this.identity = identity;
        this.trust = trust;
    }

    @Override
    public void init(Properties properties, String id) {
        String sb = id + DOT + LOCATION;
        String filePath = MiscellaneousUtil.getProperty(properties, sb, DEFAULT_CONF_LOCATION);
        Properties cipherProperties = MiscellaneousUtil.loadProperties(filePath);
        if (cipherProperties.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cipher texts cannot be loaded form : " + filePath));
            }
            return;
        }
        String sbTwo = id + DOT + ALGORITHM;
        String algorithm = MiscellaneousUtil.getProperty(properties, sbTwo, DEFAULT_ALGORITHM);
        String buffer = ".keyStore";
        String keyStore = MiscellaneousUtil.getProperty(properties, buffer, null);
        KeyStoreWrapper keyStoreWrapper = TRUSTED.equals(keyStore) ? this.trust : this.identity;
        CipherInformation cipherInformation = new CipherInformation();
        cipherInformation.setAlgorithm(algorithm);
        cipherInformation.setCipherOperationMode(CipherOperationMode.DECRYPT);
        cipherInformation.setInType(EncodingType.BASE64);
        BaseCipher baseCipher = CipherFactory.createCipher(cipherInformation, keyStoreWrapper);
        for (Object alias : cipherProperties.keySet()) {
            String key = String.valueOf(alias);
            String encryptedText = cipherProperties.getProperty(key);
            this.encryptedData.put(key, encryptedText);
            if (encryptedText == null || "".equals(encryptedText.trim())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("There is no secret for the alias : " + alias));
                continue;
            }
            String decryptedText = new String(baseCipher.decrypt(encryptedText.trim().getBytes()));
            this.secrets.put(key, decryptedText);
        }
        this.initialize = true;
    }

    @Override
    public String getSecret(String alias) {
        if (alias == null || "".equals(alias)) {
            return alias;
        }
        if (!this.initialize || this.secrets.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no secret found for alias '" + alias + "' returning itself"));
            }
            return alias;
        }
        String secret = this.secrets.get(alias);
        if (secret == null || "".equals(secret)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no secret found for alias '" + alias + "' returning itself"));
            }
            return alias;
        }
        return secret;
    }

    @Override
    public String getEncryptedData(String alias) {
        if (alias == null || "".equals(alias)) {
            return alias;
        }
        if (!this.initialize || this.encryptedData.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no secret found for alias '" + alias + "' returning itself"));
            }
            return alias;
        }
        String encryptedValue = this.encryptedData.get(alias);
        if (encryptedValue == null || "".equals(encryptedValue)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no secret found for alias '" + alias + "' returning itself"));
            }
            return alias;
        }
        return encryptedValue;
    }

    @Override
    public void setParent(SecretRepository parent) {
        this.parentRepository = parent;
    }

    @Override
    public SecretRepository getParent() {
        return this.parentRepository;
    }
}

