/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.registry.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.registry.RegistryHostObjectContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="hostobjects.registry.dscomponent", immediate=true)
public class RegistryHostObjectServiceComponent {
    private static final Log log = LogFactory.getLog(RegistryHostObjectServiceComponent.class);

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Registry Service to RegistryHostObjectContext");
        }
        RegistryHostObjectContext.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Registry Service");
        }
        RegistryHostObjectContext.setRegistryService(null);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) throws CarbonException {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Realm Service to RegistryHostObjectContext");
        }
        RegistryHostObjectContext.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) throws CarbonException {
        RegistryHostObjectContext.setRealmService(null);
    }
}

