/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceStub;
import org.wso2.carbon.tenant.mgt.stub.beans.xsd.PaginatedTenantInfoBean;
import org.wso2.carbon.tenant.mgt.stub.beans.xsd.TenantInfoBean;
import org.wso2.carbon.ui.CarbonUIUtil;

public class TenantServiceClient {
    private static final Log log = LogFactory.getLog(TenantServiceClient.class);
    private TenantMgtAdminServiceStub stub;

    public TenantServiceClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        String epr = backendServerURL + "TenantMgtAdminService";
        try {
            this.stub = new TenantMgtAdminServiceStub(configContext, epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate AddServices service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public TenantServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String epr = backendServerURL + "TenantMgtAdminService";
        try {
            this.stub = new TenantMgtAdminServiceStub(configContext, epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate Add Services service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public void addTenant(TenantInfoBean tenantInfoBean) throws Exception {
        this.stub.addTenant(tenantInfoBean);
    }

    public TenantInfoBean[] retrieveTenants() throws Exception {
        return this.stub.retrieveTenants();
    }

    public PaginatedTenantInfoBean retrievePaginatedTenants(int pageNumber) throws Exception {
        return this.stub.retrievePaginatedTenants(pageNumber);
    }

    public PaginatedTenantInfoBean retrievePaginatedPartialSearchTenants(String domain, int pageNumber) throws Exception {
        return this.stub.retrievePaginatedPartialSearchTenants(domain, pageNumber);
    }

    public TenantInfoBean getTenant(String domainName) throws Exception {
        return this.stub.getTenant(domainName);
    }

    public void updateTenant(TenantInfoBean tenantInfoBean) throws Exception {
        this.stub.updateTenant(tenantInfoBean);
    }

    public void activateTenant(String domainName) throws Exception {
        this.stub.activateTenant(domainName);
    }

    public void deactivateTenant(String domainName) throws Exception {
        this.stub.deactivateTenant(domainName);
    }
}

