/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.sharedmemory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheConfiguration;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.sharedmemory.SubscriptionContainer;
import org.wso2.carbon.event.core.sharedmemory.util.SharedMemoryCacheConstants;
import org.wso2.carbon.event.core.sharedmemory.util.SharedMemoryCacheUtil;
import org.wso2.carbon.event.core.subscription.Subscription;

@Deprecated
public class SharedMemorySubscriptionStorage
implements Serializable {
    private static boolean topicSubscriptionCacheInit = false;
    private static boolean tenantIDInMemorySubscriptionStorageCacheInit = false;
    private static final Log log = LogFactory.getLog(SharedMemorySubscriptionStorage.class);

    public static Cache<String, SubscriptionContainer> getTopicSubscriptionCache() {
        if (topicSubscriptionCacheInit) {
            return Caching.getCacheManagerFactory().getCacheManager("inMemoryEventCacheManager").getCache("topicSubscriptionCache");
        }
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager("inMemoryEventCacheManager");
        topicSubscriptionCacheInit = true;
        return cacheManager.createCacheBuilder("topicSubscriptionCache").setExpiry(CacheConfiguration.ExpiryType.MODIFIED, new CacheConfiguration.Duration(TimeUnit.SECONDS, (long)SharedMemoryCacheConstants.CACHE_INVALIDATION_TIME.intValue())).setExpiry(CacheConfiguration.ExpiryType.ACCESSED, new CacheConfiguration.Duration(TimeUnit.SECONDS, (long)SharedMemoryCacheConstants.CACHE_INVALIDATION_TIME.intValue())).setStoreByValue(false).build();
    }

    public static Cache<String, String> getSubscriptionIDTopicNameCache() {
        if (tenantIDInMemorySubscriptionStorageCacheInit) {
            return Caching.getCacheManagerFactory().getCacheManager("inMemoryEventCacheManager").getCache("subscriptionIDTopicNameCache");
        }
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager("inMemoryEventCacheManager");
        tenantIDInMemorySubscriptionStorageCacheInit = true;
        return cacheManager.createCacheBuilder("subscriptionIDTopicNameCache").setExpiry(CacheConfiguration.ExpiryType.MODIFIED, new CacheConfiguration.Duration(TimeUnit.SECONDS, (long)SharedMemoryCacheConstants.CACHE_INVALIDATION_TIME.intValue())).setExpiry(CacheConfiguration.ExpiryType.ACCESSED, new CacheConfiguration.Duration(TimeUnit.SECONDS, (long)SharedMemoryCacheConstants.CACHE_INVALIDATION_TIME.intValue())).setStoreByValue(false).build();
    }

    public void addSubscription(Subscription subscription) {
        String topicName = this.getTopicName(subscription.getTopicName());
        SubscriptionContainer subscriptionsContainer = (SubscriptionContainer)SharedMemorySubscriptionStorage.getTopicSubscriptionCache().get((Object)topicName);
        if (subscriptionsContainer == null) {
            subscriptionsContainer = new SubscriptionContainer(topicName);
        }
        subscriptionsContainer.getSubscriptionsCache().put((Object)subscription.getId(), (Object)subscription);
        SharedMemorySubscriptionStorage.getTopicSubscriptionCache().put((Object)topicName, (Object)subscriptionsContainer);
        SharedMemorySubscriptionStorage.getSubscriptionIDTopicNameCache().put((Object)subscription.getId(), (Object)topicName);
        try {
            SharedMemoryCacheUtil.sendAddSubscriptionClusterMessage(topicName, subscription.getId(), subscription.getTenantId(), subscription.getTenantDomain());
        }
        catch (ClusteringFault e) {
            log.error((Object)"Subscription cluster message sending failed", (Throwable)e);
        }
    }

    public List<Subscription> getMatchingSubscriptions(String topicName) {
        topicName = this.getTopicName(topicName);
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        List<String> matchingTopicNames = this.getTopicMatchingNames(topicName);
        for (String matchingTopicName : matchingTopicNames) {
            if (SharedMemorySubscriptionStorage.getTopicSubscriptionCache().get((Object)matchingTopicName) == null) continue;
            SubscriptionContainer matchingContainer = (SubscriptionContainer)SharedMemorySubscriptionStorage.getTopicSubscriptionCache().get((Object)matchingTopicName);
            Iterator keysOfSubscription = matchingContainer.getSubscriptionsCache().keys();
            while (keysOfSubscription.hasNext()) {
                String key = (String)keysOfSubscription.next();
                subscriptions.add((Subscription)matchingContainer.getSubscriptionsCache().get((Object)key));
            }
        }
        return subscriptions;
    }

    public void unSubscribe(String subscriptionID) throws EventBrokerException {
        String topicName = this.getTopicName((String)SharedMemorySubscriptionStorage.getSubscriptionIDTopicNameCache().get((Object)subscriptionID));
        if (topicName == null) {
            throw new EventBrokerException("Subscription with ID " + subscriptionID + " does not exits");
        }
        SubscriptionContainer subscriptionContainer = (SubscriptionContainer)SharedMemorySubscriptionStorage.getTopicSubscriptionCache().get((Object)topicName);
        if (subscriptionContainer == null) {
            throw new EventBrokerException("Subscription with ID " + subscriptionID + " does not exits");
        }
        subscriptionContainer.getSubscriptionsCache().remove((Object)subscriptionID);
        SharedMemorySubscriptionStorage.getSubscriptionIDTopicNameCache().remove((Object)subscriptionID);
    }

    public void renewSubscription(Subscription subscription) throws EventBrokerException {
        String topicName = this.getTopicName(subscription.getTopicName());
        SubscriptionContainer subscriptionContainer = (SubscriptionContainer)SharedMemorySubscriptionStorage.getTopicSubscriptionCache().get((Object)topicName);
        if (subscriptionContainer == null) {
            throw new EventBrokerException("There is no subscriptions with topic " + topicName);
        }
        Subscription existingSubscription = (Subscription)subscriptionContainer.getSubscriptionsCache().get((Object)subscription.getId());
        if (existingSubscription == null) {
            throw new EventBrokerException("There is no subscription with subscription id " + subscription.getId());
        }
        existingSubscription.setExpires(subscription.getExpires());
        existingSubscription.setProperties(subscription.getProperties());
        String val = subscription.getProperties().get("notVerfied");
        if (val == null) {
            SharedMemorySubscriptionStorage.getSubscriptionIDTopicNameCache().put((Object)(subscription.getId() + "-notVerfied"), (Object)"false");
        } else if ("true".equalsIgnoreCase(val)) {
            SharedMemorySubscriptionStorage.getSubscriptionIDTopicNameCache().put((Object)(subscription.getId() + "-notVerfied"), (Object)"true");
        } else {
            SharedMemorySubscriptionStorage.getSubscriptionIDTopicNameCache().put((Object)(subscription.getId() + "-notVerfied"), (Object)"false");
        }
    }

    private List<String> getTopicMatchingNames(String topicName) {
        ArrayList<String> matchingTopicNames = new ArrayList<String>();
        if (topicName.equals("/")) {
            matchingTopicNames.add("/#");
        } else {
            String currentTopicName = "";
            String[] topicParts = topicName.split("/");
            for (int i = 0; i < topicParts.length; ++i) {
                currentTopicName = currentTopicName + topicParts[i] + "/";
                matchingTopicNames.add(currentTopicName + "#");
                if (i != topicParts.length - 1 && i != topicParts.length - 2) continue;
                matchingTopicNames.add(currentTopicName + "*");
            }
        }
        matchingTopicNames.add(topicName);
        return matchingTopicNames;
    }

    private String getTopicName(String topicName) {
        if (!topicName.startsWith("/")) {
            topicName = "/" + topicName;
        }
        if (topicName.endsWith("/") && topicName.length() != 1) {
            topicName = topicName.substring(0, topicName.lastIndexOf(47));
        }
        return topicName;
    }
}

