/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.sharedmemory;

import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.cache.Cache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.event.core.Message;
import org.wso2.carbon.event.core.delivery.DeliveryManager;
import org.wso2.carbon.event.core.delivery.MatchingManager;
import org.wso2.carbon.event.core.exception.EventBrokerConfigurationException;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.internal.delivery.Worker;
import org.wso2.carbon.event.core.internal.util.EventBrokerHolder;
import org.wso2.carbon.event.core.internal.util.JavaUtil;
import org.wso2.carbon.event.core.notify.NotificationManager;
import org.wso2.carbon.event.core.sharedmemory.SharedMemoryMatchingManager;
import org.wso2.carbon.event.core.sharedmemory.SharedMemorySubscriptionStorage;
import org.wso2.carbon.event.core.sharedmemory.util.SharedMemoryCacheUtil;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;

@Deprecated
public class SharedMemoryDeliveryManager
implements DeliveryManager {
    private static final Log log = LogFactory.getLog(SharedMemoryDeliveryManager.class);
    private ExecutorService executor;
    private NotificationManager notificationManager;
    private String topicStoragePath;
    private EventBroker eventBroker;

    public SharedMemoryDeliveryManager(ExecutorService executor, String topicStoragePath) {
        this.executor = executor;
        this.topicStoragePath = topicStoragePath;
    }

    @Override
    public void subscribe(Subscription subscription) throws EventBrokerException {
        String resourcePath = JavaUtil.getResourcePath(subscription.getTopicName(), this.topicStoragePath);
        try {
            UserRealm userRealm = EventBrokerHolder.getInstance().getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId());
            String userName = subscription.getOwner();
            if (userName.lastIndexOf("@") != -1) {
                userName = userName.substring(0, userName.lastIndexOf("@"));
            }
            if (!userName.equals("wso2.system.user") && !userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, "subscribe")) {
                throw new EventBrokerException("User " + CarbonContext.getThreadLocalCarbonContext().getUsername() + " is not allowed to subscribes to " + subscription.getTopicName());
            }
            this.getMatchingManager().addSubscription(subscription);
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Can not access the user store manager", e);
        }
    }

    @Override
    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @Override
    public void publish(Message message, String topicName, int deliveryMode) throws EventBrokerException {
        block6: {
            String resourcePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            try {
                UserRealm userRealm = EventBrokerHolder.getInstance().getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId());
                String userName = CarbonContext.getThreadLocalCarbonContext().getUsername();
                if (userName == null) {
                    userName = "wso2.system.user";
                }
                if (userName.equals("wso2.system.user") || userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, "publish")) {
                    List<Subscription> subscriptions = this.getMatchingManager().getMatchingSubscriptions(topicName);
                    for (Subscription subscription : subscriptions) {
                        String verified = (String)SharedMemorySubscriptionStorage.getSubscriptionIDTopicNameCache().get((Object)(subscription.getId() + "-notVerfied"));
                        if (verified != null && "false".equalsIgnoreCase(verified)) {
                            subscription.addProperty("notVerfied", "false");
                        }
                        this.executor.submit(new Worker(this.notificationManager, message, subscription));
                    }
                    break block6;
                }
                throw new EventBrokerException("User " + CarbonContext.getThreadLocalCarbonContext().getUsername() + " is not allowed to publish to " + topicName);
            }
            catch (UserStoreException e) {
                throw new EventBrokerException("Can not access the user store manager", e);
            }
        }
    }

    public void setMatchingManager(MatchingManager matchingManager) {
    }

    @Override
    public void unSubscribe(String id) throws EventBrokerException {
        this.getMatchingManager().unSubscribe(id);
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void renewSubscription(Subscription subscription) throws EventBrokerException {
        this.getMatchingManager().renewSubscription(subscription);
    }

    @Override
    public void initializeTenant() throws EventBrokerException {
        this.getMatchingManager().initializeTenant();
    }

    private static Cache<Integer, SharedMemoryMatchingManager> getInMemoryMatchingCache() {
        return SharedMemoryCacheUtil.getInMemoryMatchingCache();
    }

    public synchronized MatchingManager getMatchingManager() throws EventBrokerConfigurationException {
        SharedMemoryMatchingManager inMemoryMatchingManager = (SharedMemoryMatchingManager)SharedMemoryDeliveryManager.getInMemoryMatchingCache().get((Object)1);
        if (inMemoryMatchingManager == null) {
            inMemoryMatchingManager = new SharedMemoryMatchingManager();
            SharedMemoryDeliveryManager.getInMemoryMatchingCache().put((Object)1, (Object)inMemoryMatchingManager);
        }
        try {
            inMemoryMatchingManager.initializeTenant();
        }
        catch (EventBrokerException e) {
            throw new EventBrokerConfigurationException("Can not initialize the in memory mathing manager", e);
        }
        return inMemoryMatchingManager;
    }

    public void setEventBroker(EventBroker eventbroker) {
        this.eventBroker = eventbroker;
    }
}

