/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.delivery.inmemory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.subscription.Subscription;

@Deprecated
public class InMemorySubscriptionStorage {
    private Map<String, Map<String, Subscription>> topicSubscriptionMap = new ConcurrentHashMap<String, Map<String, Subscription>>();
    private Map<String, String> subscriptionIDTopicNameMap = new ConcurrentHashMap<String, String>();

    public void addSubscription(Subscription subscription) {
        String topicName = this.getTopicName(subscription.getTopicName());
        Map<String, Subscription> subscriptionsMap = this.topicSubscriptionMap.get(topicName);
        if (subscriptionsMap == null) {
            subscriptionsMap = new ConcurrentHashMap<String, Subscription>();
            this.topicSubscriptionMap.put(topicName, subscriptionsMap);
        }
        subscriptionsMap.put(subscription.getId(), subscription);
        this.subscriptionIDTopicNameMap.put(subscription.getId(), topicName);
    }

    public List<Subscription> getMatchingSubscriptions(String topicName) {
        topicName = this.getTopicName(topicName);
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        List<String> matchingTopicNames = this.getTopicMatchingNames(topicName);
        for (String matchingTopicName : matchingTopicNames) {
            if (this.topicSubscriptionMap.get(matchingTopicName) == null) continue;
            subscriptions.addAll(this.topicSubscriptionMap.get(matchingTopicName).values());
        }
        return subscriptions;
    }

    public void unSubscribe(String subscriptionID) throws EventBrokerException {
        String topicName = this.getTopicName(this.subscriptionIDTopicNameMap.get(subscriptionID));
        if (topicName == null) {
            throw new EventBrokerException("Subscription with ID " + subscriptionID + " does not exits");
        }
        Map<String, Subscription> subscriptionsMap = this.topicSubscriptionMap.get(topicName);
        if (subscriptionsMap == null) {
            throw new EventBrokerException("Subscription with ID " + subscriptionID + " does not exits");
        }
        subscriptionsMap.remove(subscriptionID);
        this.subscriptionIDTopicNameMap.remove(subscriptionID);
    }

    public void renewSubscription(Subscription subscription) throws EventBrokerException {
        String topicName = this.getTopicName(subscription.getTopicName());
        Map<String, Subscription> subscriptionsMap = this.topicSubscriptionMap.get(topicName);
        if (subscriptionsMap == null) {
            throw new EventBrokerException("There is no subscriptions with topic " + topicName);
        }
        Subscription existingSubscription = subscriptionsMap.get(subscription.getId());
        if (existingSubscription == null) {
            throw new EventBrokerException("There is no subscription with subscription id " + subscription.getId());
        }
        existingSubscription.setExpires(subscription.getExpires());
        existingSubscription.setProperties(subscription.getProperties());
    }

    private List<String> getTopicMatchingNames(String topicName) {
        ArrayList<String> matchingTopicNames = new ArrayList<String>();
        if (topicName.equals("/")) {
            matchingTopicNames.add("/#");
        } else {
            String currentTopicName = "";
            String[] topicParts = topicName.split("/");
            for (int i = 0; i < topicParts.length; ++i) {
                currentTopicName = currentTopicName + topicParts[i] + "/";
                matchingTopicNames.add(currentTopicName + "#");
                if (i != topicParts.length - 1 && i != topicParts.length - 2) continue;
                matchingTopicNames.add(currentTopicName + "*");
            }
        }
        matchingTopicNames.add(topicName);
        return matchingTopicNames;
    }

    private String getTopicName(String topicName) {
        if (!topicName.startsWith("/")) {
            topicName = "/" + topicName;
        }
        if (topicName.endsWith("/") && topicName.length() != 1) {
            topicName = topicName.substring(0, topicName.lastIndexOf("/"));
        }
        return topicName;
    }
}

