/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal;

import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.axiom.util.UIDGenerator;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.event.core.Message;
import org.wso2.carbon.event.core.delivery.DeliveryManager;
import org.wso2.carbon.event.core.exception.EventBrokerConfigurationException;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.internal.EventPublisher;
import org.wso2.carbon.event.core.internal.notify.CarbonNotificationManager;
import org.wso2.carbon.event.core.internal.util.EventBrokerHolder;
import org.wso2.carbon.event.core.subscription.EventDispatcher;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.event.core.subscription.SubscriptionManager;
import org.wso2.carbon.event.core.topic.TopicManager;
import org.wso2.carbon.user.api.UserStoreException;

@Deprecated
public class CarbonEventBroker
implements EventBroker {
    private SubscriptionManager subscriptionManager;
    private TopicManager topicManager;
    private DeliveryManager deliveryManager;
    private CarbonNotificationManager notificationManager;
    private ExecutorService executor;

    public void init() throws EventBrokerConfigurationException {
        this.notificationManager = new CarbonNotificationManager();
        this.deliveryManager.setNotificationManager(this.notificationManager);
        this.loadExistingSubscriptions();
    }

    private void loadExistingSubscriptions() throws EventBrokerConfigurationException {
        try {
            Calendar calendar = Calendar.getInstance();
            for (Subscription subscription : this.subscriptionManager.getAllSubscriptions()) {
                if (subscription.getExpires() != null && !calendar.before(subscription.getExpires())) continue;
                if (EventBrokerHolder.getInstance().getTenantDomain() != null) {
                    subscription.setTenantDomain(EventBrokerHolder.getInstance().getTenantDomain());
                    subscription.setTenantId(EventBrokerHolder.getInstance().getTenantId());
                }
                this.deliveryManager.subscribe(subscription);
            }
        }
        catch (EventBrokerException e) {
            throw new EventBrokerConfigurationException("Cannot get the subscriptions ", e);
        }
    }

    @Override
    public void initializeTenant() throws EventBrokerException, UserStoreException {
        this.deliveryManager.initializeTenant();
        this.loadExistingSubscriptions();
    }

    @Override
    public String subscribe(Subscription subscription) throws EventBrokerException {
        Subscription existingSubscription = this.getExistingNonExpiredSubscription(subscription);
        if (existingSubscription != null) {
            return existingSubscription.getId();
        }
        if (EventBrokerHolder.getInstance().getTenantDomain() != null) {
            subscription.setTenantDomain(EventBrokerHolder.getInstance().getTenantDomain());
            subscription.setTenantId(EventBrokerHolder.getInstance().getTenantId());
        }
        subscription.setId(UIDGenerator.generateUID());
        this.topicManager.addTopic(subscription.getTopicName());
        this.deliveryManager.subscribe(subscription);
        if (subscription.getEventDispatcherName() != null) {
            this.subscriptionManager.addSubscription(subscription);
        } else if (subscription.getEventDispatcher() == null) {
            throw new EventBrokerException(" subscription url, event dispatcher name and event dispatcher is null");
        }
        return subscription.getId();
    }

    private Subscription getExistingNonExpiredSubscription(Subscription newSubscription) throws EventBrokerException {
        Subscription[] subscriptions = this.topicManager.getSubscriptions(newSubscription.getTopicName(), false);
        Subscription existingSubscription = null;
        Calendar calendar = Calendar.getInstance();
        for (Subscription subscription : subscriptions) {
            if (subscription.getEventSinkURL() == null || !subscription.getEventSinkURL().equalsIgnoreCase(newSubscription.getEventSinkURL()) || subscription.getExpires() != null && !calendar.before(subscription.getExpires())) continue;
            existingSubscription = subscription;
            break;
        }
        return existingSubscription;
    }

    @Override
    public void unsubscribe(String id) throws EventBrokerException {
        this.subscriptionManager.unSubscribe(id);
        this.deliveryManager.unSubscribe(id);
    }

    @Override
    public Subscription getSubscription(String id) throws EventBrokerException {
        return this.subscriptionManager.getSubscription(id);
    }

    @Override
    public void renewSubscription(Subscription subscription) throws EventBrokerException {
        this.subscriptionManager.renewSubscription(subscription);
        this.deliveryManager.renewSubscription(subscription);
    }

    @Override
    public List<Subscription> getAllSubscriptions(String filter) throws EventBrokerException {
        return this.subscriptionManager.getAllSubscriptions();
    }

    @Override
    public void publish(Message message, String topicName) throws EventBrokerException {
        this.publish(message, topicName, 1);
    }

    @Override
    public void publish(Message message, String topicName, int deliveryMode) throws EventBrokerException {
        EventPublisher eventPublisher = new EventPublisher(message, topicName, this.deliveryManager, deliveryMode, CarbonContext.getThreadLocalCarbonContext().getTenantId());
        this.executor.execute(eventPublisher);
    }

    @Override
    public void publishRobust(Message message, String topicName) throws EventBrokerException {
        this.publishRobust(message, topicName, 1);
    }

    @Override
    public void publishRobust(Message message, String topicName, int deliveryMode) throws EventBrokerException {
        this.deliveryManager.publish(message, topicName, deliveryMode);
    }

    @Override
    public void registerEventDispatcher(String eventDispatcherName, EventDispatcher eventDispatcher) {
        this.notificationManager.registerEventDispatcher(eventDispatcherName, eventDispatcher);
    }

    public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    @Override
    public TopicManager getTopicManager() {
        return this.topicManager;
    }

    public void setTopicManager(TopicManager topicManager) {
        this.topicManager = topicManager;
    }

    public void setDeliveryManager(DeliveryManager deliveryManager) {
        this.deliveryManager = deliveryManager;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void cleanUp() throws EventBrokerException {
        this.deliveryManager.cleanUp();
    }
}

