/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.valve;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.utils.CarbonUtils;

public class XSSValve
extends ValveBase {
    private static String XSS_VALVE_PROPERTY = "Security.XSSPreventionConfig";
    private static String ENABLED_PROPERTY = XSS_VALVE_PROPERTY + ".Enabled";
    private static String RULE_PATTERN_PROPERTY = XSS_VALVE_PROPERTY + ".Patterns.Pattern";
    private static String RULE_PROPERTY = XSS_VALVE_PROPERTY + ".Rule";
    private static String XSS_EXTENSION_FILE_NAME = "xss-patterns.properties";
    private static boolean xssEnabled = false;
    private static String RULE_ALLOW = "allow";
    private static String RULE_DENY = "deny";
    private static String[] xssURIPatternList;
    private static String xssRule;
    private static String patterPath;
    private static ArrayList<Pattern> patternList;
    private static final Log log;

    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        if (serverConfiguration.getFirstProperty(ENABLED_PROPERTY) != null && Boolean.parseBoolean(serverConfiguration.getFirstProperty(ENABLED_PROPERTY))) {
            xssEnabled = true;
        }
        xssURIPatternList = serverConfiguration.getProperties(RULE_PATTERN_PROPERTY);
        xssRule = serverConfiguration.getFirstProperty(RULE_PROPERTY);
        patterPath = CarbonUtils.getCarbonSecurityConfigDirPath() + "/" + XSS_EXTENSION_FILE_NAME;
        this.buildScriptPatterns();
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (xssEnabled) {
            String context = request.getRequestURI().substring(request.getRequestURI().indexOf("/") + 1);
            if (RULE_ALLOW.equals(xssRule) && !this.isContextStartWithGivenPatterns(context)) {
                this.validateParameters(request);
            } else if (RULE_DENY.equals(xssRule) && this.isContextStartWithGivenPatterns(context)) {
                this.validateParameters(request);
            } else if (!RULE_ALLOW.equals(xssRule) && !RULE_DENY.equals(xssRule)) {
                this.validateParameters(request);
            }
        }
        this.getNext().invoke(request, response);
    }

    private void validateParameters(Request request) throws ServletException {
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            String paramValue = request.getParameter(paramName);
            if (paramValue == null) continue;
            paramValue = paramValue.replaceAll("\u0000", "");
            for (Pattern scriptPattern : patternList) {
                Matcher matcher = scriptPattern.matcher(paramValue);
                if (!matcher.find()) continue;
                throw new ServletException("Possible XSS Attack. Suspicious code : " + matcher.toMatchResult().group());
            }
        }
    }

    private boolean isContextStartWithGivenPatterns(String context) {
        boolean patternMatched = false;
        for (String pattern : xssURIPatternList) {
            if (!context.contains(pattern)) continue;
            patternMatched = true;
            break;
        }
        return patternMatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildScriptPatterns() {
        patternList = new ArrayList();
        if (patterPath != null && !patterPath.isEmpty()) {
            FileInputStream inStream = null;
            File xssPatternConfigFile = new File(patterPath);
            Properties properties = new Properties();
            if (xssPatternConfigFile.exists()) {
                try {
                    inStream = new FileInputStream(xssPatternConfigFile);
                    properties.load(inStream);
                }
                catch (FileNotFoundException e) {
                    log.error((Object)"Can not load xssPatternConfig properties file ", (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)"Can not load xssPatternConfigFile properties file ", (Throwable)e);
                }
                finally {
                    if (inStream != null) {
                        try {
                            ((InputStream)inStream).close();
                        }
                        catch (IOException e) {
                            log.error((Object)"Error while closing stream ", (Throwable)e);
                        }
                    }
                }
            }
            if (!properties.isEmpty()) {
                for (String key : properties.stringPropertyNames()) {
                    String value = properties.getProperty(key);
                    patternList.add(Pattern.compile(value, 42));
                }
            }
        }
    }

    static {
        log = LogFactory.getLog(XSSValve.class);
    }
}

