/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.valve;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Scanner;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;
import org.wso2.carbon.utils.CarbonUtils;

public class ErrorHandleValve
extends ErrorReportValve {
    private boolean showReport = true;
    private boolean showServerInfo = true;
    private static String exceptionResponseHtml = null;
    private static final Log log = LogFactory.getLog(ErrorHandleValve.class);

    protected void report(Request request, Response response, Throwable throwable) {
        block13: {
            int statusCode = response.getStatus();
            if (statusCode < 400 || response.getContentWritten() > 0L || !response.setErrorReported()) {
                return;
            }
            String message = this.filter(response.getMessage());
            if (message == null) {
                String exceptionMessage;
                if (throwable != null && (exceptionMessage = throwable.getMessage()) != null && exceptionMessage.length() > 0) {
                    message = this.filter(new Scanner(exceptionMessage).nextLine());
                }
                if (message == null) {
                    message = "";
                }
            }
            String report = null;
            StringManager smClient = StringManager.getManager((String)"org.apache.catalina.valves", (Enumeration)request.getLocales());
            response.setLocale(smClient.getLocale());
            try {
                report = smClient.getString("http." + statusCode);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
            }
            if (report == null) {
                if (message.length() == 0) {
                    return;
                }
                report = smClient.getString("errorReportValve.noDescription");
            }
            try {
                try {
                    response.setContentType("text/html");
                    response.setCharacterEncoding("utf-8");
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                }
                PrintWriter writer = response.getReporter();
                if (writer != null) {
                    ((Writer)writer).write(this.getExceptionResponseHtml(throwable, statusCode, message, report, smClient));
                    response.finishResponse();
                }
            }
            catch (IOException | IllegalStateException e) {
                if (!log.isDebugEnabled()) break block13;
                log.debug((Object)"Error while writing the HTML response", (Throwable)e);
            }
        }
    }

    private String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    private String buildDefaultErrorResponse(Throwable throwable, int statusCode, String message, String report, StringManager smClient) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head>");
        if (this.showServerInfo || this.showReport) {
            sb.append("<title>");
            if (this.showServerInfo) {
                sb.append(ServerInfo.getServerInfo()).append(" - ");
            }
            sb.append(smClient.getString("errorReportValve.errorReport"));
            sb.append("</title>");
            sb.append("<style><!--");
            sb.append("body {font-family:Tahoma,Arial,sans-serif;} h1, h2, h3, b {color:white;background-color:#525D76;} h1 {font-size:22px;} h2 {font-size:16px;} h3 {font-size:14px;} p {font-size:12px;} a {color:black;} .line {height:1px;background-color:#525D76;border:none;}");
            sb.append("--></style> ");
        } else {
            sb.append("<title>");
            sb.append(smClient.getString("errorReportValve.errorReport"));
            sb.append("</title>");
        }
        sb.append("</head><body>");
        sb.append("<h1>");
        sb.append(smClient.getString("errorReportValve.statusHeader", new Object[]{String.valueOf(statusCode), message})).append("</h1>");
        if (this.showReport) {
            sb.append("<HR size=\"1\" noshade=\"noshade\">");
            sb.append("<p><b>type</b> ");
            if (throwable != null) {
                sb.append(smClient.getString("errorReportValve.exceptionReport"));
            } else {
                sb.append(smClient.getString("errorReportValve.statusReport"));
            }
            sb.append("</p>");
            sb.append("<p><b>");
            sb.append(smClient.getString("errorReportValve.message"));
            sb.append("</b> <u>");
            sb.append(message).append("</u></p>");
            sb.append("<p><b>");
            sb.append(smClient.getString("errorReportValve.description"));
            sb.append("</b> <u>");
            sb.append(report);
            sb.append("</u></p>");
            if (throwable != null) {
                String stackTrace = this.getPartialServletStackTrace(throwable);
                sb.append("<p><b>");
                sb.append(smClient.getString("errorReportValve.exception"));
                sb.append("</b> <pre>");
                sb.append(this.filter(stackTrace));
                sb.append("</pre></p>");
                int loops = 0;
                for (Throwable rootCause = throwable.getCause(); rootCause != null && loops < 10; rootCause = rootCause.getCause(), ++loops) {
                    stackTrace = this.getPartialServletStackTrace(rootCause);
                    sb.append("<p><b>");
                    sb.append(smClient.getString("errorReportValve.rootCause"));
                    sb.append("</b> <pre>");
                    sb.append(this.filter(stackTrace));
                    sb.append("</pre></p>");
                }
                sb.append("<p><b>");
                sb.append(smClient.getString("errorReportValve.note"));
                sb.append("</b> <u>");
                sb.append(smClient.getString("errorReportValve.rootCauseInLogs", new Object[]{this.showServerInfo ? ServerInfo.getServerInfo() : ""}));
                sb.append("</u></p>");
            }
            sb.append("<HR size=\"1\" noshade=\"noshade\">");
        }
        if (this.showServerInfo) {
            sb.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public void setShowReport(boolean showReport) {
        this.showReport = showReport;
    }

    public boolean isShowReport() {
        return this.showReport;
    }

    public void setShowServerInfo(boolean showServerInfo) {
        this.showServerInfo = showServerInfo;
    }

    public boolean isShowServerInfo() {
        return this.showServerInfo;
    }

    private String getExceptionResponseHtml(Throwable throwable, int statusCode, String message, String report, StringManager smClient) {
        if (exceptionResponseHtml != null) {
            return exceptionResponseHtml;
        }
        String redirectHtmlPath = null;
        try {
            redirectHtmlPath = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "identity" + File.separator + "pages" + File.separator + "server_error_response.html";
            FileInputStream fis = new FileInputStream(new File(redirectHtmlPath));
            exceptionResponseHtml = new Scanner((InputStream)fis, "UTF-8").useDelimiter("\\A").next();
        }
        catch (FileNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Showing default error page, '" + redirectHtmlPath + "' not found"));
            }
            exceptionResponseHtml = this.buildDefaultErrorResponse(throwable, statusCode, message, report, smClient);
        }
        return exceptionResponseHtml;
    }
}

