/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.taglibs;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ui.taglibs.JSi18n;
import org.wso2.carbon.ui.taglibs.Paginator;

public class ResourcePaginator
extends Paginator {
    private static final String END = "end";
    private static final String MIDDLE = "middle";
    private static final String START = "start";
    private static final Log log = LogFactory.getLog(ResourcePaginator.class);
    private String paginationFunction = null;
    private int tdColSpan = 0;

    public String getPaginationFunction() {
        return this.paginationFunction;
    }

    public void setPaginationFunction(String paginationFunction) {
        this.paginationFunction = paginationFunction;
    }

    public int getTdColSpan() {
        return this.tdColSpan;
    }

    public void setTdColSpan(int tdColSpan) {
        this.tdColSpan = tdColSpan;
    }

    @Override
    public int doEndTag() throws JspException {
        if (this.getNumberOfPages() < 2) {
            return 0;
        }
        String next = "Next";
        String prev = "Prev";
        String pageName = "Page {0}";
        if (this.getResourceBundle() != null) {
            try {
                Locale locale = JSi18n.getLocaleFromPageContext(this.pageContext);
                ResourceBundle bundle = ResourceBundle.getBundle(this.getResourceBundle(), locale);
                next = bundle.getString(this.getNextKey());
                prev = bundle.getString(this.getPrevKey());
            }
            catch (Exception e) {
                log.warn((Object)"Error while i18ning paginator", (Throwable)e);
            }
        }
        JspWriter writer = this.pageContext.getOut();
        StringBuffer content = new StringBuffer("<tr><td ");
        if (this.tdColSpan > 0) {
            content.append("colspan=\"").append(this.tdColSpan).append("\" ");
        }
        content.append("class=\"pagingRow\" style=\"text-align:center;padding-top:10px; padding-bottom:10px;\">");
        if (this.getPageNumber() == 1) {
            content.append("<span class=\"disableLink\">< ").append(prev).append("</span>");
        } else {
            content.append("<a class=\"pageLinks\" title=\"").append(pageName.replace("{0}", Integer.toString(this.getPageNumber() - 1))).append("\"");
            if (this.getPaginationFunction() != null) {
                content.append("onclick=\"").append(this.getPaginationFunction().replace("{0}", Integer.toString(this.getPageNumber() - 1))).append("\"");
            }
            content.append(">< ").append(prev).append("</a>");
        }
        if (this.getNumberOfPages() <= 10) {
            for (int pageItem = 1; pageItem <= this.getNumberOfPages(); ++pageItem) {
                content.append("<a title=\"").append(pageName.replace("{0}", Integer.toString(pageItem))).append("\" class=\"");
                if (this.getPageNumber() == pageItem) {
                    content.append("pageLinks-selected\"");
                } else {
                    content.append("pageLinks\"");
                }
                if (this.getPaginationFunction() != null) {
                    content.append("onclick=\"").append(this.getPaginationFunction().replace("{0}", Integer.toString(pageItem))).append("\"");
                }
                content.append(">").append(pageItem).append("</a>");
            }
        } else {
            int pageItem;
            String place = MIDDLE;
            int pageItemFrom = this.getPageNumber() - 2;
            int pageItemTo = this.getPageNumber() + 2;
            if (this.getNumberOfPages() - this.getPageNumber() <= 5) {
                place = END;
            }
            if (this.getPageNumber() <= 5) {
                place = START;
            }
            if (START.equals(place)) {
                pageItemFrom = 1;
                pageItemTo = 7;
            }
            if (END.equals(place)) {
                pageItemFrom = this.getNumberOfPages() - 7;
                pageItemTo = this.getNumberOfPages();
            }
            if (END.equals(place) || MIDDLE.equals(place)) {
                for (pageItem = 1; pageItem <= 2; ++pageItem) {
                    content.append("<a title=\"").append(pageName.replace("{0}", Integer.toString(pageItem))).append("\" class=\"pageLinks\"");
                    if (this.getPaginationFunction() != null) {
                        content.append("onclick=\"").append(this.getPaginationFunction().replace("{0}", Integer.toString(pageItem))).append("\"");
                    }
                    content.append(">").append(pageItem).append("</a>");
                }
                content.append("...");
            }
            for (pageItem = pageItemFrom; pageItem <= pageItemTo; ++pageItem) {
                content.append("<a title=\"").append(pageName.replace("{0}", Integer.toString(pageItem))).append("\" class=\"");
                if (this.getPageNumber() == pageItem) {
                    content.append("pageLinks-selected\"");
                } else {
                    content.append("pageLinks\"");
                }
                if (this.getPaginationFunction() != null) {
                    content.append("onclick=\"").append(this.getPaginationFunction().replace("{0}", Integer.toString(pageItem))).append("\"");
                }
                content.append(">").append(pageItem).append("</a>");
            }
            if (START.equals(place) || MIDDLE.equals(place)) {
                content.append("...");
                for (pageItem = this.getNumberOfPages() - 1; pageItem <= this.getNumberOfPages(); ++pageItem) {
                    content.append("<a title=\"").append(pageName.replace("{0}", Integer.toString(pageItem))).append("\" class=\"pageLinks\"");
                    if (this.getPaginationFunction() != null) {
                        content.append("onclick=\"").append(this.getPaginationFunction().replace("{0}", Integer.toString(pageItem))).append("\"");
                    }
                    content.append("style=\"margin-left:5px;margin-right:5px;\">").append(pageItem).append("</a>");
                }
            }
        }
        if (this.getPageNumber() == this.getNumberOfPages()) {
            content.append("<span class=\"disableLink\">").append(next).append(" ></span>");
        } else {
            content.append("<a class=\"pageLinks\" title=\"").append(pageName.replace("{0}", Integer.toString(this.getPageNumber() + 1))).append("\"");
            if (this.getPaginationFunction() != null) {
                content.append("onclick=\"").append(this.getPaginationFunction().replace("{0}", Integer.toString(this.getPageNumber() + 1))).append("\"");
            }
            content.append(">").append(next).append(" ></a>");
        }
        content.append("<span id=\"xx").append(this.getPageNumber()).append("\" style=\"display:none\" /></td></tr>");
        try {
            writer.write(content.toString());
        }
        catch (IOException e) {
            String msg = "Cannot write paginator tag content";
            log.error((Object)msg, (Throwable)e);
            throw new JspException(msg, (Throwable)e);
        }
        return 0;
    }
}

