/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.taglibs;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ui.taglibs.JSi18n;

public class Paginator
extends BodyTagSupport {
    private static final Log log = LogFactory.getLog(Paginator.class);
    private int pageNumber;
    private int numberOfPages;
    private int noOfPageLinksToDisplay = 5;
    private String page;
    private String pageNumberParameterName;
    private String resourceBundle;
    private String nextKey;
    private String prevKey;
    private String action;
    private String parameters = "";
    private boolean showPageNumbers = true;

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(int numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getPageNumberParameterName() {
        return this.pageNumberParameterName;
    }

    public void setPageNumberParameterName(String pageNumberParameterName) {
        this.pageNumberParameterName = pageNumberParameterName;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getNextKey() {
        return this.nextKey;
    }

    public void setNextKey(String nextKey) {
        this.nextKey = nextKey;
    }

    public String getPrevKey() {
        return this.prevKey;
    }

    public void setPrevKey(String prevKey) {
        this.prevKey = prevKey;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public String getShowPageNumbers() {
        return "" + this.showPageNumbers;
    }

    public void setShowPageNumbers(String showPageNumbers) {
        this.showPageNumbers = Boolean.valueOf(showPageNumbers);
    }

    public int getNoOfPageLinksToDisplay() {
        return this.noOfPageLinksToDisplay;
    }

    public void setNoOfPageLinksToDisplay(int noOfPageLinksToDisplay) {
        this.noOfPageLinksToDisplay = noOfPageLinksToDisplay;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public int doEndTag() throws JspException {
        String next = "next";
        String prev = "prev";
        if (this.resourceBundle != null) {
            try {
                Locale locale = JSi18n.getLocaleFromPageContext(this.pageContext);
                ResourceBundle bundle = ResourceBundle.getBundle(this.resourceBundle, locale);
                next = bundle.getString(this.nextKey);
                prev = bundle.getString(this.prevKey);
            }
            catch (Exception e) {
                log.warn((Object)"Error while i18ning paginator", (Throwable)e);
            }
        }
        JspWriter writer = this.pageContext.getOut();
        String content = "<table><tr>";
        if (this.numberOfPages > 1) {
            content = this.pageNumber > 0 ? (!"post".equals(this.action) ? content + "<td><strong><a href=\"" + this.page + "?" + this.pageNumberParameterName + "=0&" + this.parameters + "\">&lt;&lt;first&nbsp;&nbsp;</a></strong></td><td><strong><a href=\"" + this.page + "?" + this.pageNumberParameterName + "=" + (this.pageNumber - 1) + "&" + this.parameters + "\">&lt;&nbsp;" + prev + "&nbsp;&nbsp;</a></strong></td>" : content + "<td><strong><a href=# onclick=\"doPaginate('" + this.page + "','" + this.pageNumberParameterName + "','" + 0 + "')\">&lt;&lt;first&nbsp;&nbsp;</a></strong></td><td><strong><a href=# onclick=\"doPaginate('" + this.page + "','" + this.pageNumberParameterName + "','" + (this.pageNumber - 1) + "')\">&lt;&nbsp;" + prev + "&nbsp;&nbsp;</a></strong></td>") : content + "<td ><strong ><span style=\"color:gray\">&lt;&lt; first &nbsp;&nbsp;&lt;" + prev + "&nbsp;&nbsp;</span></strong></td>";
            if (this.showPageNumbers) {
                int lastLinkNo;
                int firstLinkNo;
                if (this.noOfPageLinksToDisplay % 2 == 0) {
                    firstLinkNo = this.pageNumber - (this.noOfPageLinksToDisplay / 2 - 1) < 0 ? 0 : this.pageNumber - (this.noOfPageLinksToDisplay / 2 - 1);
                    lastLinkNo = this.pageNumber + this.noOfPageLinksToDisplay / 2 > this.numberOfPages - 1 ? this.numberOfPages - 1 : this.pageNumber + this.noOfPageLinksToDisplay / 2;
                } else {
                    firstLinkNo = this.pageNumber - (int)Math.floor(this.noOfPageLinksToDisplay / 2) < 0 ? 0 : this.pageNumber - (int)Math.floor(this.noOfPageLinksToDisplay / 2);
                    lastLinkNo = this.pageNumber + (int)Math.floor(this.noOfPageLinksToDisplay / 2) > this.numberOfPages - 1 ? this.numberOfPages - 1 : this.pageNumber + (int)Math.floor(this.noOfPageLinksToDisplay / 2);
                }
                if (firstLinkNo != 0) {
                    content = content + "<td><strong> ... &nbsp;&nbsp;</strong></td> ";
                }
                for (int i = firstLinkNo; i <= lastLinkNo; ++i) {
                    content = i == this.pageNumber ? content + "<td><strong>" + (i + 1) + "&nbsp;&nbsp;</strong></td>" : (!"post".equals(this.action) ? content + "<td><strong><a href=\"" + this.page + "?" + this.pageNumberParameterName + "=" + i + "&" + this.parameters + "\">" + (i + 1) + " &nbsp;&nbsp;</a></strong></td>" : content + "<td><strong><a href=# onclick=\"doPaginate('" + this.page + "','" + this.pageNumberParameterName + "','" + i + "')\">" + (i + 1) + " &nbsp;&nbsp;</a></strong></td>");
                }
                if (lastLinkNo != this.numberOfPages - 1) {
                    content = content + "<td><strong> ... &nbsp;&nbsp;</strong></td> ";
                }
            } else {
                content = content + "<td><strong> Page &nbsp;&nbsp;" + (this.pageNumber + 1) + " of  " + this.numberOfPages + " &nbsp;&nbsp;</strong></td>";
            }
            content = this.pageNumber < this.numberOfPages - 1 ? (!"post".equals(this.action) ? content + "<td ><strong ><a href =\"" + this.page + "?" + this.pageNumberParameterName + "=" + (this.pageNumber + 1) + "&" + this.parameters + "\">" + next + "&nbsp;&gt;</a></strong></td><td ><strong ><a href =\"" + this.page + "?" + this.pageNumberParameterName + "=" + (this.numberOfPages - 1) + "&" + this.parameters + "\">&nbsp;&nbsp;last&nbsp;&gt;&gt;</a></strong></td>" : content + "<td ><strong><a href=# onclick=\"doPaginate('" + this.page + "','" + this.pageNumberParameterName + "','" + (this.pageNumber + 1) + "')\">" + next + "&nbsp;&gt;</a></strong></td><td ><strong ><a href=# onclick=\"doPaginate('" + this.page + "','" + this.pageNumberParameterName + "','" + (this.numberOfPages - 1) + "')\">&nbsp;&nbsp;last&nbsp;&gt;&gt;</a></strong></td>") : content + "<td ><strong ><span style=\"color:gray\">" + next + " &gt;&nbsp;&nbsp;last&gt;&gt; </span></strong></td>";
        }
        content = content + "</tr ></table > ";
        try {
            writer.write(content);
        }
        catch (IOException e) {
            String msg = "Cannot write paginator tag content";
            log.error((Object)msg, (Throwable)e);
            throw new JspException(msg, (Throwable)e);
        }
        return 0;
    }
}

