/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.ui.filters.csrf.CSRFFilterConfig;
import org.wso2.carbon.ui.filters.csrf.CSRFProtector;
import org.wso2.carbon.ui.filters.csrf.CSRFResponseWrapper;

public class CSRFPreventionFilter
implements Filter {
    private CSRFProtector protector;

    public void init(FilterConfig filterConfig) throws ServletException {
        CSRFFilterConfig config = new CSRFFilterConfig();
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        config.setEnabled(serverConfiguration.getFirstProperty("Security.CSRFPreventionConfig.CSRFPreventionFilter.Enabled") == null ? false : Boolean.parseBoolean(serverConfiguration.getFirstProperty("Security.CSRFPreventionConfig.CSRFPreventionFilter.Enabled")));
        config.setSkipUrlPattern(serverConfiguration.getFirstProperty("Security.CSRFPreventionConfig.CSRFPreventionFilter.SkipUrlPattern"));
        this.protector = new CSRFProtector(config);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.protector.getConfig().isEnabled() && servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            if (this.protector.skipUrl(request.getRequestURI())) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            CSRFResponseWrapper responseWrapper = new CSRFResponseWrapper(response);
            this.protector.applyProtection(request, responseWrapper);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
            this.protector.enforceProtection(request, responseWrapper);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

