/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.deployment.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.ui.deployment.beans.Context;
import org.wso2.carbon.ui.deployment.beans.Menu;
import org.wso2.carbon.ui.deployment.beans.Servlet;

public class CarbonUIDefinitions {
    private static Log log = LogFactory.getLog(CarbonUIDefinitions.class);
    private List<Menu> menuDefinitions = new CopyOnWriteArrayList<Menu>();
    private List<Servlet> servletDefinitions = new ArrayList<Servlet>();
    private HashMap<String, String> unauthenticatedUrls = new HashMap();
    private HashMap<String, String> skipTilesUrls = new HashMap();
    private HashMap<String, String> httpUrls = new HashMap();
    private HashMap<String, Context> contexts = new HashMap();

    public void addContexts(List<Context> contexts) {
        for (Context ctx : contexts) {
            this.addContexts(ctx.getContextId(), ctx);
        }
    }

    public void removeContexts(List<Context> contexts) {
        for (Context ctx : contexts) {
            this.removeContexts(ctx);
        }
    }

    public void addContexts(String contextId, Context context) {
        this.contexts.put(contextId, context);
    }

    public void removeContexts(Context context) {
        this.contexts.remove(context.getContextId());
    }

    public HashMap<String, Context> getContexts() {
        return this.contexts;
    }

    public void addHttpUrls(List<String> urls) {
        for (String url : urls) {
            this.addHttpUrls(url);
        }
    }

    public void removeHttpUrls(List<String> urls) {
        for (String url : urls) {
            this.removeHttpUrls(url);
        }
    }

    public void addHttpUrls(String url) {
        this.httpUrls.put(url, url);
    }

    public void removeHttpUrls(String url) {
        this.httpUrls.remove(url);
    }

    public HashMap<String, String> getHttpUrls() {
        return this.httpUrls;
    }

    public void addUnauthenticatedUrls(List<String> urls) {
        for (String url : urls) {
            this.addUnauthenticatedUrls(url);
        }
    }

    public void removeUnauthenticatedUrls(List<String> urls) {
        for (String url : urls) {
            this.removeUnauthenticatedUrls(url);
        }
    }

    public void addUnauthenticatedUrls(String url) {
        this.unauthenticatedUrls.put(url, url);
    }

    public void removeUnauthenticatedUrls(String url) {
        this.unauthenticatedUrls.remove(url);
    }

    public HashMap<String, String> getUnauthenticatedUrls() {
        return this.unauthenticatedUrls;
    }

    public void addSkipTilesUrls(List<String> urls) {
        for (String url : urls) {
            this.addSkipTilesUrls(url);
        }
    }

    public void removeSkipTilesUrls(List<String> urls) {
        for (String url : urls) {
            this.removeSkipTilesUrls(url);
        }
    }

    public void addSkipTilesUrls(String url) {
        this.skipTilesUrls.put(url, url);
    }

    public void removeSkipTilesUrls(String url) {
        this.skipTilesUrls.remove(url);
    }

    public HashMap<String, String> getSkipTilesUrls() {
        return this.skipTilesUrls;
    }

    public void removeMenuDefinition(String menuId) {
        if (menuId != null && menuId.trim().length() > 0) {
            for (Menu menu : this.menuDefinitions) {
                if (menu == null || !menuId.equals(menu.getId())) continue;
                this.menuDefinitions.remove(menu);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Removing menu item : " + menuId));
            }
        }
    }

    public Menu[] getMenuDefinitions(String loggedInUserName, boolean isSuperTenant, ArrayList<String> userPermissions, HttpServletRequest request) {
        return this.getMenuDefinitions(loggedInUserName, isSuperTenant, userPermissions, request, this.menuDefinitions.toArray(new Menu[0]));
    }

    public Menu[] getMenuDefinitions(String loggedInUserName, boolean isSuperTenant, ArrayList<String> userPermissions, HttpServletRequest request, Menu[] currentMenuItems) {
        if (loggedInUserName != null) {
            ArrayList<Menu> filteredMenuDefs = new ArrayList<Menu>();
            for (int a = 0; a < currentMenuItems.length; ++a) {
                String[] requiredPermissions;
                String serverInServiceMode = ServerConfiguration.getInstance().getFirstProperty("IsCloudDeployment");
                Menu menu = currentMenuItems[a];
                boolean continueAdding = true;
                if (menu.isRequireSuperTenant() && !isSuperTenant) {
                    continueAdding = false;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("User : " + loggedInUserName + " is not logged in from super tenant to access menu -> " + menu));
                    }
                } else if (menu.isRequireNotSuperTenant() && isSuperTenant) {
                    continueAdding = false;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("User : " + loggedInUserName + " is not logged in from non super tenant to access menu -> " + menu));
                    }
                } else if (menu.isRequireNotLoggedIn() && loggedInUserName != null) {
                    continueAdding = false;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("User : " + loggedInUserName + " is logged in, the menu only shows when not logged in -> " + menu));
                    }
                } else if (menu.isRequireCloudDeployment() && !"true".equals(serverInServiceMode)) {
                    continueAdding = false;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Server is not running in a cloud deployment, the menu is only shown when running in cloud deployment -> " + menu));
                    }
                }
                if (!continueAdding || (requiredPermissions = menu.getRequirePermission()) == null) continue;
                int grantCount = 0;
                for (String requiredPermission : requiredPermissions) {
                    requiredPermission = StringUtils.trim((String)requiredPermission);
                    int temp = grantCount;
                    for (String grantedPermission : userPermissions) {
                        if ("*".equals(requiredPermission)) {
                            ++grantCount;
                            break;
                        }
                        if (!(requiredPermission = requiredPermission.replaceAll("\\s", "")).startsWith("/")) {
                            grantCount = requiredPermissions.length;
                            log.error((Object)(" Attention :: Permission issue in Menu item " + menu.getId()));
                            break;
                        }
                        if (!requiredPermission.startsWith(grantedPermission)) continue;
                        ++grantCount;
                        break;
                    }
                    if (temp != grantCount || menu.isAtLeastOnePermissionsRequired()) continue;
                    grantCount = 0;
                    break;
                }
                if (grantCount < requiredPermissions.length && (grantCount <= 0 || !menu.isAtLeastOnePermissionsRequired())) continue;
                filteredMenuDefs.add(menu);
            }
            Menu[] filteredMenus = new Menu[filteredMenuDefs.size()];
            request.getSession().setAttribute("UserMenuItemsFiltered", (Object)"true");
            return filteredMenuDefs.toArray(filteredMenus);
        }
        request.getSession().setAttribute("UserMenuItemsFiltered", (Object)"false");
        return currentMenuItems;
    }

    private HashMap<String, String> getGrantedPermissions(String userName, ArrayList<String> userPermissions) {
        HashMap<String, String> userRoles = new HashMap<String, String>();
        for (String permission : userPermissions) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User : " + userName + " has permission : " + permission));
            }
            userRoles.put(permission, permission);
        }
        return userRoles;
    }

    public void addMenuItems(Menu[] newMenuDefinitions) {
        for (Menu menu : newMenuDefinitions) {
            this.menuDefinitions.add(menu);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Adding new menu itesm : " + menu));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Listing all menu items as of now...");
            for (Menu menu : this.menuDefinitions) {
                log.debug((Object)("--->" + menu));
            }
        }
    }

    public void removeMenuItems(Menu[] menuDefinitionsToBeRemoved) {
        for (Menu menu : menuDefinitionsToBeRemoved) {
            this.removeMenuDefinition(menu.getId());
        }
    }

    public Servlet[] getServletDefinitions() {
        return this.servletDefinitions.toArray(new Servlet[0]);
    }

    public void addServletItems(Servlet[] newServletDefinitions) {
        for (Servlet servlet : newServletDefinitions) {
            this.servletDefinitions.add(servlet);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added new servlet definition " + servlet));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Listing all Servlet items as of now...");
            for (Servlet servlet : this.servletDefinitions) {
                log.debug((Object)("--->" + servlet));
            }
        }
    }

    public void removeServletItems(Servlet[] servletDefinitionsToRemoved) {
        for (Servlet servlet : servletDefinitionsToRemoved) {
            if (this.servletDefinitions.contains(servlet)) {
                this.servletDefinitions.remove(servlet);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("removing the servlet definition : " + servlet));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Listing all Servlet items as of now...");
            for (Servlet servlet : this.servletDefinitions) {
                log.debug((Object)("--->" + servlet));
            }
        }
    }
}

